/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.dynamicresources;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.apache.commons.lang3.tuple.Triple;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBakedModelProvider
implements Map<class_2960, class_1087> {
    private static final ImmutableSet<class_2960> BAKE_SKIPPED_TOPLEVEL = ImmutableSet.builder().add((Object)new class_2960("custommachinery", "block/custom_machine_block")).build();
    public static DynamicBakedModelProvider currentInstance = null;
    private final class_1088 bakery;
    private final Map<Triple<class_2960, class_4590, Boolean>, class_1087> bakedCache;
    private final Map<class_2960, class_1087> permanentOverrides;
    private class_1087 missingModel;
    private static final class_1087 SENTINEL = new class_1087(){

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 side, Random rand) {
            return null;
        }

        public boolean method_4708() {
            return false;
        }

        public boolean method_4712() {
            return false;
        }

        public boolean method_24304() {
            return false;
        }

        public boolean method_4713() {
            return false;
        }

        public class_1058 method_4711() {
            return null;
        }

        public class_809 method_4709() {
            return null;
        }

        public class_806 method_4710() {
            return null;
        }
    };

    public DynamicBakedModelProvider(class_1088 bakery, Map<Triple<class_2960, class_4590, Boolean>, class_1087> cache) {
        this.bakery = bakery;
        this.bakedCache = cache;
        this.permanentOverrides = Collections.synchronizedMap(new Object2ObjectOpenHashMap());
        if (currentInstance == null) {
            currentInstance = this;
        }
    }

    public void setMissingModel(class_1087 model) {
        this.missingModel = model;
    }

    private static Triple<class_2960, class_4590, Boolean> vanillaKey(Object o) {
        return Triple.of((Object)((class_2960)o), (Object)class_1086.field_5350.method_3509(), (Object)false);
    }

    @Override
    public int size() {
        return this.bakedCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bakedCache.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.permanentOverrides.getOrDefault(o, SENTINEL) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.permanentOverrides.containsValue(o) || this.bakedCache.containsValue(o);
    }

    private static boolean isVanillaTopLevelModel(class_2960 location) {
        if (location instanceof class_1091) {
            try {
                class_1091 mrl = (class_1091)location;
                class_2960 registryKey = new class_2960(mrl.method_12836(), mrl.method_12832());
                if (mrl.method_4740().equals("inventory") && class_2378.field_11142.method_10250(registryKey)) {
                    return true;
                }
                Optional blockOpt = class_2378.field_11146.method_17966(registryKey);
                if (blockOpt.isPresent()) {
                    return ModelBakeryHelpers.getBlockStatesForMRL((class_2689<class_2248, class_2680>)((class_2248)blockOpt.get()).method_9595(), mrl).size() > 0;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return location.method_12836().equals("minecraft") && location.method_12832().equals("builtin/missing");
    }

    @Override
    public class_1087 get(Object o) {
        class_1087 model = this.permanentOverrides.getOrDefault(o, SENTINEL);
        if (model != SENTINEL) {
            return model;
        }
        try {
            model = BAKE_SKIPPED_TOPLEVEL.contains((Object)((class_2960)o)) ? this.missingModel : this.bakery.method_15878((class_2960)o, (class_3665)class_1086.field_5350);
        }
        catch (RuntimeException e) {
            ModernFix.LOGGER.error("Exception baking {}: {}", o, (Object)e);
            model = this.missingModel;
        }
        if (model == this.missingModel) {
            model = DynamicBakedModelProvider.isVanillaTopLevelModel((class_2960)o) ? model : null;
            this.permanentOverrides.put((class_2960)o, model);
        }
        return model;
    }

    @Override
    public class_1087 put(class_2960 resourceLocation, class_1087 bakedModel) {
        class_1087 m = this.permanentOverrides.put(resourceLocation, bakedModel);
        if (m != null) {
            return m;
        }
        return this.bakedCache.get(DynamicBakedModelProvider.vanillaKey(resourceLocation));
    }

    @Override
    public class_1087 remove(Object o) {
        class_1087 m = this.permanentOverrides.remove(o);
        if (m != null) {
            return m;
        }
        return this.bakedCache.remove(DynamicBakedModelProvider.vanillaKey(o));
    }

    @Override
    public void putAll(@NotNull Map<? extends class_2960, ? extends class_1087> map) {
        this.permanentOverrides.putAll(map);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<class_2960> keySet() {
        return this.bakedCache.keySet().stream().map(Triple::getLeft).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<class_1087> values() {
        return this.bakedCache.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<class_2960, class_1087>> entrySet() {
        return this.bakedCache.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry<class_2960, class_1087>((class_2960)((Triple)entry.getKey()).getLeft(), (class_1087)entry.getValue())).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public class_1087 replace(class_2960 key, class_1087 value) {
        class_1087 existingOverride = this.permanentOverrides.get(key);
        if (existingOverride == null) {
            return this.put(key, value);
        }
        return existingOverride;
    }

    @Override
    public void replaceAll(BiFunction<? super class_2960, ? super class_1087, ? extends class_1087> function) {
        Set<class_2960> overridenLocations = this.permanentOverrides.keySet();
        this.permanentOverrides.replaceAll(function);
        boolean uvLock = class_1086.field_5350.method_3512();
        class_4590 rotation = class_1086.field_5350.method_3509();
        this.bakedCache.replaceAll((? super K loc, ? super V oldModel) -> {
            if (loc.getMiddle() != rotation || (Boolean)loc.getRight() != uvLock || overridenLocations.contains(loc.getLeft())) {
                return oldModel;
            }
            return (class_1087)function.apply((class_2960)loc.getLeft(), (class_1087)oldModel);
        });
    }
}

