/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.cache_strongholds;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2794;
import net.minecraft.class_3218;
import net.minecraft.class_6871;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.duck.IChunkGenerator;
import org.embeddedt.modernfix.duck.IServerLevel;
import org.embeddedt.modernfix.world.StrongholdLocationCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2794.class})
public class ChunkGeneratorMixin
implements IChunkGenerator {
    private WeakReference<class_3218> mfix$serverLevel;

    @Override
    public void mfix$setAssociatedServerLevel(class_3218 level) {
        this.mfix$serverLevel = new WeakReference<class_3218>(level);
    }

    @Inject(method={"generateRingPositions"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCachedDataIfAvailable(class_6880<class_7059> setHolder, class_6871 placement, CallbackInfoReturnable<CompletableFuture<List<class_1923>>> cir) {
        if (placement.comp_339() == 0) {
            return;
        }
        class_3218 level = this.searchLevel();
        if (level == null) {
            return;
        }
        StrongholdLocationCache cache = ((IServerLevel)level).mfix$getStrongholdCache();
        List<class_1923> positions = cache.getChunkPosList();
        if (positions.isEmpty()) {
            return;
        }
        ModernFix.LOGGER.debug("Loaded stronghold cache for dimension {} with {} positions", (Object)level.method_27983().method_29177(), (Object)positions.size());
        cir.setReturnValue(CompletableFuture.completedFuture(positions));
    }

    private class_3218 searchLevel() {
        if (this.mfix$serverLevel != null) {
            return (class_3218)this.mfix$serverLevel.get();
        }
        return null;
    }

    @Inject(method={"generateRingPositions"}, at={@At(value="RETURN")}, cancellable=true)
    private void saveCachedData(class_6880<class_7059> setHolder, class_6871 placement, CallbackInfoReturnable<CompletableFuture<List<class_1923>>> cir) {
        cir.setReturnValue((Object)((CompletableFuture)cir.getReturnValue()).thenApplyAsync(list -> {
            if (list.size() == 0) {
                return list;
            }
            class_3218 level = this.searchLevel();
            if (level != null) {
                StrongholdLocationCache cache = ((IServerLevel)level).mfix$getStrongholdCache();
                cache.setChunkPosList((List<class_1923>)list);
                ModernFix.LOGGER.debug("Saved stronghold cache for dimension {}", (Object)level.method_27983().method_29177());
            }
            return list;
        }, (Executor)class_156.method_18349()));
    }
}

