/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3298;
import net.minecraft.class_6860;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.structure.CachingStructureManager;

public class ModernFixCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"modernfix").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"upgradeStructures").requires(source -> source.method_9259(3))).executes(context -> {
            class_3218 level = ((class_2168)context.getSource()).method_9225();
            if (level == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2585("Couldn't find server level"));
                return 0;
            }
            class_6860 manager = level.method_8503().field_25318.comp_352();
            Collection structures = manager.method_14488("structures", p -> p.endsWith(".nbt"));
            int upgradedNum = 0;
            Pattern pathPattern = Pattern.compile("^structures/(.*)\\.nbt$");
            for (class_2960 found : structures) {
                ++upgradedNum;
                Matcher matcher = pathPattern.matcher(found.method_12832());
                if (!matcher.matches()) continue;
                class_2960 structureLocation = new class_2960(found.method_12836(), matcher.group(1));
                try {
                    class_3298 resource = manager.method_14486(found);
                    try {
                        CachingStructureManager.readStructureTag(structureLocation, level.method_8503().method_3855(), resource.method_14482());
                        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("checked " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"), false);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Throwable e) {
                    ModernFix.LOGGER.error("Couldn't upgrade structure " + found, e);
                    ((class_2168)context.getSource()).method_9213((class_2561)new class_2585("error reading " + structureLocation + " (" + upgradedNum + "/" + structures.size() + ")"));
                }
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("All structures upgraded"), false);
            return 1;
        })));
    }
}

