/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.event.platform.PlatformUnreadyEvent;
import com.sk89q.worldedit.event.platform.PlatformsRegisteredEvent;
import com.sk89q.worldedit.event.platform.SessionIdleEvent;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extension.platform.PlatformManager;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.CommandWrapper;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePermissionsProvider;
import com.sk89q.worldedit.forge.ForgePlatform;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.net.handler.InternalPacketHandler;
import com.sk89q.worldedit.forge.net.handler.WECUIPacketHandler;
import com.sk89q.worldedit.forge.net.packet.LeftClickAirEventMessage;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import org.enginehub.piston.Command;

@Mod(value="worldedit")
public class ForgeWorldEdit {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    public static final String MOD_ID = "worldedit";
    public static final String CUI_PLUGIN_CHANNEL = "cui";
    private ForgePermissionsProvider provider;
    public static ForgeWorldEdit inst;
    private ForgePlatform platform;
    private ForgeConfiguration config;
    private Path workingDir;
    private ModContainer container;

    public ForgeWorldEdit() {
        inst = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::init);
        MinecraftForge.EVENT_BUS.register((Object)ThreadSafeCache.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            ModLoadingContext.class.getDeclaredMethod("registerExtensionPoint", Class.class, Supplier.class).invoke((Object)ModLoadingContext.get(), IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void init(FMLCommonSetupEvent event) {
        this.container = ModLoadingContext.get().getActiveContainer();
        this.workingDir = FMLPaths.CONFIGDIR.get().resolve(MOD_ID);
        if (!Files.exists(this.workingDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.workingDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        this.setupPlatform();
        WECUIPacketHandler.init();
        InternalPacketHandler.init();
        LOGGER.info("WorldEdit for Forge (version " + this.getInternalVersion() + ") is loaded");
    }

    private void setupPlatform() {
        this.platform = new ForgePlatform(this);
        WorldEdit.getInstance().getPlatformManager().register(this.platform);
        this.config = new ForgeConfiguration(this);
        this.provider = new ForgePermissionsProvider.VanillaPermissionsProvider(this.platform);
    }

    private void setupRegistries(MinecraftServer server) {
        for (ResourceLocation name2 : ForgeRegistries.BLOCKS.getKeys()) {
            if (BlockType.REGISTRY.get(name2.toString()) != null) continue;
            BlockType.REGISTRY.register(name2.toString(), new BlockType(name2.toString(), input -> ForgeAdapter.adapt(ForgeAdapter.adapt(input.getBlockType()).m_49966_())));
        }
        for (ResourceLocation name2 : ForgeRegistries.ITEMS.getKeys()) {
            if (ItemType.REGISTRY.get(name2.toString()) != null) continue;
            ItemType.REGISTRY.register(name2.toString(), new ItemType(name2.toString()));
        }
        for (ResourceLocation name2 : ForgeRegistries.ENTITIES.getKeys()) {
            if (EntityType.REGISTRY.get(name2.toString()) != null) continue;
            EntityType.REGISTRY.register(name2.toString(), new EntityType(name2.toString()));
        }
        for (ResourceLocation name2 : server.m_206579_().m_175515_(Registry.f_122885_).m_6566_()) {
            if (BiomeType.REGISTRY.get(name2.toString()) != null) continue;
            BiomeType.REGISTRY.register(name2.toString(), new BiomeType(name2.toString()));
        }
        Registry.f_122824_.m_203613_().map(TagKey::f_203868_).forEach(name -> {
            if (BlockCategory.REGISTRY.get(name.toString()) == null) {
                BlockCategory.REGISTRY.register(name.toString(), new BlockCategory(name.toString()));
            }
        });
        Registry.f_122827_.m_203613_().map(TagKey::f_203868_).forEach(name -> {
            if (ItemCategory.REGISTRY.get(name.toString()) == null) {
                ItemCategory.REGISTRY.register(name.toString(), new ItemCategory(name.toString()));
            }
        });
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        WorldEdit.getInstance().getEventBus().post(new PlatformsRegisteredEvent());
        PlatformManager manager = WorldEdit.getInstance().getPlatformManager();
        Platform commandsPlatform = manager.queryCapability(Capability.USER_COMMANDS);
        if (commandsPlatform != this.platform || !this.platform.isHookingEvents()) {
            return;
        }
        List commands = manager.getPlatformCommandManager().getCommandManager().getAllCommands().collect(Collectors.toList());
        for (Command command : commands) {
            CommandWrapper.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), command);
            Set perms = command.getCondition().as(PermissionCondition.class).map(PermissionCondition::getPermissions).orElseGet(Collections::emptySet);
            if (perms.isEmpty()) continue;
            perms.forEach(this.getPermissionsProvider()::registerPermission);
        }
    }

    @SubscribeEvent
    public void serverAboutToStart(ServerAboutToStartEvent event) {
        Path delChunks = this.workingDir.resolve("delete_chunks.json");
        if (Files.exists(delChunks, new LinkOption[0])) {
            ChunkDeleter.runFromFile(delChunks, true);
        }
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent event) {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        WorldEdit.getInstance().getEventBus().post(new PlatformUnreadyEvent(this.platform));
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent event) {
        this.setupRegistries(event.getServer());
        this.config.load();
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent(this.platform));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isRightDeny;
        if (this.platform == null) {
            return;
        }
        if (!this.platform.isHookingEvents()) {
            return;
        }
        if (event.getWorld().f_46443_ && event instanceof PlayerInteractEvent.LeftClickEmpty) {
            InternalPacketHandler.getHandler().sendToServer((Object)LeftClickAirEventMessage.INSTANCE);
            return;
        }
        boolean isLeftDeny = event instanceof PlayerInteractEvent.LeftClickBlock && ((PlayerInteractEvent.LeftClickBlock)event).getUseItem() == Event.Result.DENY;
        boolean bl = isRightDeny = event instanceof PlayerInteractEvent.RightClickBlock && ((PlayerInteractEvent.RightClickBlock)event).getUseItem() == Event.Result.DENY;
        if (isLeftDeny || isRightDeny || event.getEntity().f_19853_.f_46443_ || event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        WorldEdit we = WorldEdit.getInstance();
        ForgePlayer player = ForgeAdapter.adaptPlayer((ServerPlayer)event.getPlayer());
        ForgeWorld world = this.getWorld((ServerLevel)event.getPlayer().f_19853_);
        Direction direction = ForgeAdapter.adaptEnumFacing(event.getFace());
        if (event instanceof PlayerInteractEvent.LeftClickEmpty) {
            we.handleArmSwing(player);
        } else if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            Location pos = new Location((Extent)world, event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_());
            if (we.handleBlockLeftClick(player, pos, direction)) {
                event.setCanceled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickBlock) {
            Location pos = new Location((Extent)world, event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_());
            if (we.handleBlockRightClick(player, pos, direction)) {
                event.setCanceled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCanceled(true);
            }
        } else if (event instanceof PlayerInteractEvent.RightClickItem && we.handleRightClick(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onCommandEvent(net.minecraftforge.event.CommandEvent event) throws CommandSyntaxException {
        ParseResults parseResults = event.getParseResults();
        if (!(((CommandSourceStack)parseResults.getContext().getSource()).m_81373_() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = ((CommandSourceStack)parseResults.getContext().getSource()).m_81375_();
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (parseResults.getContext().getCommand() != CommandWrapper.FAKE_COMMAND) {
            return;
        }
        event.setCanceled(true);
        WorldEdit.getInstance().getEventBus().post(new CommandEvent(ForgeAdapter.adaptPlayer(((CommandSourceStack)parseResults.getContext().getSource()).m_81375_()), parseResults.getReader().getString()));
    }

    @SubscribeEvent
    public void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            WorldEdit.getInstance().getEventBus().post(new SessionIdleEvent(new ForgePlayer.SessionKeyImpl((ServerPlayer)event.getPlayer())));
        }
    }

    ForgeConfiguration getConfig() {
        return this.config;
    }

    public LocalSession getSession(ServerPlayer player) {
        Preconditions.checkNotNull((Object)player);
        return WorldEdit.getInstance().getSessionManager().get(ForgeAdapter.adaptPlayer(player));
    }

    public ForgeWorld getWorld(ServerLevel world) {
        Preconditions.checkNotNull((Object)world);
        return new ForgeWorld(world);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    String getInternalVersion() {
        return this.container.getModInfo().getVersion().toString();
    }

    public void setPermissionsProvider(ForgePermissionsProvider provider) {
        this.provider = provider;
    }

    public ForgePermissionsProvider getPermissionsProvider() {
        return this.provider;
    }
}

