/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.internal.util.Substring;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.enginehub.piston.Command;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;

public final class CommandWrapper {
    public static final Command<CommandSourceStack> FAKE_COMMAND = ctx -> {
        if (((CommandSourceStack)ctx.getSource()).m_81372_().f_46443_) {
            return 0;
        }
        return 1;
    };

    private CommandWrapper() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, org.enginehub.piston.Command command) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        aliases.add((Object)command.getName()).addAll(command.getAliases());
        for (String alias : aliases.build()) {
            LiteralArgumentBuilder base = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)alias).executes(FAKE_COMMAND)).then(Commands.m_82129_((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(CommandWrapper::suggest).executes(FAKE_COMMAND));
            if (command.getCondition() != Command.Condition.TRUE) {
                base.requires(CommandWrapper.requirementsFor(command));
            }
            dispatcher.register(base);
        }
    }

    private static Predicate<CommandSourceStack> requirementsFor(org.enginehub.piston.Command mapping) {
        return ctx -> {
            Entity entity = ctx.m_81373_();
            if (!(entity instanceof ServerPlayer)) {
                return true;
            }
            ForgePlayer actor = ForgeAdapter.adaptPlayer((ServerPlayer)entity);
            MapBackedValueStore store = MapBackedValueStore.create();
            store.injectValue(Key.of(Actor.class), context -> Optional.of(actor));
            return mapping.getCondition().satisfied(store);
        };
    }

    private static CompletableFuture<Suggestions> suggest(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        CommandSuggestionEvent event = new CommandSuggestionEvent(ForgeAdapter.adaptPlayer(((CommandSourceStack)context.getSource()).m_81375_()), builder.getInput());
        WorldEdit.getInstance().getEventBus().post(event);
        List<Substring> suggestions = event.getSuggestions();
        ImmutableList.Builder result = ImmutableList.builder();
        for (Substring suggestion : suggestions) {
            Object suggestionText = suggestion.getSubstring();
            if (suggestion.getStart() == suggestion.getEnd() && suggestion.getEnd() == builder.getInput().length() && !builder.getInput().endsWith(" ") && !builder.getInput().endsWith("\"")) {
                suggestionText = " " + (String)suggestionText;
            }
            result.add((Object)new Suggestion(StringRange.between((int)suggestion.getStart(), (int)suggestion.getEnd()), (String)suggestionText));
        }
        return CompletableFuture.completedFuture(Suggestions.create((String)builder.getInput(), (Collection)result.build()));
    }
}

