/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.List;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.config.AdminAccessConfig;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PermissionProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class PermissionsManager {
    private static PermissionsManager INSTANCE;

    public static PermissionsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PermissionsManager();
        }
        return INSTANCE;
    }

    public void sendPermissions(class_3222 playerEntity) {
        GlobalProperties permissions = this.getPlayerConfig(playerEntity);
        if (permissions != null) {
            Journeymap.getInstance().getDispatcher().sendClientPermissions(playerEntity, permissions.toJsonString(false), this.canServerAdmin(playerEntity));
        }
    }

    private GlobalProperties getPlayerConfig(class_3222 player) {
        if (LoaderHooks.isDedicatedServer() || class_310.method_1551().method_1576() != null && class_310.method_1551().method_1576().method_3860()) {
            boolean useWorldId = PropertiesManager.getInstance().getGlobalProperties().useWorldId.get();
            String worldId = useWorldId ? WorldIdData.getWorldId() : null;
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(player, worldId);
        }
        return this.buildPermissions(player);
    }

    public boolean canServerAdmin(class_3222 player) {
        List<String> admins = AdminAccessConfig.getInstance().getAdmins();
        for (String admin : admins) {
            if (!player.method_5667().toString().equals(admin) && !player.method_5477().getString().equalsIgnoreCase(admin) && !CommonConstants.debugOverride((class_1297)player)) continue;
            return true;
        }
        if (Journeymap.isOp((class_1657)player)) {
            return AdminAccessConfig.getInstance().getOpAccess() || CommonConstants.debugOverride((class_1297)player);
        }
        return false;
    }

    private boolean canTeleport(class_3222 player) {
        class_5321<class_1937> playerDim = DimensionHelper.getDimension((class_1297)player);
        if (PropertiesManager.getInstance().getDimProperties(playerDim).enabled.get().booleanValue()) {
            return PropertiesManager.getInstance().getDimProperties(playerDim).teleportEnabled.get();
        }
        if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
            return true;
        }
        return Journeymap.isOp((class_1657)player);
    }

    private GlobalProperties buildPermissions(class_3222 player) {
        PermissionProperties prop = PropertiesManager.getInstance().getDimProperties((class_5321<class_1937>)player.method_5770().method_27983());
        GlobalProperties globalProp = PropertiesManager.getInstance().getGlobalProperties();
        boolean isOp = Journeymap.isOp((class_1657)player);
        if (!((DimensionProperties)prop).enabled.get().booleanValue()) {
            prop = globalProp;
        }
        GlobalProperties to = (GlobalProperties)new GlobalProperties().loadForClient(prop.toJsonString(true), true);
        to.journeymapEnabled.set(globalProp.journeymapEnabled.get() != false || isOp || CommonConstants.debugOverride((class_1297)player));
        to.teleportEnabled.set(this.canTeleport(player));
        to.worldPlayerRadar.set(((ServerOption)((Object)globalProp.worldPlayerRadar.get())).enabled(isOp));
        to.radarEnabled.set(((ServerOption)((Object)prop.radarEnabled.get())).enabled(isOp));
        to.surfaceMapping.set(((ServerOption)((Object)prop.surfaceMapping.get())).enabled(isOp));
        to.topoMapping.set(((ServerOption)((Object)prop.topoMapping.get())).enabled(isOp));
        to.caveMapping.set(((ServerOption)((Object)prop.caveMapping.get())).enabled(isOp));
        to.renderRange.set(prop.renderRange.get());
        return to;
    }
}

