/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.PlayerData;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.network.data.ServerPropertyType;
import journeymap.common.network.data.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.MultiplayerProperties;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import journeymap.common.util.JourneyMapTeleport;
import journeymap.common.util.PermissionsManager;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PacketHandler {
    public void handleTeleportPacket(class_3222 player, Location location) {
        JourneyMapTeleport.instance().attemptTeleport((class_1297)player, location);
    }

    public void onClientPermsRequest(class_3222 sender) {
        PermissionsManager.getInstance().sendPermissions(sender);
    }

    public void onAdminScreenOpen(class_3222 sender, int type, String dimension) {
        PropertiesManager pm = PropertiesManager.getInstance();
        if (PermissionsManager.getInstance().canServerAdmin(sender) || LoaderHooks.isClient() || pm.getGlobalProperties().viewOnlyServerProperties.get().booleanValue()) {
            Journeymap.getInstance().getDispatcher().sendServerAdminPacket(sender, type, switch (ServerPropertyType.getFromType(type)) {
                case ServerPropertyType.GLOBAL -> pm.getGlobalProperties().toJsonString(false);
                case ServerPropertyType.DEFAULT -> pm.getDefaultDimensionProperties().toJsonString(false);
                default -> pm.getDimProperties(DimensionHelper.getWorldKeyForName(dimension)).toJsonString(false);
            }, dimension);
        } else {
            sender.method_9203((class_2561)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), class_156.field_25140);
        }
    }

    public void onMultiplayerOptionsOpen(class_3222 sender) {
        GlobalProperties globalProperties = PropertiesManager.getInstance().getGlobalProperties();
        if (((ServerOption)((Object)globalProperties.allowMultiplayerSettings.get())).hasOption(Journeymap.isOp((class_1657)sender))) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(sender);
            MultiplayerProperties properties = new MultiplayerProperties();
            properties.visible.set(player.isVisible());
            properties.hideSelfUnderground.set(player.isHiddenUnderground());
            Journeymap.getInstance().getDispatcher().sendMultiplayerOptionsPacket(sender, properties.toJsonString(false));
        }
    }

    public void onMultiplayerOptionsSave(class_3222 sender, String payload) {
        GlobalProperties globalProperties = PropertiesManager.getInstance().getGlobalProperties();
        if (((ServerOption)((Object)globalProperties.allowMultiplayerSettings.get())).hasOption(Journeymap.isOp((class_1657)sender))) {
            PlayerData.Player player = PlayerData.getPlayerData().getPlayer(sender);
            MultiplayerProperties properties = new MultiplayerProperties();
            properties.load(payload, false);
            player.setHiddenUnderground(properties.hideSelfUnderground.get());
            player.setVisible(properties.visible.get());
        }
    }

    public void onServerAdminSave(class_3222 sender, Integer type, String payload, String dimension) {
        if (PermissionsManager.getInstance().canServerAdmin(sender) || LoaderHooks.isClient()) {
            switch (ServerPropertyType.getFromType(type)) {
                case GLOBAL: {
                    ((PropertiesBase)PropertiesManager.getInstance().getGlobalProperties().load(payload, false)).save();
                    PacketHandler.updatePlayers("global");
                    break;
                }
                case DEFAULT: {
                    ((PropertiesBase)PropertiesManager.getInstance().getDefaultDimensionProperties().load(payload, false)).save();
                    break;
                }
                default: {
                    DimensionProperties prop = (DimensionProperties)PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(dimension)).load(payload, true);
                    prop.save();
                    if (!prop.enabled.get().booleanValue()) break;
                    PacketHandler.updatePlayers(dimension);
                }
            }
            PropertiesManager.getInstance().reloadConfigs();
        } else {
            sender.method_9203((class_2561)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), class_156.field_25140);
        }
    }

    private static void updatePlayers(String dim) {
        for (class_3222 player : LoaderHooks.getServer().method_3760().method_14571()) {
            if (!dim.equals(DimensionHelper.getDimKeyName((class_1297)player)) && !"global".equals(dim)) continue;
            PermissionsManager.getInstance().sendPermissions(player);
        }
    }

    public void onWorldIdRequest(class_3222 sender) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue()) {
            String worldId = WorldIdData.getWorldId();
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(sender, worldId);
        }
    }
}

