/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import journeymap.client.io.FileHandler;
import journeymap.client.io.IconSetFileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.task.main.ExpireTextureTask;
import journeymap.client.texture.DynamicTextureImpl;
import journeymap.client.texture.IgnSkin;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.SimpleTextureImpl;
import journeymap.client.texture.Texture;
import journeymap.client.ui.theme.Theme;
import journeymap.common.Journeymap;
import journeymap.common.thread.JMThreadFactory;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class TextureCache {
    public static final class_2960 GridCheckers = TextureCache.uiImage("grid-checkers.png");
    public static final class_2960 GridDots = TextureCache.uiImage("grid-dots.png");
    public static final class_2960 GridSquares = TextureCache.uiImage("grid.png");
    public static final class_2960 GridRegionSquares = TextureCache.uiImage("grid-region.png");
    public static final class_2960 GridRegion = TextureCache.uiImage("region.png");
    public static final class_2960 ColorPicker = TextureCache.uiImage("colorpick.png");
    public static final class_2960 ColorPicker2 = TextureCache.uiImage("colorpick2.png");
    public static final class_2960 TileSampleDay = TextureCache.uiImage("tile-sample-day.png");
    public static final class_2960 TileSampleNight = TextureCache.uiImage("tile-sample-night.png");
    public static final class_2960 TileSampleUnderground = TextureCache.uiImage("tile-sample-underground.png");
    public static final class_2960 UnknownEntity = TextureCache.uiImage("unknown.png");
    public static final class_2960 Deathpoint = TextureCache.uiImage("waypoint-death-icon.png");
    public static final class_2960 MobDot = TextureCache.uiImage("marker-dot-32.png");
    public static final class_2960 MobDotArrow = TextureCache.uiImage("marker-dot-arrow-32.png");
    public static final class_2960 MobDotChevron = TextureCache.uiImage("marker-chevron-32.png");
    public static final class_2960 MobIconArrow = TextureCache.uiImage("marker-icon-arrow-32.png");
    public static final class_2960 PlayerArrow = TextureCache.uiImage("marker-player-32.png");
    public static final class_2960 PlayerArrowBG = TextureCache.uiImage("marker-player-bg-32.png");
    public static final class_2960 Logo = TextureCache.uiImage("ico/journeymap.png");
    public static final class_2960 MinimapSquare128 = TextureCache.uiImage("minimap/minimap-square-128.png");
    public static final class_2960 MinimapSquare256 = TextureCache.uiImage("minimap/minimap-square-256.png");
    public static final class_2960 MinimapSquare512 = TextureCache.uiImage("minimap/minimap-square-512.png");
    public static final class_2960 Discord = TextureCache.uiImage("discord.png");
    public static final class_2960 Waypoint = TextureCache.uiImage("waypoint-icon.png");
    public static final class_2960 WaypointEdit = TextureCache.uiImage("waypoint-edit.png");
    public static final class_2960 WaypointOffscreen = TextureCache.uiImage("waypoint-offscreen.png");
    private static final Map<String, class_2960> dynamicTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<class_2960, class_2960> modTextureMap = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> playerSkins = Collections.synchronizedMap(new HashMap());
    public static final Map<String, Texture> themeImages = Collections.synchronizedMap(new HashMap());
    private static ThreadPoolExecutor texExec = new ThreadPoolExecutor(2, 4, 15L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new JMThreadFactory("texture"), new ThreadPoolExecutor.CallerRunsPolicy());
    public static final Map<String, class_2960> waypointIconCache = Collections.synchronizedMap(new HashMap<String, class_2960>(){
        {
            this.put(Waypoint.toString(), Waypoint);
            this.put(Deathpoint.toString(), Deathpoint);
        }
    });

    public static class_2960 getTexture(String texturePath) {
        class_2960 tex = dynamicTextureMap.get(texturePath);
        if (tex == null) {
            tex = TextureCache.uiImage(texturePath);
            dynamicTextureMap.put(texturePath, tex);
        }
        return tex;
    }

    public static class_2960 uiImage(String fileName) {
        return new class_2960("journeymap", "ui/img/" + fileName);
    }

    public static Texture getTexture(class_2960 location) {
        if (location == null) {
            return null;
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        Object textureObject = textureManager.method_34590(location, null);
        if (TextureCache.needsNewTexture(textureObject)) {
            textureObject = new SimpleTextureImpl(location);
            textureManager.method_4616(location, textureObject);
        }
        try {
            Texture tex = (Texture)textureObject;
            return tex;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Not a proper texture for Journeymap:{}", (Object)location);
            return (Texture)textureObject;
        }
    }

    public static Texture getWaypointIcon(class_2960 location) {
        if (!"journeymap".equals(location.method_12836())) {
            class_1060 manager = class_310.method_1551().method_1531();
            class_2960 fakeResource = modTextureMap.get(location);
            if (fakeResource == null || manager.method_34590(fakeResource, null) == null) {
                fakeResource = new class_2960("fake", location.method_12832());
                modTextureMap.put(location, fakeResource);
                try (SimpleTextureImpl simpleTexture = new SimpleTextureImpl(location);){
                    class_1011 img = ImageUtil.getScaledImage(4.0f, simpleTexture.getNativeImage(), false);
                    DynamicTextureImpl scaledTexture = new DynamicTextureImpl(img, fakeResource);
                    manager.method_4616(fakeResource, (class_1044)scaledTexture);
                    scaledTexture.setDisplayHeight(simpleTexture.getHeight());
                    scaledTexture.setDisplayWidth(simpleTexture.getHeight());
                }
            }
            return (Texture)manager.method_34590(fakeResource, null);
        }
        return TextureCache.getTexture(location);
    }

    private static boolean needsNewTexture(class_1044 textureObject) {
        if (textureObject == null) {
            return true;
        }
        if (textureObject instanceof Texture) {
            return !((Texture)textureObject).hasImage();
        }
        return textureObject instanceof class_1049;
    }

    public static <T extends Texture> Future<T> scheduleTextureTask(Callable<T> textureTask) {
        return texExec.submit(textureTask);
    }

    public static void reset() {
        playerSkins.clear();
        Arrays.asList(ColorPicker, ColorPicker2, Deathpoint, GridCheckers, GridDots, GridSquares, GridRegionSquares, GridRegion, Logo, MinimapSquare128, MinimapSquare256, MinimapSquare512, MobDot, MobDotArrow, MobDotChevron, PlayerArrow, PlayerArrowBG, PlayerArrowBG, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity, Waypoint, WaypointEdit, WaypointOffscreen).stream().map(TextureCache::getTexture);
        Arrays.asList(ColorPicker, ColorPicker2, GridCheckers, GridDots, GridSquares, GridRegion, GridRegionSquares, TileSampleDay, TileSampleNight, TileSampleUnderground, UnknownEntity).stream().map(TextureCache::getTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeThemeImages(Map<String, Texture> themeImages) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            ExpireTextureTask.queue(themeImages.values());
            themeImages.clear();
        }
    }

    public static class_1011 resolveImage(class_2960 location) {
        if (location.method_12836().equals("fake")) {
            return null;
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        try {
            class_3298 resource = resourceManager.method_14486(location);
            InputStream is = resource.method_14482();
            return class_1011.method_4309((InputStream)is);
        }
        catch (FileNotFoundException e) {
            try {
                class_3298 imgFile;
                if ("journeymap".equals(location.method_12836()) && (imgFile = class_310.method_1551().method_1478().method_14486(new class_2960("../src/main/resources/assets/journeymap/" + location.method_12832()))) != null) {
                    return class_1011.method_4309((InputStream)imgFile.method_14482());
                }
            }
            catch (IOException ioe) {
                Journeymap.getLogger().warn("Image not found: " + ioe.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Resource not readable: {}", (Object)location);
            return null;
        }
    }

    public static Texture getThemeTexture(Theme theme, String iconPath) {
        return TextureCache.getSizedThemeTexture(theme, iconPath, 0, 0, false, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getSizedThemeTexture(Theme theme, String iconPath, int width, int height, boolean resize, float alpha) {
        String texName = String.format("%s/%s", theme.directory, iconPath);
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(texName);
            if (tex == null || !tex.hasImage() || resize && (width != tex.getWidth() || height != tex.getHeight()) || tex.getAlpha() != alpha) {
                File parentDir;
                class_1011 nativeImage;
                if (tex != null) {
                    tex.remove();
                }
                if ((nativeImage = FileHandler.getIconFromFile(parentDir = ThemeLoader.getThemeIconDir(), theme.directory, iconPath)) == null) {
                    String resourcePath = String.format("theme/%s/%s", theme.directory, iconPath);
                    nativeImage = TextureCache.resolveImage(new class_2960("journeymap", resourcePath));
                }
                if (nativeImage != null && nativeImage.field_4988 > 0L) {
                    if ((resize || alpha < 1.0f) && (alpha < 1.0f || nativeImage.method_4307() != width || nativeImage.method_4323() != height)) {
                        class_1011 tmp = ImageUtil.getSizedImage(width, height, nativeImage, false);
                        nativeImage.close();
                        nativeImage = tmp;
                    }
                    tex = new DynamicTextureImpl(nativeImage);
                    tex.setAlpha(alpha);
                    themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unknown theme image: " + texName);
                    IconSetFileHandler.ensureEntityIconSet("Default");
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getScaledCopy(String texName, Texture original, int width, int height, float alpha) {
        Map<String, Texture> map = themeImages;
        synchronized (map) {
            Texture tex = themeImages.get(texName);
            if (tex == null || !tex.hasImage() || width != tex.getWidth() || height != tex.getHeight() || tex.getAlpha() != alpha) {
                if (original != null) {
                    if (alpha < 1.0f || original.getWidth() != width || original.getHeight() != height) {
                        tex = new DynamicTextureImpl(ImageUtil.getSizedImage(width, height, original.getNativeImage(), true));
                        tex.setAlpha(alpha);
                    }
                    themeImages.put(texName, tex);
                } else {
                    Journeymap.getLogger().error("Unable to get scaled image: " + texName);
                    return TextureCache.getTexture(UnknownEntity);
                }
            }
            return tex;
        }
    }

    public static class_2960 coloredImageResource(class_2960 location, int color) {
        class_1060 textureManager = class_310.method_1551().method_1531();
        class_2960 resourceLocation = new class_2960("fake", "color-" + color + "-" + TextureCache.getIconName(location.method_12832()) + ".png");
        if (textureManager != null && textureManager.method_34590(resourceLocation, null) == null) {
            SimpleTextureImpl image = new SimpleTextureImpl(location);
            if (image.hasImage()) {
                class_1011 coloredImage = ImageUtil.recolorImage(image.getNativeImage(), color);
                DynamicTextureImpl texture = new DynamicTextureImpl(coloredImage);
                textureManager.method_4616(resourceLocation, (class_1044)texture);
                image.close();
            } else {
                return location;
            }
        }
        return resourceLocation;
    }

    private static String getIconName(String path) {
        String[] vals = path.split("/");
        String nameExtension = vals[vals.length - 1];
        return nameExtension.split("\\.")[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Texture getPlayerSkin(UUID playerId, String username) {
        Texture tex = null;
        Map<String, Texture> map = playerSkins;
        synchronized (map) {
            tex = playerSkins.get(username);
            if (tex != null) {
                return tex;
            }
            class_1011 blank = new class_1011(24, 24, false);
            tex = new DynamicTextureImpl(blank);
            playerSkins.put(username, tex);
        }
        Texture playerSkinTex = tex;
        class_1011 img = IgnSkin.getFaceImage(playerId, username);
        if (img != null) {
            playerSkins.put(username, new DynamicTextureImpl(img));
        } else {
            playerSkins.remove(username);
        }
        return playerSkinTex;
    }
}

