/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import journeymap.client.JourneymapClient;
import journeymap.client.api.event.DeathWaypointEvent;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class DeathPointHandler {
    class_310 mc = class_310.method_1551();

    public void handlePlayerDeath() {
        if (this.mc.field_1724 != null) {
            this.createDeathpoint();
        }
    }

    private void createDeathpoint() {
        try {
            class_746 player = this.mc.field_1724;
            if (player == null) {
                Journeymap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            WaypointProperties waypointProperties = JourneymapClient.getInstance().getWaypointProperties();
            boolean enabled = waypointProperties.managerEnabled.get() != false && waypointProperties.createDeathpoints.get() != false && JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints();
            boolean cancelled = false;
            int buildMinY = player.field_6002.method_8597().method_29959() + 2;
            double playerY = Math.max(class_3532.method_15357((double)player.method_23318()), buildMinY);
            class_2338 pos = new class_2338((double)class_3532.method_15357((double)player.method_23317()), playerY, (double)class_3532.method_15357((double)player.method_23321()));
            if (enabled) {
                class_5321 dim = class_310.method_1551().field_1724.field_6002.method_27983();
                DeathWaypointEvent event = new DeathWaypointEvent(pos, dim);
                ClientAPI.INSTANCE.getClientEventManager().fireDeathpointEvent(event);
                if (!event.isCancelled()) {
                    Waypoint deathpoint = Waypoint.at(pos, Waypoint.Type.Death, dim.method_29177().toString());
                    WaypointStore.INSTANCE.save(deathpoint, true);
                } else {
                    cancelled = true;
                }
            }
            Journeymap.getLogger().info(String.format("%s died at %s. Deathpoints enabled: %s. Deathpoint created: %s", player.method_5477().getString(), pos, enabled, cancelled ? "cancelled" : Boolean.valueOf(true)));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }
}

