/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.mixin;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;
    private static boolean checkAbilitiesForRemoval = true;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void abilityTick(CallbackInfo info) {
        PlayerEntityMixin playerEntityMixin;
        if (this instanceof Object && (playerEntityMixin = this) instanceof class_1657) {
            class_1657 player = (class_1657)playerEntityMixin;
            if (TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
                TravelersBackpackInventory.abilityTick(player);
                if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, ComponentUtils.getWearingBackpack(player))) {
                    checkAbilitiesForRemoval = true;
                }
            }
            if (!(!checkAbilitiesForRemoval || player.field_6002.field_9236 || ComponentUtils.isWearingBackpack(player) && TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities)) {
                BackpackAbilities.ABILITIES.armorAbilityRemovals(player);
                checkAbilitiesForRemoval = false;
            }
            if (TravelersBackpackConfig.getConfig().slownessDebuff.tooManyBackpacksSlowness && !player.method_7337()) {
                if (nextBackpackCountCheck > player.method_37908().method_8510()) {
                    return;
                }
                nextBackpackCountCheck = player.method_37908().method_8510() + 100L;
                AtomicInteger numberOfBackpacks = PlayerEntityMixin.checkBackpacksForSlowness(player);
                if (numberOfBackpacks.get() == 0) {
                    return;
                }
                int maxNumberOfBackpacks = TravelersBackpackConfig.getConfig().slownessDebuff.maxNumberOfBackpacks;
                if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                    int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.getConfig().slownessDebuff.slownessPerExcessedBackpack));
                    player.method_6092(new class_1293(class_1294.field_5909, 200, numberOfSlownessLevels - 1, false, false));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"})
    private void attack(class_1297 target, CallbackInfo ci) {
        PlayerEntityMixin playerEntityMixin;
        if (TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities && this instanceof Object && (playerEntityMixin = this) instanceof class_1657) {
            class_1657 player = (class_1657)playerEntityMixin;
            BackpackAbilities.beeAbility(player, target);
        }
    }

    private static AtomicInteger checkBackpacksForSlowness(class_1657 player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (!(((class_1799)player.method_31548().field_7547.get(i)).method_7909() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((class_1799)player.method_31548().field_7544.get(0)).method_7909() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }
}

