/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screen.TravelersBackpackHandledScreen;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBaseScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.slot.DisabledSlot;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1735;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class EmiCompat
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addExclusionArea(TravelersBackpackHandledScreen.class, (screen, consumer) -> {
            if (screen.settingsWidget != null) {
                int[] s = screen.settingsWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));
            }
            if (screen.sortWidget != null && screen.sortWidget.isVisible()) {
                int[] sort = screen.sortWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(sort[0], sort[1], sort[2], sort[3]));
            }
            if (screen.memoryWidget != null && screen.memoryWidget.isVisible()) {
                int[] memory = screen.memoryWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(memory[0], memory[1], memory[2], memory[3]));
            }
            if (screen.craftingWidget != null && screen.craftingWidget.isVisible()) {
                int[] crafting = screen.craftingWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(crafting[0], crafting[1], crafting[2], crafting[3]));
            }
        });
        registry.addRecipeHandler(ModScreenHandlerTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY, new GridMenuInfo());
        registry.addRecipeHandler(ModScreenHandlerTypes.TRAVELERS_BACKPACK_ITEM, new GridMenuInfo());
    }

    private static class GridMenuInfo<T extends TravelersBackpackBaseScreenHandler>
    implements StandardRecipeHandler<T> {
        private GridMenuInfo() {
        }

        @Nullable
        public class_1735 getOutputSlot(T handler) {
            return handler.method_7611(0);
        }

        public List<class_1735> getInputSources(T handler) {
            int i;
            ArrayList<class_1735> list = new ArrayList<class_1735>();
            for (i = 1; i <= ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getInventory().method_5439(); ++i) {
                list.add(handler.method_7611(i));
            }
            for (i = ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getCombinedInventory().method_5439(); i < ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getCombinedInventory().method_5439() + 36; ++i) {
                if (((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getScreenID() == 1 && handler.method_7611(i) instanceof DisabledSlot) continue;
                list.add(handler.method_7611(i));
            }
            return list;
        }

        public List<class_1735> getCraftingSlots(T handler) {
            ArrayList<class_1735> list = new ArrayList<class_1735>();
            int firstCraftSlot = ((TravelersBackpackBaseScreenHandler)((Object)handler)).inventory.getCombinedInventory().method_5439() - 8;
            for (int i = 0; i < 9; ++i) {
                list.add(handler.method_7611(firstCraftSlot + i));
            }
            return list;
        }

        public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
            ((TravelersBackpackBaseScreenHandler)context.getScreenHandler()).inventory.getSettingsManager().set((byte)0, 1, (byte)1);
            class_2540 buf = PacketByteBufs.create();
            buf.writeByte((int)((TravelersBackpackBaseScreenHandler)context.getScreenHandler()).inventory.getScreenID()).writeByte(0).writeInt(1).writeByte(1);
            ClientPlayNetworking.send((class_2960)ModNetwork.SETTINGS_ID, (class_2540)buf);
            return super.craft(recipe, context);
        }

        public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
            return super.canCraft(recipe, context) && ((TravelersBackpackBaseScreenHandler)context.getScreenHandler()).inventory.getSettingsManager().hasCraftingGrid();
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            return VanillaEmiRecipeCategories.CRAFTING.equals(recipe.getCategory()) && recipe.supportsRecipeTree();
        }
    }
}

