/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBlockEntityScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.InventorySorter;
import com.tiviacz.travelersbackpack.items.HoseItem;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ServerActions {
    public static void swapTool(class_1657 player, double scrollDelta) {
        if (ComponentUtils.isWearingBackpack(player)) {
            TravelersBackpackInventory inventory = ComponentUtils.getBackpackInv(player);
            InventoryImproved inv = inventory.getToolSlotsInventory();
            class_1799 heldItem = player.method_6047();
            int toolSlots = inv.method_5439();
            if (toolSlots == 0) {
                return;
            }
            int firstSlot = 0;
            int lastSlot = firstSlot + (toolSlots - 1);
            int j = 0;
            for (int i = firstSlot; i <= lastSlot; ++i) {
                if (inv.method_5438(i).method_7960()) continue;
                ++j;
            }
            class_1799[] tools = new class_1799[j];
            if (scrollDelta < 0.0) {
                int i;
                int slot = 0;
                for (int i2 = firstSlot; i2 <= firstSlot + j - 1; ++i2) {
                    tools[slot] = inv.method_5438(i2).method_7972();
                    ++slot;
                }
                class_1799 tempStack = tools[tools.length - 1];
                for (i = tools.length - 1; i >= 0; --i) {
                    if (i - 1 < 0) {
                        tools[0] = heldItem;
                        player.method_6122(class_1268.field_5808, tempStack);
                        continue;
                    }
                    tools[i] = tools[i - 1];
                }
                slot = 0;
                for (i = firstSlot; i <= firstSlot + j - 1; ++i) {
                    inv.method_5447(i, tools[slot]);
                    ++slot;
                }
            } else if (scrollDelta > 0.0) {
                int i;
                int slot = 0;
                for (int i3 = firstSlot; i3 <= firstSlot + j - 1; ++i3) {
                    tools[slot] = inv.method_5438(i3).method_7972();
                    ++slot;
                }
                class_1799 tempStack = tools[0];
                for (i = 0; i <= tools.length - 1; ++i) {
                    if (i + 1 > tools.length - 1) {
                        tools[tools.length - 1] = heldItem;
                        player.method_6122(class_1268.field_5808, tempStack);
                        continue;
                    }
                    tools[i] = tools[i + 1];
                }
                slot = 0;
                for (i = firstSlot; i <= firstSlot + j - 1; ++i) {
                    inv.method_5447(i, tools[slot]);
                    ++slot;
                }
            }
            inventory.markDataDirty(1);
        }
    }

    public static void equipBackpack(class_1657 player) {
        class_1937 world = player.field_6002;
        if (!world.field_9236) {
            if (!ComponentUtils.getComponent(player).hasWearable()) {
                if (player.field_7512 instanceof TravelersBackpackItemScreenHandler) {
                    ((class_3222)player).method_7346();
                }
                class_1799 stack = player.method_6047().method_7972();
                ComponentUtils.getComponent(player).setWearable(stack);
                ComponentUtils.getComponent(player).setContents(stack);
                player.method_6047().method_7934(1);
                world.method_8396(null, player.method_24515(), class_3417.field_14581, class_3419.field_15248, 1.0f, (1.0f + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2f) * 0.7f);
                ComponentUtils.sync(player);
            }
            ((class_3222)player).method_7346();
        }
    }

    public static void unequipBackpack(class_1657 player) {
        class_1937 world = player.field_6002;
        if (!world.field_9236) {
            if (player.field_7512 instanceof TravelersBackpackItemScreenHandler) {
                player.field_7512.method_7595(player);
            }
            class_1799 wearable = ComponentUtils.getComponent(player).getWearable().method_7972();
            if (!player.method_31548().method_7394(wearable)) {
                player.method_7353((class_2561)new class_2588("action.travelersbackpack.unequip_nospace"), false);
                ((class_3222)player).method_7346();
                return;
            }
            if (ComponentUtils.getComponent(player).hasWearable()) {
                ComponentUtils.getComponent(player).removeWearable();
                world.method_8396(null, player.method_24515(), class_3417.field_14581, class_3419.field_15248, 1.05f, (1.0f + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2f) * 0.7f);
                ComponentUtils.sync(player);
            }
            ((class_3222)player).method_7346();
        }
    }

    public static void switchAbilitySlider(class_1657 player, boolean sliderValue) {
        TravelersBackpackInventory inv = ComponentUtils.getBackpackInv(player);
        inv.setAbility(sliderValue);
        inv.markDataDirty(7, 4);
        if (inv.getItemStack().method_7909() == ModItems.CHICKEN_TRAVELERS_BACKPACK && inv.getLastTime() <= 0) {
            BackpackAbilities.ABILITIES.chickenAbility(player, true);
        }
        if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, inv.getItemStack()) && !sliderValue) {
            BackpackAbilities.ABILITIES.abilityRemoval(inv.getItemStack(), player);
        }
    }

    public static void switchAbilitySliderBlockEntity(class_1657 player, class_2338 pos, boolean sliderValue) {
        class_2586 class_25862 = player.field_6002.method_8321(pos);
        if (class_25862 instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity = (TravelersBackpackBlockEntity)class_25862;
            blockEntity.setAbility(sliderValue);
            blockEntity.method_5431();
            blockEntity.method_10997().method_8408(pos, blockEntity.method_11010().method_26204());
            if (blockEntity.method_11010().method_26204() == ModBlocks.SPONGE_TRAVELERS_BACKPACK) {
                ((TravelersBackpackBlock)blockEntity.method_11010().method_26204()).update(blockEntity.method_10997(), pos);
            }
        }
    }

    public static void sortBackpack(class_1657 player, byte screenID, byte button, boolean shiftPressed) {
        class_1703 class_17032;
        if (screenID == 3 && (class_17032 = player.field_7512) instanceof TravelersBackpackBlockEntityScreenHandler) {
            TravelersBackpackBlockEntityScreenHandler screenHandler = (TravelersBackpackBlockEntityScreenHandler)class_17032;
            class_2586 class_25862 = player.field_6002.method_8321(screenHandler.inventory.getPosition());
            if (class_25862 instanceof TravelersBackpackBlockEntity) {
                TravelersBackpackBlockEntity blockEntity = (TravelersBackpackBlockEntity)class_25862;
                InventorySorter.selectSort(blockEntity, player, button, shiftPressed);
            }
        } else if (screenID == 1) {
            class_1703 class_17033 = player.field_7512;
            if (class_17033 instanceof TravelersBackpackItemScreenHandler) {
                TravelersBackpackItemScreenHandler screenHandler = (TravelersBackpackItemScreenHandler)class_17033;
                InventorySorter.selectSort(screenHandler.inventory, player, button, shiftPressed);
            }
        } else if (screenID == 2) {
            InventorySorter.selectSort(ComponentUtils.getBackpackInv(player), player, button, shiftPressed);
        }
    }

    public static void toggleSleepingBag(class_1657 player, class_2338 pos) {
        class_1937 world = player.field_6002;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity = (TravelersBackpackBlockEntity)class_25862;
            if (!blockEntity.isSleepingBagDeployed()) {
                if (blockEntity.deploySleepingBag(world, pos)) {
                    if (!world.field_9236) {
                        ((class_3222)player).method_7346();
                    }
                } else if (!world.field_9236) {
                    player.method_7353((class_2561)new class_2588("action.travelersbackpack.deploy_sleeping_bag"), false);
                }
            } else {
                blockEntity.removeSleepingBag(world);
            }
            if (!world.field_9236) {
                ((class_3222)player).method_7346();
            }
        }
    }

    public static void emptyTank(double tankType, class_1657 player, class_1937 world, byte screenID) {
        FluidTank tank;
        ITravelersBackpackInventory inv = null;
        if (screenID == 2) {
            inv = ComponentUtils.getBackpackInv(player);
        }
        if (screenID == 1) {
            inv = ((TravelersBackpackItemScreenHandler)player.field_7512).inventory;
        }
        if (screenID == 3) {
            inv = ((TravelersBackpackBlockEntityScreenHandler)player.field_7512).inventory;
        }
        if (inv == null) {
            return;
        }
        FluidTank fluidTank = tank = tankType == 1.0 ? inv.getLeftTank() : inv.getRightTank();
        if (!world.field_9236) {
            world.method_8396(null, player.method_24515(), class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
        }
        tank.variant = FluidVariant.blank();
        tank.amount = 0L;
        if (screenID == 3) {
            inv.method_5431();
        } else {
            inv.markDataDirty(4);
        }
    }

    public static boolean setFluidEffect(class_1937 world, class_1657 player, SingleVariantStorage<FluidVariant> tank) {
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(tank, world, (class_1297)player)) {
            done = EffectFluidRegistry.executeEffects(tank, (class_1297)player, world);
        }
        return done;
    }

    public static void switchHoseMode(class_1657 player, double scrollDelta) {
        class_1799 hose = player.method_6047();
        if (hose.method_7909() instanceof HoseItem && hose.method_7969() != null) {
            int mode = HoseItem.getHoseMode(hose);
            if (scrollDelta > 0.0) {
                if (++mode == 4) {
                    mode = 1;
                }
            } else if (scrollDelta < 0.0 && --mode == 0) {
                mode = 3;
            }
            hose.method_7969().method_10569("Mode", mode);
        }
    }

    public static void toggleHoseTank(class_1657 player) {
        class_1799 hose = player.method_6047();
        if (hose.method_7909() instanceof HoseItem && hose.method_7969() != null) {
            int tank = HoseItem.getHoseTank(hose);
            tank = tank == 1 ? 2 : 1;
            hose.method_7969().method_10569("Tank", tank);
        }
    }
}

