/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screen.TankScreen;
import com.tiviacz.travelersbackpack.client.screen.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screen.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screen.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screen.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screen.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screen.widget.ControlTab;
import com.tiviacz.travelersbackpack.client.screen.widget.CraftingWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.SortWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.TankSlotWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screen.widget.WidgetBase;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBaseScreenHandler;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class TravelersBackpackHandledScreen
extends class_465<TravelersBackpackBaseScreenHandler> {
    public static final class_2960 BACKGROUND_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/travelers_backpack_background.png");
    public static final class_2960 SLOTS_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/travelers_backpack_slots.png");
    public static final class_2960 SETTINGS_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/travelers_backpack_settings.png");
    public static final class_2960 EXTRAS_TRAVELERS_BACKPACK = new class_2960("travelersbackpack", "textures/gui/travelers_backpack_extras.png");
    public List<IButton> buttons = new ArrayList<IButton>();
    public ControlTab controlTab;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public SortWidget sortWidget;
    public MemoryWidget memoryWidget;
    public TankSlotWidget leftTankSlotWidget;
    public TankSlotWidget rightTankSlotWidget;
    public CraftingWidget craftingWidget;
    public final ITravelersBackpackInventory inventory;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;
    private boolean fluidSlotsAsWidget;
    private int rows;

    public TravelersBackpackHandledScreen(TravelersBackpackBaseScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.inventory = handler.inventory;
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.field_2792 = 248;
        this.tankLeft = new TankScreen(handler.inventory.getLeftTank(), 25, 7, 52 + handler.inventory.getYOffset(), 16);
        this.tankRight = new TankScreen(handler.inventory.getRightTank(), 207, 7, 52 + handler.inventory.getYOffset(), 16);
        this.initScreen();
    }

    public int getX() {
        return this.field_2776;
    }

    public int getY() {
        return this.field_2800;
    }

    protected void method_25426() {
        super.method_25426();
        this.initControlTab();
        this.initToolSlotsWidget();
        this.initSettingsTab();
        this.initTankSlotWidgets();
        this.initCraftingWidget();
        this.initButtons();
    }

    public void initTankSlotWidgets() {
        if (this.fluidSlotsAsWidget) {
            this.leftTankSlotWidget = new TankSlotWidget(this, this.field_2776, this.field_2800, 28, 60);
            this.method_25429(this.leftTankSlotWidget);
            this.rightTankSlotWidget = new TankSlotWidget(this, this.field_2776 + 220, this.field_2800, 28, 60);
            this.method_25429(this.rightTankSlotWidget);
        }
    }

    public void initControlTab() {
        this.controlTab = new ControlTab(this, this.field_2776 + 61, this.field_2800 - 10, 50, 13);
        this.method_25429(this.controlTab);
    }

    public void initToolSlotsWidget() {
        this.toolSlotsWidget = new ToolSlotsWidget(this, this.field_2776 + 5, this.field_2800 - 15, 18, 15);
        this.method_25429(this.toolSlotsWidget);
    }

    public void initSettingsTab() {
        this.settingsWidget = new SettingsWidget(this, this.field_2776 + this.field_2792, this.field_2800 + 10, 15, 18);
        this.method_25429(this.settingsWidget);
        this.sortWidget = new SortWidget(this, this.field_2776 + this.field_2792, this.field_2800 + 29, 15, 18);
        this.method_25429(this.sortWidget);
        this.memoryWidget = new MemoryWidget(this, this.field_2776 + this.field_2792, this.field_2800 + 48, 15, 18);
        this.method_25429(this.memoryWidget);
    }

    public void initCraftingWidget() {
        this.craftingWidget = new CraftingWidget(this, this.field_2776 + this.field_2792, this.field_2800 + 29, 15, 18);
        this.method_25429(this.craftingWidget);
    }

    public void initButtons() {
        this.buttons.clear();
        this.buttons.add(new SleepingBagButton(this));
        this.buttons.add(new EquipButton(this));
        this.buttons.add(new UnequipButton(this));
        this.buttons.add(new AbilitySliderButton(this));
    }

    public void initScreen() {
        this.rows = Math.max(3, Math.min(this.inventory.getRows(), 7));
        this.fluidSlotsAsWidget = true;
        this.field_2779 = 153;
        if (this.rows > 3) {
            this.field_2779 = 153 + (this.rows - 3) * 18;
            if (this.rows > 4) {
                this.fluidSlotsAsWidget = false;
            }
        }
    }

    public void drawBackground(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TRAVELERS_BACKPACK);
        this.method_25302(matrices, x, y, 0, 0, this.field_2792, 5);
        if (this.rows < this.inventory.getToolSlotsInventory().method_5439() && this.inventory.getSettingsManager().showToolSlots()) {
            int sub = this.inventory.getToolSlotsInventory().method_5439() - this.rows;
            RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
            for (int i = 0; i < sub; ++i) {
                this.method_25302(matrices, x + 2, y + this.inventory.getYOffset() + 61 + 18 * i, 186, 61, 24, 18);
            }
            this.method_25302(matrices, x + 2, y + this.inventory.getYOffset() + 61 + 18 * sub, 186, 80, 24, 2);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TRAVELERS_BACKPACK);
        int offset = 5 + Math.abs(this.rows - 7) * 18;
        this.method_25302(matrices, x, y + 5, 0, offset, this.field_2792, this.field_2779 - 5);
        if (TravelersBackpackConfig.getConfig().client.enableLegacyGui) {
            this.drawSlotsLegacy(matrices, x + 43, y + 6);
        } else {
            this.drawSlots(matrices, x + 43, y + 6);
        }
        this.drawTank(matrices, x + 24, y);
        this.drawTank(matrices, x + 206, y);
        this.drawFluidSlot(matrices, x + 5, y + 6);
        this.drawFluidSlot(matrices, x + 225, y + 6);
    }

    public void drawSlots(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)SLOTS_TRAVELERS_BACKPACK);
        int rows = this.inventory.getRows();
        int additionalSlots = this.inventory.getInventory().method_5439() % 9;
        int gridX = 162;
        int gridY = (rows - 1) * 18;
        this.method_25302(matrices, x, y, 43, 6, gridX, gridY);
        if (additionalSlots == 0) {
            additionalSlots = 9;
        }
        gridX = additionalSlots * 18;
        gridY = 18;
        this.method_25302(matrices, x, y + 18 * (rows - 1), 43, 6, gridX, gridY);
    }

    public void drawTank(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
        this.method_25302(matrices, x, y + 6, 232, 38, 18, 18);
        for (int i = 1; i <= this.rows - 2; ++i) {
            this.method_25302(matrices, x, y + 6 + 18 * i, 232, 57, 18, 18);
        }
        this.method_25302(matrices, x, y + 6 + 18 * (this.rows - 1), 232, 76, 18, 18);
    }

    public void drawFluidSlot(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
        this.method_25302(matrices, x, y, 213, 38, 18, this.fluidSlotsAsWidget ? 18 : 48);
    }

    public void drawSlotsLegacy(class_4587 matrices, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
        int rows = this.inventory.getRows() - 1;
        int additionalSlots = this.inventory.getInventory().method_5439() % 9;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.drawSlotLegacy(matrices, x + j * 18, y + i * 18, 213, 0);
            }
        }
        if (additionalSlots == 0) {
            additionalSlots = 9;
        }
        for (int j = 0; j < additionalSlots; ++j) {
            this.drawSlotLegacy(matrices, x + j * 18, y + rows * 18, 213, 0);
        }
    }

    public void drawSlotLegacy(class_4587 matrices, int x, int y, int vOffset, int uWidth) {
        this.method_25302(matrices, x, y, vOffset, uWidth, 18, 18);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        RenderSystem.setShaderTexture((int)0, (class_2960)SETTINGS_TRAVELERS_BACKPACK);
        this.craftingWidget.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (!this.inventory.getLeftTank().isResourceBlank()) {
            this.tankLeft.drawScreenFluidBar(this, matrices);
        }
        if (!this.inventory.getRightTank().isResourceBlank()) {
            this.tankRight.drawScreenFluidBar(this, matrices);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
        this.buttons.forEach(button -> button.render(matrices, mouseX, mouseY, delta));
        this.controlTab.method_25394(matrices, mouseX, mouseY, delta);
        this.toolSlotsWidget.method_25394(matrices, mouseX, mouseY, delta);
        if (this.fluidSlotsAsWidget) {
            this.leftTankSlotWidget.method_25394(matrices, mouseX, mouseY, delta);
            this.rightTankSlotWidget.method_25394(matrices, mouseX, mouseY, delta);
        }
        this.settingsWidget.method_25394(matrices, mouseX, mouseY, delta);
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).filter(w -> ((WidgetBase)((Object)w)).isSettingsChild() && ((WidgetBase)((Object)w)).isVisible()).forEach(w -> ((WidgetBase)((Object)w)).method_25394(matrices, mouseX, mouseY, delta));
        this.method_2380(matrices, mouseX, mouseY);
    }

    protected void method_2380(class_4587 matrices, int x, int y) {
        super.method_2380(matrices, x, y);
        if (this.tankLeft.inTank(this, x, y)) {
            this.method_30901(matrices, this.tankLeft.getTankTooltip(), x, y);
        }
        if (this.tankRight.inTank(this, x, y)) {
            this.method_30901(matrices, this.tankRight.getTankTooltip(), x, y);
        }
        this.buttons.forEach(button -> button.drawMouseoverTooltip(matrices, x, y));
        this.craftingWidget.drawMouseoverTooltip(matrices, x, y);
    }

    public boolean isWidgetVisible(int rowsCount, TankSlotWidget widget) {
        if (widget == null) {
            return false;
        }
        return this.inventory.getRows() == rowsCount && widget.isVisible();
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.drawBackground(matrices, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
        this.drawToolSlots(matrices);
        this.drawUnsortableSlots(matrices);
        this.drawMemorySlots(matrices);
    }

    public void drawToolSlots(class_4587 matrices) {
        if (this.inventory.getSettingsManager().showToolSlots()) {
            boolean enableLegacy = TravelersBackpackConfig.getConfig().client.enableLegacyGui;
            for (int i = 0; i < this.inventory.getToolSlotsInventory().method_5439(); ++i) {
                this.method_25302(matrices, this.getX() + 5, this.getY() + 6 + 18 * i, 232, enableLegacy ? 0 : 19, 18, 18);
                if (enableLegacy) continue;
                this.method_25302(matrices, this.getX() + 5, this.getY() + 6 + 18 * i, 76, 0, 18, 18);
            }
        }
    }

    public void drawUnsortableSlots(class_4587 matrices) {
        if (!this.inventory.getSlotManager().getUnsortableSlots().isEmpty() && !this.inventory.getSlotManager().isSelectorActive((byte)1)) {
            this.inventory.getSlotManager().getUnsortableSlots().forEach(i -> this.method_25302(matrices, this.getX() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(i.intValue() + 1)).field_7873, this.getY() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(i.intValue() + 1)).field_7872, 77, 20, 16, 16));
        }
    }

    public void drawMemorySlots(class_4587 matrices) {
        if (!this.inventory.getSlotManager().getMemorySlots().isEmpty()) {
            this.inventory.getSlotManager().getMemorySlots().forEach(pair -> {
                if (this.inventory.getSlotManager().isSelectorActive((byte)1)) {
                    RenderSystem.setShaderTexture((int)0, (class_2960)EXTRAS_TRAVELERS_BACKPACK);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.method_25302(matrices, this.getX() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7873, this.getY() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7872, 115, 24, 16, 16);
                }
                if (!((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((Integer)pair.getFirst() + 1).method_7677().method_7960()) {
                    return;
                }
                class_1799 itemstack = (class_1799)pair.getSecond();
                this.field_22788.method_4010(itemstack, this.getX() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7873, this.getY() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7872);
                RenderSystem.depthFunc((int)516);
                TravelersBackpackHandledScreen.method_25294((class_4587)matrices, (int)(this.getX() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7873), (int)(this.getY() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7872), (int)(this.getX() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7873 + 16), (int)(this.getY() + ((TravelersBackpackBaseScreenHandler)this.method_17577()).method_7611((int)(((Integer)pair.getFirst()).intValue() + 1)).field_7872 + 16), (int)0x30FFFFFF);
                RenderSystem.depthFunc((int)515);
            });
        }
    }

    protected boolean method_2381(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (this.method_2386(pMouseX, pMouseY) != null) {
            return false;
        }
        if (!((TravelersBackpackBaseScreenHandler)this.method_17577()).method_34255().method_7960()) {
            for (class_364 element : this.method_25396()) {
                WidgetBase base;
                if (!(element instanceof WidgetBase) || !(base = (WidgetBase)element).method_25405(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.field_2792) || pMouseY >= (double)(pGuiTop + this.field_2779);
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        super.method_2383(slot, slotId, button, actionType);
        this.selectSlots(slot, button);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        class_1735 slot = this.field_2787;
        this.selectSlots(slot, pButton);
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void selectSlots(class_1735 slot, int button) {
        if (slot != null && slot.field_7874 >= 1 && slot.field_7874 <= this.inventory.getInventory().method_5439()) {
            if (this.inventory.getSlotManager().isSelectorActive((byte)0)) {
                if (button == 0 && !this.inventory.getSlotManager().isSlot((byte)0, slot.field_7874 - 1)) {
                    this.inventory.getSlotManager().setUnsortableSlot(slot.field_7874 - 1);
                }
                if (button == 1 && this.inventory.getSlotManager().isSlot((byte)0, slot.field_7874 - 1)) {
                    this.inventory.getSlotManager().setUnsortableSlot(slot.field_7874 - 1);
                }
            } else if (this.inventory.getSlotManager().isSelectorActive((byte)1)) {
                if (button == 0 && !this.inventory.getSlotManager().isSlot((byte)1, slot.field_7874 - 1) && !slot.method_7677().method_7960()) {
                    this.inventory.getSlotManager().setMemorySlot(slot.field_7874 - 1, slot.method_7677());
                }
                if (button == 1 && this.inventory.getSlotManager().isSlot((byte)1, slot.field_7874 - 1)) {
                    this.inventory.getSlotManager().setMemorySlot(slot.field_7874 - 1, slot.method_7677());
                }
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_2540 buf;
        if (this.inventory.getSlotManager().isSelectorActive((byte)0) && !this.sortWidget.method_25405(mouseX, mouseY) || this.inventory.getSlotManager().isSelectorActive((byte)1) && !this.memoryWidget.method_25405(mouseX, mouseY)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (!this.inventory.getLeftTank().isResourceBlank() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            buf = PacketByteBufs.create();
            buf.writeByte((int)this.inventory.getScreenID()).writeByte(3).writeDouble(1.0);
            ClientPlayNetworking.send((class_2960)ModNetwork.SPECIAL_ACTION_ID, (class_2540)buf);
            if (this.inventory.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, ((TravelersBackpackBaseScreenHandler)this.field_2797).playerInventory.field_7546, this.inventory.method_10997(), this.inventory.getScreenID());
            }
        }
        if (!this.inventory.getRightTank().isResourceBlank() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            buf = PacketByteBufs.create();
            buf.writeByte((int)this.inventory.getScreenID()).writeByte(3).writeDouble(2.0);
            ClientPlayNetworking.send((class_2960)ModNetwork.SPECIAL_ACTION_ID, (class_2540)buf);
            if (this.inventory.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, ((TravelersBackpackBaseScreenHandler)this.field_2797).playerInventory.field_7546, this.inventory.method_10997(), this.inventory.getScreenID());
            }
        }
        this.buttons.forEach(b -> b.mouseClicked(mouseX, mouseY, button));
        return super.method_25402(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        ((TravelersBackpackBaseScreenHandler)this.field_2797).playerInventory.field_7546.field_6002.method_8396(((TravelersBackpackBaseScreenHandler)this.field_2797).playerInventory.field_7546, ((TravelersBackpackBaseScreenHandler)this.field_2797).playerInventory.field_7546.method_24515(), class_3417.field_15015, class_3419.field_15250, 0.25f, 1.0f);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (KeybindHandler.OPEN_INVENTORY.method_1417(keyCode, scanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if (playerEntity != null) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

