/*
 * Decompiled with CFR 0.152.
 */
package info.mmpa.pipeblocker;

import info.mmpa.pipeblocker.CheckStatus;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObjectStreamFilter {
    private static final Logger LOGGER = LogManager.getLogger((String)"PipeBlocker");
    private static final List<Pattern> allowedPatterns = new ArrayList<Pattern>();
    private static final List<Pattern> rejectedPatterns = new ArrayList<Pattern>();
    private static final List<Pattern> softAllowedPatterns = new ArrayList<Pattern>();
    private static final Set<Class<?>> REJECTED_CLASSES = Collections.synchronizedSet(new HashSet());
    private static int numEntriesLoaded = 0;

    private static void loadFilter() {
        try (InputStream filterStream = new URL("https://minecraft-malware-prevention-alliance.github.io/PipeBlocker/pipeblocker_filter.txt?t=" + new Date().getTime()).openStream();){
            ObjectStreamFilter.processFilter(filterStream);
            LOGGER.info("Successfully loaded online PipeBlocker filter with {} entries.", new Object[]{numEntriesLoaded});
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load online filter, using local version", (Throwable)e);
            try (InputStream localFilterStream = ObjectStreamFilter.class.getResourceAsStream("/pipeblocker_filter.txt");){
                if (localFilterStream == null) {
                    throw new FileNotFoundException("pipeblocker_filter.txt");
                }
                ObjectStreamFilter.processFilter(localFilterStream);
                LOGGER.info("Successfully loaded local PipeBlocker filter with {} entries.", new Object[]{numEntriesLoaded});
            }
            catch (IOException e2) {
                LOGGER.error("Failed to load local filter, this will mean no deserialization is permitted", (Throwable)e2);
            }
        }
    }

    private static void processFilter(InputStream filterStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(filterStream));){
            String line = reader.readLine();
            while (line != null) {
                ObjectStreamFilter.processLine(line.trim());
                line = reader.readLine();
            }
        }
    }

    private static void processLine(String line) {
        if (line.length() == 0 || line.charAt(0) == '#') {
            return;
        }
        String type = null;
        List<Pattern> list = null;
        switch (line.charAt(0)) {
            case '+': {
                type = "allow";
                list = allowedPatterns;
                break;
            }
            case '-': {
                type = "deny";
                list = rejectedPatterns;
                break;
            }
            case '~': {
                type = "soft allow";
                list = softAllowedPatterns;
            }
        }
        if (list != null) {
            String glob = line.substring(1);
            LOGGER.debug("Adding {} rule for glob '{}'", new Object[]{type, glob});
            Pattern desiredPattern = Pattern.compile(ObjectStreamFilter.convertGlobToRegex(glob));
            list.add(desiredPattern);
        }
    }

    private static Stream<Class<?>> inheritanceStream(Class<?> clz) {
        if (clz == null) {
            return Stream.empty();
        }
        Stream.Builder<Class<?>> streamBuilder = Stream.builder();
        while (clz != null) {
            streamBuilder.add(clz);
            clz = clz.getSuperclass();
        }
        return streamBuilder.build();
    }

    private static boolean isRejectedName(String name) {
        for (Pattern p : rejectedPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean isAllowedName(String name) {
        for (Pattern p : allowedPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean isSoftAllowedName(String name) {
        for (Pattern p : softAllowedPatterns) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public static CheckStatus check(Class<?> clazz) {
        if (clazz == null) {
            return CheckStatus.UNDECIDED;
        }
        Class<?> underlyingClass = clazz;
        while (underlyingClass.isArray()) {
            underlyingClass = underlyingClass.getComponentType();
        }
        if (ObjectStreamFilter.inheritanceStream(underlyingClass).map(Class::getCanonicalName).noneMatch(ObjectStreamFilter::isRejectedName) && (ObjectStreamFilter.inheritanceStream(underlyingClass).map(Class::getCanonicalName).anyMatch(ObjectStreamFilter::isAllowedName) || ObjectStreamFilter.isSoftAllowedName(underlyingClass.getCanonicalName()))) {
            return CheckStatus.UNDECIDED;
        }
        if (REJECTED_CLASSES.add(underlyingClass)) {
            LOGGER.warn("Blocked class {} from being deserialized as it's not allowed", new Object[]{underlyingClass.getName()});
        }
        if (Objects.equals(System.getProperty("info.mmpa.pipeblocker.log-only"), "true")) {
            return CheckStatus.UNDECIDED;
        }
        return CheckStatus.REJECTED;
    }

    public static void apply() {
        String className;
        ObjectStreamFilter.loadFilter();
        String javaVersion = System.getProperties().getProperty("java.specification.version");
        if ("1.8".equals(javaVersion)) {
            className = "info.mmpa.pipeblocker.java8.FilterSetter";
        } else if (javaVersion.chars().allMatch(Character::isDigit) && Integer.parseInt(javaVersion) > 8) {
            className = "info.mmpa.pipeblocker.java9.FilterSetter";
        } else {
            System.err.println("Unsupported java version: " + javaVersion);
            throw new RuntimeException("Unsupported java version: " + javaVersion);
        }
        try {
            Class.forName(className).getMethod("apply", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            System.out.println("Unable to invoke setter");
            throw new RuntimeException(ex);
        }
    }

    public static String convertGlobToRegex(String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length() + 2);
        sb.append('^');
        int inGroup = 0;
        int inClass = 0;
        int firstIndexInClass = -1;
        char[] arr = pattern.toCharArray();
        block16: for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            switch (ch) {
                case '\\': {
                    if (++i >= arr.length) {
                        sb.append('\\');
                        continue block16;
                    }
                    char next = arr[i];
                    switch (next) {
                        case ',': {
                            break;
                        }
                        case 'E': 
                        case 'Q': {
                            sb.append('\\');
                        }
                        default: {
                            sb.append('\\');
                        }
                    }
                    sb.append(next);
                    continue block16;
                }
                case '*': {
                    if (inClass == 0) {
                        sb.append(".*");
                        continue block16;
                    }
                    sb.append('*');
                    continue block16;
                }
                case '?': {
                    if (inClass == 0) {
                        sb.append('.');
                        continue block16;
                    }
                    sb.append('?');
                    continue block16;
                }
                case '[': {
                    ++inClass;
                    firstIndexInClass = i + 1;
                    sb.append('[');
                    continue block16;
                }
                case ']': {
                    --inClass;
                    sb.append(']');
                    continue block16;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    if (inClass == 0 || firstIndexInClass == i && ch == '^') {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block16;
                }
                case '!': {
                    if (firstIndexInClass == i) {
                        sb.append('^');
                        continue block16;
                    }
                    sb.append('!');
                    continue block16;
                }
                case '{': {
                    ++inGroup;
                    sb.append('(');
                    continue block16;
                }
                case '}': {
                    --inGroup;
                    sb.append(')');
                    continue block16;
                }
                case ',': {
                    if (inGroup > 0) {
                        sb.append('|');
                        continue block16;
                    }
                    sb.append(',');
                    continue block16;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('$');
        return sb.toString();
    }
}

