/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.smwyg.mixin;

import io.github.apace100.smwyg.ShowMeWhatYouGot;
import io.github.apace100.smwyg.duck.ItemSharingTextFieldWidget;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_342.class})
public abstract class TextFieldWidgetMixin
implements ItemSharingTextFieldWidget {
    @Shadow
    private String field_2092;
    private class_1799 itemStack;
    private String insertedString;
    private int insertedLength;
    private int insertedIndex = 0;

    @Override
    public void setStack(class_1799 stack) {
        this.itemStack = stack;
        class_2561 text = stack.method_7954();
        this.insertedString = text.getString();
        this.insertedLength = this.insertedString.length();
    }

    @Override
    public class_1799 getStack() {
        return this.itemStack;
    }

    @Override
    public String getTextBefore() {
        if (this.insertedIndex < 0 || this.insertedIndex > this.field_2092.length()) {
            ShowMeWhatYouGot.LOGGER.warn("Invalid tag positioning in getTextBefore");
            ShowMeWhatYouGot.LOGGER.warn("text={} length={} insertedIndex={} insertedLength={}", (Object)this.field_2092, (Object)this.field_2092.length(), (Object)this.insertedIndex, (Object)this.insertedLength);
            return "";
        }
        return this.field_2092.substring(0, this.insertedIndex);
    }

    @Override
    public String getTextAfter() {
        if (this.insertedIndex + this.insertedLength < 0 || this.insertedIndex + this.insertedLength > this.field_2092.length()) {
            ShowMeWhatYouGot.LOGGER.warn("Invalid tag positioning in getTextAfter");
            ShowMeWhatYouGot.LOGGER.warn("text={} length={} insertedIndex={} insertedLength={}", (Object)this.field_2092, (Object)this.field_2092.length(), (Object)this.insertedIndex, (Object)this.insertedLength);
            return "";
        }
        return this.field_2092.substring(this.insertedIndex + this.insertedLength);
    }

    @Override
    public boolean hasStack() {
        return this.itemStack != null;
    }

    @Override
    public void onSuggestionInserted(int start, int offset) {
        if (this.hasStack() && start <= this.insertedIndex) {
            this.insertedIndex += offset;
        }
    }

    @Inject(method={"getCursorPosWithOffset"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyCursorOffset(int offset, CallbackInfoReturnable<Integer> cir) {
        if (!this.hasStack()) {
            return;
        }
        int original = (Integer)cir.getReturnValue();
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (offset < 0) {
                cir.setReturnValue((Object)this.insertedIndex);
            } else {
                cir.setReturnValue((Object)(this.insertedIndex + this.insertedLength));
            }
        }
    }

    @Inject(method={"getWordSkipPosition"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyWordSkipPosition(int wordOffset, CallbackInfoReturnable<Integer> cir) {
        if (!this.hasStack()) {
            return;
        }
        int original = (Integer)cir.getReturnValue();
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (wordOffset < 0) {
                cir.setReturnValue((Object)this.insertedIndex);
            } else {
                int skipPos;
                for (skipPos = this.insertedIndex + this.insertedLength; skipPos < this.field_2092.length() && this.field_2092.charAt(skipPos) == ' '; ++skipPos) {
                }
                cir.setReturnValue((Object)skipPos);
            }
        }
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setSelectionStart(I)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void moveInsertedText(String rawText, CallbackInfo ci, int start, int end, int spaceRemaining, String sanitizedText, int sanitizedTextLength, String newText) {
        if (!this.hasStack()) {
            return;
        }
        this.handleOverwrite(start, end, sanitizedTextLength);
    }

    @ModifyVariable(method={"setCursor"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifyCursorSetting(int original) {
        if (!this.hasStack()) {
            return original;
        }
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (original <= this.insertedIndex + this.insertedLength / 2) {
                return this.insertedIndex;
            }
            return this.insertedIndex + this.insertedLength;
        }
        return original;
    }

    @ModifyVariable(method={"setSelectionStart"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifySelectionStart(int original) {
        if (!this.hasStack()) {
            return original;
        }
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            return this.insertedIndex;
        }
        return original;
    }

    @ModifyVariable(method={"setSelectionEnd"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifySelectionEnd(int original) {
        if (!this.hasStack()) {
            return original;
        }
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            return this.insertedIndex + this.insertedLength;
        }
        return original;
    }

    @Inject(method={"eraseCharacters"}, at={@At(value="INVOKE", target="Ljava/lang/StringBuilder;<init>(Ljava/lang/String;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void eraseInsertion(int characterOffset, CallbackInfo ci, int index, int start, int end) {
        if (!this.hasStack()) {
            return;
        }
        this.handleOverwrite(start, end, 0);
    }

    private void handleOverwrite(int start, int end, int replacementLength) {
        boolean isErasingBefore;
        boolean isErasingEntireTag = start <= this.insertedIndex && end >= this.insertedIndex + this.insertedLength;
        boolean isStartInside = start > this.insertedIndex && start < this.insertedIndex + this.insertedLength;
        boolean isEndInside = end > this.insertedIndex && end < this.insertedIndex + this.insertedLength;
        boolean bl = isErasingBefore = start <= this.insertedIndex && end <= this.insertedIndex;
        if (isErasingEntireTag || isStartInside || isEndInside) {
            this.reset();
        } else if (isErasingBefore) {
            int offset = replacementLength - (end - start);
            this.insertedIndex += offset;
        }
    }

    private void reset() {
        this.itemStack = null;
        this.insertedLength = 0;
        this.insertedString = null;
        this.insertedIndex = 0;
    }
}

