/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.DisplayStat;
import io.github.foundationgames.automobility.render.AutomobilityModels;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3879;
import net.minecraft.class_5617;

public record AutomobileEngine(class_2960 id, float torque, float speed, class_3414 sound, EngineModel model) implements AutomobileComponent<AutomobileEngine>
{
    public static final class_2960 ID = Automobility.id("engine");
    public static final SimpleMapContentRegistry<AutomobileEngine> REGISTRY = new SimpleMapContentRegistry();
    public static final AutomobileEngine EMPTY = REGISTRY.register(new AutomobileEngine(Automobility.id("empty"), 0.01f, 0.01f, class_3417.field_14832, new EngineModel(new class_2960("empty"), Automobility.id("empty"), new ExhaustPos[0])));
    public static final AutomobileEngine STONE = REGISTRY.register(new AutomobileEngine(Automobility.id("stone"), 0.3f, 0.58f, AutomobilitySounds.STONE_ENGINE, new EngineModel(Automobility.id("textures/entity/automobile/engine/stone.png"), Automobility.id("engine_stone"), new ExhaustPos(0.0f, 7.0f, -8.3f, 50.0f, 0.0f))));
    public static final AutomobileEngine IRON = REGISTRY.register(new AutomobileEngine(Automobility.id("iron"), 0.5f, 0.75f, AutomobilitySounds.IRON_ENGINE, new EngineModel(Automobility.id("textures/entity/automobile/engine/iron.png"), Automobility.id("engine_iron"), new ExhaustPos(-3.5f, 5.4f, -8.0f, 26.0f, 0.0f), new ExhaustPos(3.5f, 5.4f, -8.0f, 26.0f, 0.0f))));
    public static final AutomobileEngine COPPER = REGISTRY.register(new AutomobileEngine(Automobility.id("copper"), 0.375f, 0.68f, AutomobilitySounds.COPPER_ENGINE, new EngineModel(Automobility.id("textures/entity/automobile/engine/copper.png"), Automobility.id("engine_copper"), new ExhaustPos(2.0f, 1.625f, -8.95f, 26.0f, 0.0f))));
    public static final AutomobileEngine GOLD = REGISTRY.register(new AutomobileEngine(Automobility.id("gold"), 0.8f, 0.75f, AutomobilitySounds.GOLD_ENGINE, new EngineModel(Automobility.id("textures/entity/automobile/engine/gold.png"), Automobility.id("engine_gold"), new ExhaustPos(4.0f, 9.3f, -7.75f, 26.0f, 0.0f), new ExhaustPos(-4.0f, 9.3f, -7.75f, 26.0f, 0.0f))));
    public static final AutomobileEngine DIAMOND = REGISTRY.register(new AutomobileEngine(Automobility.id("diamond"), 0.95f, 0.85f, AutomobilitySounds.DIAMOND_ENGINE, new EngineModel(Automobility.id("textures/entity/automobile/engine/diamond.png"), Automobility.id("engine_diamond"), new ExhaustPos(3.0f, 3.8f, -7.6f, 40.0f, 0.0f), new ExhaustPos(-3.0f, 3.8f, -7.6f, 40.0f, 0.0f), new ExhaustPos(4.0f, 7.075f, -4.95f, 40.0f, 0.0f), new ExhaustPos(-4.0f, 7.075f, -4.95f, 40.0f, 0.0f))));
    public static final AutomobileEngine CREATIVE = REGISTRY.register(new AutomobileEngine(Automobility.id("creative"), 1.0f, 1.0f, AutomobilitySounds.CREATIVE_ENGINE, new EngineModel(Automobility.id("textures/entity/automobile/engine/creative.png"), Automobility.id("engine_creative"), new ExhaustPos(0.0f, 7.0f, -7.0f, 90.0f, 0.0f))));
    public static final DisplayStat<AutomobileEngine> STAT_TORQUE = new DisplayStat<AutomobileEngine>("torque", AutomobileEngine::torque);
    public static final DisplayStat<AutomobileEngine> STAT_SPEED = new DisplayStat<AutomobileEngine>("speed", AutomobileEngine::speed);

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public class_2960 containerId() {
        return ID;
    }

    @Override
    public void forEachStat(Consumer<DisplayStat<AutomobileEngine>> action) {
        action.accept(STAT_TORQUE);
        action.accept(STAT_SPEED);
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return "engine." + this.id.method_12836() + "." + this.id.method_12832();
    }

    public record EngineModel(class_2960 texture, class_2960 modelId, ExhaustPos[] exhausts) {
        @Environment(value=EnvType.CLIENT)
        public Function<class_5617.class_5618, class_3879> model() {
            return AutomobilityModels.MODELS.get(this.modelId);
        }
    }

    public record ExhaustPos(float x, float y, float z, float pitch, float yaw) {
    }
}

