/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util.collection;

import dev.kir.packedinventory.util.collection.KeyValuePair;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DefaultedMap<K, V>
extends Map<K, V> {
    default public K getDefaultKey() {
        return this.getDefaultEntry().getKey();
    }

    default public V getDefaultValue() {
        return this.getDefaultEntry().getValue();
    }

    default public V getOrDefault(Object key) {
        return this.getOrDefault(key, this.getDefaultValue());
    }

    default public Map.Entry<K, V> getDefaultEntry() {
        return this.getDefaultEntrySupplier().get();
    }

    public Supplier<Map.Entry<K, V>> getDefaultEntrySupplier();

    public static <K, V> DefaultedMap<K, V> wrap(Map<K, V> map, Supplier<K> defaultKey, Supplier<V> defaultValue) {
        return DefaultedMap.wrap(map, () -> KeyValuePair.of(defaultKey.get(), defaultValue.get()));
    }

    public static <K, V> DefaultedMap<K, V> wrap(final Map<K, V> map, final Supplier<Map.Entry<K, V>> defaultEntry) {
        return new DefaultedMap<K, V>(){

            @Override
            public Supplier<Map.Entry<K, V>> getDefaultEntrySupplier() {
                return defaultEntry;
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return map.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return map.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return map.get(key);
            }

            @Override
            public V getOrDefault(Object key, V defaultValue) {
                return map.getOrDefault(key, defaultValue);
            }

            @Override
            @Nullable
            public V put(K key, V value) {
                return map.put(key, value);
            }

            @Override
            public V remove(Object key) {
                return map.remove(key);
            }

            @Override
            public boolean remove(Object key, Object value) {
                return map.remove(key, value);
            }

            @Override
            public void forEach(BiConsumer<? super K, ? super V> action) {
                map.forEach(action);
            }

            @Override
            public boolean replace(K key, V oldValue, V newValue) {
                return map.replace(key, oldValue, newValue);
            }

            @Override
            public V replace(K key, V value) {
                return map.replace(key, value);
            }

            @Override
            public V putIfAbsent(K key, V value) {
                return map.putIfAbsent(key, value);
            }

            @Override
            public V compute(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                return map.compute(key, remappingFunction);
            }

            @Override
            public V computeIfAbsent(K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
                return map.computeIfAbsent(key, mappingFunction);
            }

            @Override
            public V computeIfPresent(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                return map.computeIfPresent(key, remappingFunction);
            }

            @Override
            public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
                map.replaceAll(function);
            }

            @Override
            public void putAll(@NotNull Map<? extends K, ? extends V> m) {
                map.putAll(m);
            }

            @Override
            public V merge(K key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
                return map.merge(key, value, remappingFunction);
            }

            @Override
            public void clear() {
                map.clear();
            }

            @Override
            @NotNull
            public Set<K> keySet() {
                return map.keySet();
            }

            @Override
            @NotNull
            public Collection<V> values() {
                return map.values();
            }

            @Override
            @NotNull
            public Set<Map.Entry<K, V>> entrySet() {
                return map.entrySet();
            }

            @Override
            public boolean equals(Object obj) {
                return map.equals(obj);
            }

            @Override
            public int hashCode() {
                return map.hashCode();
            }

            public String toString() {
                return map.toString();
            }
        };
    }
}

