/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util.block;

import dev.kir.packedinventory.util.ColorUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2546;
import net.minecraft.class_3545;
import net.minecraft.class_3620;
import org.jetbrains.annotations.Nullable;

public final class BlockUtil {
    private static final Map<class_3620, class_1767> COLORS = new HashMap<class_3620, class_1767>();

    @Nullable
    public static class_1767 getColor(class_2248 block) {
        if (block instanceof class_2480) {
            return class_2480.method_10526((class_2248)block);
        }
        if (block instanceof class_2546) {
            return ((class_2546)block).method_9303();
        }
        return BlockUtil.mapColorToDyeColor(block.method_26403());
    }

    public static class_1767 mapColorToDyeColor(class_3620 color) {
        return COLORS.get(color);
    }

    private BlockUtil() {
    }

    static {
        Map<class_1767, float[]> dyeColors = Arrays.stream(class_1767.values()).collect(Collectors.toMap(x -> x, x -> ColorUtil.RGB2LAB(x.method_7787())));
        for (int i = 0; i < 64; ++i) {
            class_3620 mapColor = class_3620.method_38479((int)i);
            float[] lab = ColorUtil.RGB2LAB(ColorUtil.toRGB(mapColor.field_16011));
            class_1767 dyeColor = dyeColors.keySet().stream().map(x -> new class_3545(x, (Object)Float.valueOf(ColorUtil.computeXYZDistance(lab, (float[])dyeColors.get(x))))).min(Comparator.comparingDouble(class_3545::method_15441)).map(class_3545::method_15442).orElse(class_1767.field_7952);
            COLORS.put(mapColor, dyeColor);
        }
    }
}

