/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.util;

import net.minecraft.class_3532;

public final class ColorUtil {
    public static int fromRGB(float r, float g, float b) {
        return ColorUtil.fromRGBA(r, g, b, 1.0f);
    }

    public static int fromRGBA(float r, float g, float b, float a) {
        return ((byte)(a * 255.0f) << 24) + ((byte)(r * 255.0f) << 16) + ((byte)(g * 255.0f) << 8) + (byte)(b * 255.0f);
    }

    public static float[] toRGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static float[] toRGBA(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    private static float normalizeRGBChannel(float channel) {
        return 100.0f * (channel > 0.04045f ? (float)Math.pow((channel + 0.055f) / 1.055f, 2.4f) : channel / 12.92f);
    }

    private static float normalizeXYZChannel(float channel) {
        return channel > 0.008856f ? (float)Math.pow(channel, 0.3333333432674408) : 7.787f * channel + 0.13793103f;
    }

    public static float[] RGB2LAB(float[] rgb) {
        float r = ColorUtil.normalizeRGBChannel(rgb[0]);
        float g = ColorUtil.normalizeRGBChannel(rgb[1]);
        float b = ColorUtil.normalizeRGBChannel(rgb[2]);
        float x = r * 0.4124f + g * 0.3576f + b * 0.1805f;
        float y = r * 0.2126f + g * 0.7152f + b * 0.0722f;
        float z = r * 0.0193f + g * 0.1192f + b * 0.9505f;
        x = ColorUtil.normalizeXYZChannel(x / 95.047f);
        y = ColorUtil.normalizeXYZChannel(y / 100.0f);
        z = ColorUtil.normalizeXYZChannel(z / 108.883f);
        float _l = 116.0f * y - 16.0f;
        float _a = 500.0f * (x - y);
        float _b = 200.0f * (y - z);
        return new float[]{_l, _a, _b};
    }

    public static float computeXYZDistance(float[] left, float[] right) {
        return class_3532.method_15355((float)(class_3532.method_27285((float)(left[0] - right[0])) + class_3532.method_27285((float)(left[1] - right[1])) + class_3532.method_27285((float)(left[2] - right[2]))));
    }

    private ColorUtil() {
    }
}

