/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.inventory;

import dev.kir.packedinventory.api.v1.config.GenericValidationConfig;
import dev.kir.packedinventory.api.v1.config.PackedInventoryApiConfig;
import dev.kir.packedinventory.api.v1.config.SilkTouchableGenericValidationConfig;
import dev.kir.packedinventory.api.v1.config.ValidationConfig;
import dev.kir.packedinventory.api.v1.inventory.InventoryValidators;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewer;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewerRegistry;
import dev.kir.packedinventory.inventory.EmptyInventory;
import dev.kir.packedinventory.inventory.NbtItemsInventory;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_1733;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2480;

public final class PackedInventoryInventoryViewers {
    private static InventoryViewerRegistry.Entry SHULKER_BOX;
    private static InventoryViewerRegistry.Entry ENDER_CHEST;
    private static InventoryViewerRegistry.Entry CRAFTING_TABLE;
    private static InventoryViewerRegistry.Entry CARTOGRAPHY_TABLE;
    private static InventoryViewerRegistry.Entry STONECUTTER;
    private static InventoryViewerRegistry.Entry LOOM;
    private static InventoryViewerRegistry.Entry SMITHING_TABLE;
    private static InventoryViewerRegistry.Entry GRINDSTONE;
    private static InventoryViewerRegistry.Entry ANVIL;

    public static InventoryViewerRegistry.Entry getShulkerBox() {
        return SHULKER_BOX;
    }

    public static InventoryViewerRegistry.Entry getEnderChest() {
        return ENDER_CHEST;
    }

    public static InventoryViewerRegistry.Entry getCraftingTable() {
        return CRAFTING_TABLE;
    }

    public static InventoryViewerRegistry.Entry getCartographyTable() {
        return CARTOGRAPHY_TABLE;
    }

    public static InventoryViewerRegistry.Entry getStonecutter() {
        return STONECUTTER;
    }

    public static InventoryViewerRegistry.Entry getLoom() {
        return LOOM;
    }

    public static InventoryViewerRegistry.Entry getSmithingTable() {
        return SMITHING_TABLE;
    }

    public static InventoryViewerRegistry.Entry getGrindstone() {
        return GRINDSTONE;
    }

    public static InventoryViewerRegistry.Entry getAnvil() {
        return ANVIL;
    }

    public static void init(InventoryViewerRegistry registry, PackedInventoryApiConfig config) {
        SHULKER_BOX = PackedInventoryInventoryViewers.registerShulkerBox(registry, config);
        ENDER_CHEST = PackedInventoryInventoryViewers.registerEnderChest(registry, config);
        CRAFTING_TABLE = PackedInventoryInventoryViewers.registerWorkStation(class_1802.field_8465, registry, config);
        CARTOGRAPHY_TABLE = PackedInventoryInventoryViewers.registerWorkStation(class_1802.field_16313, registry, config);
        STONECUTTER = PackedInventoryInventoryViewers.registerWorkStation(class_1802.field_16305, registry, config);
        LOOM = PackedInventoryInventoryViewers.registerWorkStation(class_1802.field_8772, registry, config);
        SMITHING_TABLE = PackedInventoryInventoryViewers.registerWorkStation(class_1802.field_16308, registry, config);
        GRINDSTONE = PackedInventoryInventoryViewers.registerWorkStation(class_1802.field_16311, registry, config);
        ANVIL = PackedInventoryInventoryViewers.registerAnvil(registry, config);
    }

    private static InventoryViewerRegistry.Entry registerShulkerBox(InventoryViewerRegistry registry, PackedInventoryApiConfig config) {
        config.registerValidationConfig(class_1802.field_8545, GenericValidationConfig::new);
        InventoryViewer.Validator isEnabled = InventoryValidators.config(class_1802.field_8545, config, ValidationConfig.DEFAULT, ValidationConfig::isEnabled);
        InventoryViewer.Validator isInCreative = InventoryValidators.config(class_1802.field_8545, config, GenericValidationConfig.DEFAULT, GenericValidationConfig::isSuppressedInCreative).and(InventoryValidators.IS_IN_CREATIVE);
        InventoryViewer.Validator isSingleItem = InventoryValidators.SINGLE_ITEM;
        InventoryViewer.Validator isOnGround = InventoryValidators.config(class_1802.field_8545, config, GenericValidationConfig.DEFAULT, x -> !x.requiresPlayerOnGround()).or(InventoryValidators.IS_ON_GROUND);
        return registry.register((inventory, slot, player) -> NbtItemsInventory.builder(inventory, slot, player).screenHandler(class_1733::new).isValid((x, nii) -> !(class_2248.method_9503((class_1792)x.method_7909()) instanceof class_2480)).resolveDefaults().build(), isEnabled.and(isInCreative.or(isSingleItem.and(isOnGround))), Stream.concat(Arrays.stream(class_1767.values()), Stream.of((class_1767)null)).map(class_2480::method_10525).map(class_2248::method_8389).toList());
    }

    private static InventoryViewerRegistry.Entry registerEnderChest(InventoryViewerRegistry registry, PackedInventoryApiConfig config) {
        config.registerValidationConfig(class_1802.field_8466, SilkTouchableGenericValidationConfig::new);
        InventoryViewer.Validator isEnabled = InventoryValidators.config(class_1802.field_8466, config, ValidationConfig.DEFAULT, ValidationConfig::isEnabled);
        InventoryViewer.Validator isInCreative = InventoryValidators.config(class_1802.field_8466, config, GenericValidationConfig.DEFAULT, GenericValidationConfig::isSuppressedInCreative).and(InventoryValidators.IS_IN_CREATIVE);
        InventoryViewer.Validator isOnGround = InventoryValidators.config(class_1802.field_8466, config, GenericValidationConfig.DEFAULT, x -> !x.requiresPlayerOnGround()).or(InventoryValidators.IS_ON_GROUND);
        InventoryViewer.Validator hasSilkTouch = InventoryValidators.config(class_1802.field_8466, config, SilkTouchableGenericValidationConfig.DEFAULT, x -> !x.requiresSilkTouch()).or(InventoryValidators.HAS_PICKAXE_WITH_SILK_TOUCH);
        return registry.register((inventory, slot, player) -> player.method_7274(), isEnabled.and(isInCreative.or(isOnGround.and(hasSilkTouch))), class_1802.field_8466);
    }

    private static InventoryViewerRegistry.Entry registerWorkStation(class_1792 workStation, InventoryViewerRegistry registry, PackedInventoryApiConfig config) {
        config.registerValidationConfig(workStation, GenericValidationConfig::new);
        InventoryViewer.Validator isEnabled = InventoryValidators.config(workStation, config, ValidationConfig.DEFAULT, ValidationConfig::isEnabled);
        InventoryViewer.Validator isInCreative = InventoryValidators.config(workStation, config, GenericValidationConfig.DEFAULT, GenericValidationConfig::isSuppressedInCreative).and(InventoryValidators.IS_IN_CREATIVE);
        InventoryViewer.Validator isOnGround = InventoryValidators.config(workStation, config, GenericValidationConfig.DEFAULT, x -> !x.requiresPlayerOnGround()).or(InventoryValidators.IS_ON_GROUND);
        return registry.register((inventory, slot, player) -> EmptyInventory.getInstance(), isEnabled.and(isInCreative.or(isOnGround)), workStation);
    }

    private static InventoryViewerRegistry.Entry registerAnvil(InventoryViewerRegistry registry, PackedInventoryApiConfig config) {
        config.registerValidationConfig(class_1802.field_8782, GenericValidationConfig::new);
        InventoryViewer.Validator isEnabled = InventoryValidators.config(class_1802.field_8782, config, ValidationConfig.DEFAULT, ValidationConfig::isEnabled);
        InventoryViewer.Validator isInCreative = InventoryValidators.config(class_1802.field_8782, config, GenericValidationConfig.DEFAULT, GenericValidationConfig::isSuppressedInCreative).and(InventoryValidators.IS_IN_CREATIVE);
        InventoryViewer.Validator isSingleItem = InventoryValidators.SINGLE_ITEM;
        InventoryViewer.Validator isOnGround = InventoryValidators.config(class_1802.field_8782, config, GenericValidationConfig.DEFAULT, x -> !x.requiresPlayerOnGround()).or(InventoryValidators.IS_ON_GROUND);
        return registry.register((inventory, slot, player) -> EmptyInventory.getInstance(), isEnabled.and(isInCreative.or(isSingleItem.and(isOnGround))), class_1802.field_8782, class_1802.field_8750, class_1802.field_8427);
    }

    private PackedInventoryInventoryViewers() {
    }
}

