/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.inventory;

import dev.kir.packedinventory.api.v1.config.PackedInventoryApiConfig;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewHandlerRegistry;
import dev.kir.packedinventory.api.v1.screen.InventoryDependentScreenHandlerFactory;
import dev.kir.packedinventory.screen.ItemDamagingAnvilScreenHandler;
import dev.kir.packedinventory.screen.ScreenHandlerProxy;
import net.minecraft.class_1270;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_747;

public final class PackedInventoryInventoryViewHandlers {
    private static InventoryViewHandlerRegistry.Entry DEFAULT;
    private static InventoryViewHandlerRegistry.Entry CRAFTING_TABLE;
    private static InventoryViewHandlerRegistry.Entry CARTOGRAPHY_TABLE;
    private static InventoryViewHandlerRegistry.Entry STONECUTTER;
    private static InventoryViewHandlerRegistry.Entry LOOM;
    private static InventoryViewHandlerRegistry.Entry SMITHING_TABLE;
    private static InventoryViewHandlerRegistry.Entry GRINDSTONE;
    private static InventoryViewHandlerRegistry.Entry ANVIL;

    public static InventoryViewHandlerRegistry.Entry getDefault() {
        return DEFAULT;
    }

    public static InventoryViewHandlerRegistry.Entry getCraftingTable() {
        return CRAFTING_TABLE;
    }

    public static InventoryViewHandlerRegistry.Entry getCartographyTable() {
        return CARTOGRAPHY_TABLE;
    }

    public static InventoryViewHandlerRegistry.Entry getStonecutter() {
        return STONECUTTER;
    }

    public static InventoryViewHandlerRegistry.Entry getLoom() {
        return LOOM;
    }

    public static InventoryViewHandlerRegistry.Entry getSmithingTable() {
        return SMITHING_TABLE;
    }

    public static InventoryViewHandlerRegistry.Entry getGrindstone() {
        return GRINDSTONE;
    }

    public static InventoryViewHandlerRegistry.Entry getAnvil() {
        return ANVIL;
    }

    public static void init(InventoryViewHandlerRegistry registry, PackedInventoryApiConfig config) {
        DEFAULT = PackedInventoryInventoryViewHandlers.registerDefault(registry);
        CRAFTING_TABLE = PackedInventoryInventoryViewHandlers.registerWorkStation(class_2246.field_9980, registry);
        CARTOGRAPHY_TABLE = PackedInventoryInventoryViewHandlers.registerWorkStation(class_2246.field_16336, registry);
        STONECUTTER = PackedInventoryInventoryViewHandlers.registerWorkStation(class_2246.field_16335, registry);
        LOOM = PackedInventoryInventoryViewHandlers.registerWorkStation(class_2246.field_10083, registry);
        SMITHING_TABLE = PackedInventoryInventoryViewHandlers.registerWorkStation(class_2246.field_16329, registry);
        GRINDSTONE = PackedInventoryInventoryViewHandlers.registerWorkStation(class_2246.field_16337, registry);
        ANVIL = PackedInventoryInventoryViewHandlers.registerAnvil(registry);
    }

    private static InventoryViewHandlerRegistry.Entry registerDefault(InventoryViewHandlerRegistry registry) {
        return registry.registerDefault((inventory, parentInventory, slot, player) -> {
            InventoryDependentScreenHandlerFactory genericFactory;
            if (inventory instanceof class_3908) {
                player.method_17355((class_3908)inventory);
                return;
            }
            class_2561 name = parentInventory.method_5438(slot).method_7964();
            if (inventory instanceof class_1270) {
                player.method_17355((class_3908)new class_747((class_1270)inventory, name));
            }
            if ((genericFactory = InventoryDependentScreenHandlerFactory.genericOfSize(inventory.method_5439())) != null) {
                player.method_17355(genericFactory.asNamedScreenHandlerFactory(inventory, name));
            }
        });
    }

    private static InventoryViewHandlerRegistry.Entry registerWorkStation(class_2248 workStation, InventoryViewHandlerRegistry registry) {
        return registry.register((__, playerInventory, slot, player) -> {
            class_3908 originalScreenFactory = workStation.method_17454(workStation.method_9564(), player.field_6002, player.method_24515());
            if (originalScreenFactory == null) {
                return;
            }
            class_747 screenFactory = new class_747((syncId, inv, p) -> {
                class_1703 handler = originalScreenFactory.createMenu(syncId, inv, p);
                if (handler == null) {
                    return null;
                }
                return new ScreenHandlerProxy(handler){

                    @Override
                    public boolean method_7597(class_1657 player) {
                        return true;
                    }
                };
            }, originalScreenFactory.method_5476());
            player.method_17355((class_3908)screenFactory);
        }, workStation.method_8389());
    }

    private static InventoryViewHandlerRegistry.Entry registerAnvil(InventoryViewHandlerRegistry registry) {
        return registry.register((__, playerInventory, slot, player) -> {
            class_1799 anvilStack = playerInventory.method_5438(slot);
            class_747 screenFactory = new class_747((syncId, inv, p) -> new ItemDamagingAnvilScreenHandler(syncId, anvilStack, p), ItemDamagingAnvilScreenHandler.TITLE);
            player.method_17355((class_3908)screenFactory);
        }, class_1802.field_8782, class_1802.field_8750, class_1802.field_8427);
    }

    private PackedInventoryInventoryViewHandlers() {
    }
}

