/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.inventory;

import dev.kir.packedinventory.inventory.EmptyInventory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3829;

public final class CombinedInventory
implements class_1263 {
    private final Collection<class_1263> inventories;
    private final int size;
    private final int maxCountPerStack;

    private CombinedInventory(Collection<class_1263> inventories) {
        this.inventories = inventories;
        this.size = inventories.stream().map(class_1263::method_5439).reduce(0, Integer::sum);
        this.maxCountPerStack = inventories.stream().map(class_1263::method_5444).max(Comparator.comparingInt(a -> a)).orElse(64);
    }

    public static class_1263 of() {
        return EmptyInventory.getInstance();
    }

    public static class_1263 of(class_1263 inventory) {
        return inventory;
    }

    public static class_1263 of(class_1263 left, class_1263 right) {
        return new CombinedInventory(List.of(left, right));
    }

    public static class_1263 of(class_1263 ... inventories) {
        return CombinedInventory.of(Arrays.asList(inventories));
    }

    public static class_1263 of(Collection<class_1263> inventories) {
        return switch (inventories.size()) {
            case 0 -> EmptyInventory.getInstance();
            case 1 -> inventories.iterator().next();
            default -> new CombinedInventory(inventories.stream().flatMap(CombinedInventory::asStream).toList());
        };
    }

    public static Stream<class_1263> asStream(class_1263 inventory) {
        return inventory instanceof CombinedInventory ? ((CombinedInventory)inventory).inventories.stream() : Stream.of(inventory);
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        return this.inventories.stream().allMatch(class_1263::method_5442);
    }

    protected <T> T execute(int slot, BiFunction<class_1263, Integer, T> func, T defaultValue) {
        for (class_1263 currentInventory : this.inventories) {
            if (slot < currentInventory.method_5439()) {
                return func.apply(currentInventory, slot);
            }
            slot -= currentInventory.method_5439();
        }
        return defaultValue;
    }

    public class_1799 method_5438(int slot) {
        return this.execute(slot, class_1263::method_5438, class_1799.field_8037);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.execute(slot, (inv, i) -> inv.method_5434(i.intValue(), amount), class_1799.field_8037);
    }

    public class_1799 method_5441(int slot) {
        return this.execute(slot, class_1263::method_5441, class_1799.field_8037);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.execute(slot, (inv, i) -> {
            inv.method_5447(i.intValue(), stack);
            return stack;
        }, class_1799.field_8037);
    }

    public int method_5444() {
        return this.maxCountPerStack;
    }

    public void method_5431() {
        this.inventories.forEach(class_1263::method_5431);
    }

    public boolean method_5443(class_1657 player) {
        return this.inventories.stream().anyMatch(x -> x.method_5443(player));
    }

    public void method_5435(class_1657 player) {
        this.inventories.forEach(x -> x.method_5435(player));
    }

    public void method_5432(class_1657 player) {
        this.inventories.forEach(x -> x.method_5432(player));
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.execute(slot, (inv, i) -> inv.method_5437(i.intValue(), stack), false);
    }

    public void method_5448() {
        this.inventories.forEach(class_3829::method_5448);
    }
}

