/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.config;

import dev.kir.packedinventory.api.v1.config.GenericTooltipConfig;
import dev.kir.packedinventory.api.v1.config.GenericValidationConfig;
import dev.kir.packedinventory.api.v1.config.PackedInventoryApiConfig;
import dev.kir.packedinventory.api.v1.config.PackedInventoryConfigEntryHolder;
import dev.kir.packedinventory.config.PackedInventoryConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

final class PackedInventoryConfigImpl
implements PackedInventoryConfig {
    private static final PackedInventoryConfigImpl INSTANCE = new PackedInventoryConfigImpl();
    private final GenericValidationConfig defaultValidationConfig = new GenericValidationConfig();
    private final GenericTooltipConfig defaultTooltipConfig = new GenericTooltipConfig();
    private final Map<PackedInventoryApiConfig.ConfigSection, Map<class_2960, PackedInventoryConfigEntryHolder<?>>> sections = new HashMap();

    private PackedInventoryConfigImpl() {
    }

    public static PackedInventoryConfigImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public GenericValidationConfig getDefaultValidationConfig() {
        return this.defaultValidationConfig;
    }

    @Override
    public GenericTooltipConfig getDefaultTooltipConfig() {
        return this.defaultTooltipConfig;
    }

    @Override
    @Nullable
    public <T> T get(class_2960 id, PackedInventoryApiConfig.ConfigSection section, Class<? extends T> entryClass) {
        Map<class_2960, PackedInventoryConfigEntryHolder<?>> sectionMap = this.sections.get((Object)section);
        if (sectionMap == null) {
            return null;
        }
        PackedInventoryConfigEntryHolder<?> holder = sectionMap.get(id);
        if (holder == null) {
            return null;
        }
        Object entry = holder.getConfigEntry();
        if (entryClass.isInstance(entry)) {
            return (T)entry;
        }
        return null;
    }

    @Override
    public <T> void register(class_2960 id, PackedInventoryApiConfig.ConfigSection section, PackedInventoryConfigEntryHolder<T> configEntryHolder) {
        this.sections.computeIfAbsent(section, s -> new HashMap()).put(id, configEntryHolder);
    }
}

