/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.networking;

import com.mojang.datafixers.util.Either;
import dev.kir.packedinventory.PackedInventory;
import dev.kir.packedinventory.api.v1.FailureReason;
import dev.kir.packedinventory.api.v1.inventory.InventoryValidationFailureHandlerRegistry;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewHandlerRegistry;
import dev.kir.packedinventory.api.v1.inventory.InventoryViewerRegistry;
import dev.kir.packedinventory.api.v1.networking.PackedInventoryBulkEditRequest;
import dev.kir.packedinventory.inventory.CombinedInventory;
import dev.kir.packedinventory.inventory.StackReferenceInventory;
import dev.kir.packedinventory.util.inventory.InventoryUtil;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class PackedInventoryEditRequest {
    public static final class_2960 ID = PackedInventory.locate("packed_inventory_edit_request");
    public static final int CURSOR_SLOT = -1;

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(int playerInventorySlotIndex) {
        PackedInventoryEditRequest.sendToServer(playerInventorySlotIndex, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(int slotIndex, boolean isHandledScreenSlot) {
        PackedInventoryEditRequest.sendToServer(ActionType.DEFAULT, slotIndex, -1, isHandledScreenSlot);
    }

    @Deprecated(since="0.2.0")
    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(int slotIndex, boolean isHandledScreenSlot, boolean shouldReturnToPreviousScreen) {
        PackedInventoryEditRequest.sendToServer(slotIndex, isHandledScreenSlot);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(ActionType actionType, int slotIndex, boolean isHandledScreenSlots) {
        PackedInventoryEditRequest.sendToServer(actionType, slotIndex, -1, isHandledScreenSlots);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(ActionType actionType, int primarySlotIndex, int secondarySlotIndex, boolean isHandledScreenSlots) {
        if (!ClientPlayNetworking.canSend((class_2960)ID)) {
            return;
        }
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10817((Enum)actionType);
        buffer.writeBoolean(isHandledScreenSlots);
        buffer.method_10804(primarySlotIndex);
        buffer.method_10804(secondarySlotIndex);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buffer);
    }

    private static void execute(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int secondarySlot;
        int primarySlot;
        class_1661 inventory;
        ActionType actionType = (ActionType)buf.method_10818(ActionType.class);
        boolean isHandledScreenSlot = buf.readBoolean();
        int primarySlotIndex = buf.method_10816();
        int secondarySlotIndex = buf.method_10816();
        if (isHandledScreenSlot) {
            boolean hasCursorSlot;
            class_1735 primarySlotHandler;
            class_2371 slots = player.field_7512.field_7761;
            int slotCount = slots.size();
            class_1735 class_17352 = primarySlotHandler = primarySlotIndex >= 0 && primarySlotIndex < slotCount ? (class_1735)slots.get(primarySlotIndex) : null;
            if (primarySlotHandler == null && primarySlotIndex != -1) {
                return;
            }
            class_1735 secondarySlotHandler = secondarySlotIndex >= 0 && secondarySlotIndex < slotCount ? (class_1735)slots.get(secondarySlotIndex) : null;
            boolean bl = hasCursorSlot = primarySlotIndex == -1 || secondarySlotIndex == -1 && actionType == ActionType.QUICK_TRANSFER;
            if (!(primarySlotHandler == null || secondarySlotHandler != null && primarySlotHandler.field_7871 != secondarySlotHandler.field_7871 || hasCursorSlot)) {
                inventory = primarySlotHandler.field_7871;
            } else {
                LinkedHashSet<class_1263> inventories = new LinkedHashSet<class_1263>(3);
                if (primarySlotHandler != null) {
                    inventories.add(primarySlotHandler.field_7871);
                }
                if (secondarySlotHandler != null) {
                    inventories.add(secondarySlotHandler.field_7871);
                }
                if (hasCursorSlot) {
                    inventories.add(StackReferenceInventory.ofCursorStack(player.field_7512));
                }
                inventory = CombinedInventory.of(inventories);
            }
            int n = primarySlot = primarySlotHandler == null ? inventory.method_5439() - 1 : primarySlotHandler.method_34266();
            secondarySlot = secondarySlotHandler == null ? inventory.method_5439() - 1 : secondarySlotHandler.method_34266() + (primarySlotHandler != null && primarySlotHandler.field_7871 != secondarySlotHandler.field_7871 ? primarySlotHandler.field_7871.method_5439() : 0);
        } else {
            inventory = primarySlotIndex == -1 || secondarySlotIndex == -1 && actionType == ActionType.QUICK_TRANSFER ? CombinedInventory.of((class_1263)player.method_31548(), (class_1263)StackReferenceInventory.ofCursorStack((class_1703)player.field_7498)) : player.method_31548();
            primarySlot = primarySlotIndex == -1 ? inventory.method_5439() - 1 : primarySlotIndex;
            secondarySlot = secondarySlotIndex == -1 ? inventory.method_5439() - 1 : secondarySlotIndex;
        }
        switch (actionType) {
            case DEFAULT: {
                server.execute(() -> PackedInventoryEditRequest.lambda$execute$0((class_1263)inventory, primarySlot, player));
                break;
            }
            case QUICK_TRANSFER: {
                server.execute(() -> PackedInventoryEditRequest.lambda$execute$1((class_1263)inventory, primarySlot, secondarySlot, player));
                break;
            }
            case DROP: {
                server.execute(() -> PackedInventoryEditRequest.lambda$execute$2((class_1263)inventory, primarySlot, player));
            }
        }
    }

    private static void executeDefaultAction(class_1263 inventory, int slot, class_3222 player) {
        PackedInventoryEditRequest.getView(inventory, slot, player).ifPresent(view -> view.ifLeft(x -> PackedInventoryEditRequest.handleView(x, inventory, slot, player)).ifRight(x -> PackedInventoryEditRequest.handleFailure(x, inventory, slot, player)));
    }

    private static void executeQuickTransferAction(class_1263 inventory, int primarySlot, int secondarySlot, class_3222 player) {
        int toSlot;
        class_1263 to;
        int fromSlot;
        class_1263 from;
        Optional optionalQuickView;
        InventoryViewerRegistry registry = InventoryViewerRegistry.getInstance();
        int quickViewSlot = registry.hasView(inventory, primarySlot, (class_1657)player) ? primarySlot : (registry.hasView(inventory, secondarySlot, (class_1657)player) ? secondarySlot : -1);
        Optional<Object> optional = optionalQuickView = quickViewSlot == -1 ? Optional.empty() : PackedInventoryEditRequest.getView(inventory, quickViewSlot, player);
        if (optionalQuickView.isEmpty()) {
            return;
        }
        Either quickView = (Either)optionalQuickView.get();
        if (quickView.right().isPresent()) {
            PackedInventoryEditRequest.handleFailure((FailureReason)quickView.right().get(), inventory, quickViewSlot, player);
            return;
        }
        class_1263 quickViewInventory = quickView.left().orElse(inventory);
        if (quickViewInventory.method_5439() == 0) {
            if (quickViewSlot == primarySlot && registry.hasView(inventory, secondarySlot, (class_1657)player)) {
                quickViewSlot = secondarySlot;
                Optional<Object> optional2 = optionalQuickView = quickViewSlot == -1 ? Optional.empty() : PackedInventoryEditRequest.getView(inventory, quickViewSlot, player);
                if (optionalQuickView.isEmpty()) {
                    return;
                }
                quickView = (Either)optionalQuickView.get();
                if (quickView.right().isPresent()) {
                    PackedInventoryEditRequest.handleFailure((FailureReason)quickView.right().get(), inventory, quickViewSlot, player);
                    return;
                }
                quickViewInventory = quickView.left().orElse(inventory);
            } else {
                return;
            }
        }
        if (quickViewSlot == primarySlot) {
            if (inventory.method_5438(secondarySlot).method_7960()) {
                from = quickViewInventory;
                fromSlot = -1;
                to = inventory;
                toSlot = secondarySlot;
            } else {
                from = inventory;
                fromSlot = secondarySlot;
                to = quickViewInventory;
                toSlot = -1;
            }
        } else {
            from = inventory;
            fromSlot = primarySlot;
            to = quickViewInventory;
            toSlot = -1;
        }
        PackedInventoryEditRequest.handleQuickView(from, fromSlot, to, toSlot);
    }

    private static void executeDropAction(class_1263 inventory, int slot, class_3222 player) {
        PackedInventoryEditRequest.getView(inventory, slot, player).ifPresent(view -> view.ifLeft(x -> PackedInventoryEditRequest.handleDropView(x, player)).ifRight(x -> PackedInventoryEditRequest.handleFailure(x, inventory, slot, player)));
    }

    static void handleView(class_1263 view, class_1263 inventory, int slot, class_3222 player) {
        InventoryViewHandlerRegistry.getInstance().handle(view, inventory, slot, (class_1657)player);
    }

    static void handleFailure(FailureReason failure, class_1263 inventory, int slot, class_3222 player) {
        InventoryValidationFailureHandlerRegistry.getInstance().handle(failure, inventory, slot, (class_1657)player);
    }

    static void handleQuickView(class_1263 from, int fromSlot, class_1263 to, int toSlot) {
        int sourceSlot;
        int targetSlot;
        int origFromSlot = fromSlot;
        int origToSlot = toSlot;
        if (fromSlot == -1 && (fromSlot = InventoryUtil.lastIndexOf(from, (arg_0, arg_1) -> PackedInventoryEditRequest.lambda$handleQuickView$9(from, to, targetSlot = toSlot, arg_0, arg_1))) == -1) {
            return;
        }
        class_1799 fromStack = from.method_5438(fromSlot);
        if (toSlot == -1 && (toSlot = InventoryUtil.indexOf(to, (arg_0, arg_1) -> PackedInventoryEditRequest.lambda$handleQuickView$10(from, sourceSlot = fromSlot, to, fromStack, arg_0, arg_1))) == -1) {
            return;
        }
        class_1799 toStack = to.method_5438(toSlot);
        if (toStack.method_7960()) {
            toStack = fromStack.method_7972();
            fromStack.method_7939(0);
        } else {
            int d = Math.min(toStack.method_7914() - toStack.method_7947(), fromStack.method_7947());
            fromStack.method_7934(d);
            toStack.method_7933(d);
        }
        to.method_5447(toSlot, toStack);
        if (fromStack.method_7960()) {
            from.method_5441(fromSlot);
        } else {
            from.method_5447(fromSlot, fromStack);
            PackedInventoryEditRequest.handleQuickView(from, origFromSlot, to, origToSlot);
        }
    }

    static void handleDropView(class_1263 view, class_3222 player) {
        int size = view.method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = view.method_5441(i);
            if (stack.method_7960()) continue;
            player.method_7328(stack, true);
        }
    }

    static Optional<Either<class_1263, FailureReason>> getView(class_1263 inventory, int slot, class_3222 player) {
        InventoryViewerRegistry registry = InventoryViewerRegistry.getInstance();
        Optional<Either<class_1263, FailureReason>> view = registry.view(inventory, slot, (class_1657)player);
        if (view.isEmpty()) {
            return view;
        }
        if (view.get().right().isPresent()) {
            FailureReason currentFailureReason = (FailureReason)view.get().right().get();
            LinkedHashSet<class_1263> availableInventories = new LinkedHashSet<class_1263>();
            availableInventories.add(inventory);
            for (class_1735 screenHandlerSlot : player.field_7512.field_7761) {
                availableInventories.add(screenHandlerSlot.field_7871);
            }
            if (availableInventories.size() > 1) {
                view = registry.view(CombinedInventory.of(availableInventories), slot, (class_1657)player).or(() -> Optional.of(Either.right((Object)currentFailureReason)));
            }
        }
        return view;
    }

    public static void registerServerReceiver(BiFunction<class_2960, ServerPlayNetworking.PlayChannelHandler, Boolean> receiver) {
        receiver.apply(ID, PackedInventoryEditRequest::execute);
    }

    private PackedInventoryEditRequest() {
    }

    private static /* synthetic */ boolean lambda$handleQuickView$10(class_1263 from, int sourceSlot, class_1263 to, class_1799 fromStack, class_1799 x, Integer i) {
        return !InventoryUtil.isSameSlot(from, sourceSlot, to, i) && InventoryUtil.canInsertOrPartiallyCombine(to, i, fromStack);
    }

    private static /* synthetic */ boolean lambda$handleQuickView$9(class_1263 from, class_1263 to, int targetSlot, class_1799 x, Integer i) {
        return !x.method_7960() && !InventoryUtil.isSameSlot(from, i, to, targetSlot) && InventoryUtil.canInsertOrPartiallyCombine(to, targetSlot, x);
    }

    private static /* synthetic */ void lambda$execute$2(class_1263 inventory, int primarySlot, class_3222 player) {
        PackedInventoryEditRequest.executeDropAction(inventory, primarySlot, player);
    }

    private static /* synthetic */ void lambda$execute$1(class_1263 inventory, int primarySlot, int secondarySlot, class_3222 player) {
        PackedInventoryEditRequest.executeQuickTransferAction(inventory, primarySlot, secondarySlot, player);
    }

    private static /* synthetic */ void lambda$execute$0(class_1263 inventory, int primarySlot, class_3222 player) {
        PackedInventoryEditRequest.executeDefaultAction(inventory, primarySlot, player);
    }

    public static enum ActionType {
        DEFAULT,
        QUICK_TRANSFER,
        DROP;


        public Optional<PackedInventoryBulkEditRequest.ActionType> asBulkEditActionType() {
            return Optional.of(switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> PackedInventoryBulkEditRequest.ActionType.DEFAULT;
                case QUICK_TRANSFER -> PackedInventoryBulkEditRequest.ActionType.QUICK_TRANSFER;
                case DROP -> PackedInventoryBulkEditRequest.ActionType.DROP;
            });
        }
    }
}

