/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.networking;

import com.mojang.datafixers.util.Either;
import dev.kir.packedinventory.PackedInventory;
import dev.kir.packedinventory.api.v1.FailureReason;
import dev.kir.packedinventory.api.v1.networking.PackedInventoryEditRequest;
import dev.kir.packedinventory.inventory.CombinedInventory;
import dev.kir.packedinventory.inventory.StackReferenceInventory;
import dev.kir.packedinventory.util.inventory.InventoryUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class PackedInventoryBulkEditRequest {
    public static final class_2960 ID = PackedInventory.locate("packed_inventory_bulk_edit_request");
    public static final int CURSOR_SLOT = -1;

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(List<Integer> slots) {
        PackedInventoryBulkEditRequest.sendToServer(slots, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(List<Integer> slots, boolean isHandledScreenSlots) {
        PackedInventoryBulkEditRequest.sendToServer(ActionType.DEFAULT, slots, isHandledScreenSlots);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(ActionType actionType, List<Integer> slots, boolean isHandledScreenSlots) {
        PackedInventoryBulkEditRequest.sendToServer(actionType, slots, (List<Integer>)IntList.of((int)-1), isHandledScreenSlots);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(ActionType actionType, int primarySlotIndex, List<Integer> secondarySlotIndices, boolean isHandledScreenSlots) {
        PackedInventoryBulkEditRequest.sendToServer(actionType, (List<Integer>)IntList.of((int)primarySlotIndex), secondarySlotIndices, isHandledScreenSlots);
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(ActionType actionType, List<Integer> primarySlotIndices, List<Integer> secondarySlotIndices, boolean isHandledScreenSlots) {
        if (!ClientPlayNetworking.canSend((class_2960)ID)) {
            return;
        }
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10817((Enum)actionType);
        buffer.writeBoolean(isHandledScreenSlots);
        buffer.method_34060(PackedInventoryBulkEditRequest.asIntList(primarySlotIndices));
        buffer.method_34060(PackedInventoryBulkEditRequest.asIntList(secondarySlotIndices));
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buffer);
    }

    private static void execute(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        IntArrayList secondarySlots;
        IntArrayList primarySlots;
        class_1661 inventory;
        ActionType actionType = (ActionType)buf.method_10818(ActionType.class);
        boolean isHandledScreenSlot = buf.readBoolean();
        IntList primarySlotIndices = buf.method_34059();
        IntList secondarySlotIndices = buf.method_34059();
        if (isHandledScreenSlot) {
            int slot;
            class_2371 slots = player.field_7512.field_7761;
            int slotCount = slots.size();
            boolean hasCursorSlot = primarySlotIndices.contains(-1);
            List<class_1735> primarySlotHandlers = primarySlotIndices.intStream().mapToObj(arg_0 -> PackedInventoryBulkEditRequest.lambda$execute$0(slotCount, (List)slots, arg_0)).toList();
            if (!hasCursorSlot && primarySlotHandlers.stream().allMatch(Objects::isNull)) {
                return;
            }
            List<class_1735> secondarySlotHandlers = secondarySlotIndices.intStream().mapToObj(arg_0 -> PackedInventoryBulkEditRequest.lambda$execute$1(slotCount, (List)slots, arg_0)).toList();
            hasCursorSlot = hasCursorSlot || secondarySlotIndices.contains(-1);
            LinkedHashSet<class_1263> inventories = new LinkedHashSet<class_1263>(3);
            for (class_1735 primarySlotHandler : primarySlotHandlers) {
                if (primarySlotHandler == null) continue;
                inventories.add(primarySlotHandler.field_7871);
            }
            for (class_1735 secondarySlotHandler : secondarySlotHandlers) {
                if (secondarySlotHandler == null) continue;
                inventories.add(secondarySlotHandler.field_7871);
            }
            if (hasCursorSlot) {
                inventories.add(StackReferenceInventory.ofCursorStack(player.field_7512));
            }
            inventory = CombinedInventory.of(inventories);
            int cursorSlot = inventory.method_5439() - 1;
            primarySlots = new IntArrayList(primarySlotHandlers.size());
            for (class_1735 slotHandler : primarySlotHandlers) {
                slot = slotHandler == null ? cursorSlot : InventoryUtil.firstIndexOf((class_1263)inventory, slotHandler.field_7871) + slotHandler.method_34266();
                primarySlots.add(slot);
            }
            secondarySlots = new IntArrayList(secondarySlotHandlers.size());
            for (class_1735 slotHandler : secondarySlotHandlers) {
                slot = slotHandler == null ? cursorSlot : InventoryUtil.firstIndexOf((class_1263)inventory, slotHandler.field_7871) + slotHandler.method_34266();
                secondarySlots.add(slot);
            }
        } else {
            int slotIndex;
            int i;
            boolean hasCursorSlot = primarySlotIndices.contains(-1) || secondarySlotIndices.contains(-1);
            inventory = hasCursorSlot ? CombinedInventory.of((class_1263)player.method_31548(), (class_1263)StackReferenceInventory.ofCursorStack((class_1703)player.field_7498)) : player.method_31548();
            int cursorSlot = inventory.method_5439() - 1;
            primarySlots = new IntArrayList(primarySlotIndices.size());
            for (i = 0; i < primarySlotIndices.size(); ++i) {
                slotIndex = primarySlotIndices.getInt(i);
                primarySlots.add(slotIndex == -1 ? cursorSlot : slotIndex);
            }
            secondarySlots = new IntArrayList(secondarySlotIndices.size());
            for (i = 0; i < secondarySlotIndices.size(); ++i) {
                slotIndex = secondarySlotIndices.getInt(i);
                secondarySlots.add(slotIndex == -1 ? cursorSlot : slotIndex);
            }
        }
        switch (actionType) {
            case DEFAULT: {
                server.execute(() -> PackedInventoryBulkEditRequest.lambda$execute$2((class_1263)inventory, (IntList)primarySlots, player));
                break;
            }
            case QUICK_TRANSFER: {
                server.execute(() -> PackedInventoryBulkEditRequest.lambda$execute$3((class_1263)inventory, (IntList)primarySlots, (IntList)secondarySlots, player));
                break;
            }
            case DROP: {
                server.execute(() -> PackedInventoryBulkEditRequest.lambda$execute$4((class_1263)inventory, (IntList)primarySlots, player));
            }
        }
    }

    private static void executeDefaultAction(class_1263 inventory, IntList slots, class_3222 player) {
        PackedInventoryBulkEditRequest.executeAction(inventory, slots, player, (view, slot) -> {
            PackedInventoryEditRequest.handleView(view, inventory, slot, player);
            return true;
        });
    }

    private static void executeQuickTransferAction(class_1263 inventory, IntList primarySlots, IntList secondarySlots, class_3222 player) {
        boolean shouldExtract = secondarySlots.intStream().anyMatch(x -> inventory.method_5438(x).method_7960());
        PackedInventoryBulkEditRequest.executeAction(inventory, primarySlots, player, (view, slot) -> {
            PackedInventoryBulkEditRequest.executeQuickTransferAction(inventory, view, secondarySlots, shouldExtract);
            return secondarySlots.isEmpty();
        });
    }

    private static void executeQuickTransferAction(class_1263 inventory, class_1263 view, IntList secondarySlots, boolean shouldExtract) {
        for (int i = 0; i < secondarySlots.size(); ++i) {
            int toSlot;
            class_1263 to;
            int fromSlot;
            class_1263 from;
            int slot = secondarySlots.getInt(i);
            if (inventory.method_5438(slot).method_7960() != shouldExtract) continue;
            if (shouldExtract) {
                from = view;
                fromSlot = -1;
                to = inventory;
                toSlot = slot;
            } else {
                from = inventory;
                fromSlot = slot;
                to = view;
                toSlot = -1;
            }
            PackedInventoryEditRequest.handleQuickView(from, fromSlot, to, toSlot);
        }
    }

    private static void executeDropAction(class_1263 inventory, IntList slots, class_3222 player) {
        PackedInventoryBulkEditRequest.executeAction(inventory, slots, player, (view, slot) -> {
            PackedInventoryEditRequest.handleDropView(view, player);
            return false;
        });
    }

    private static IntList asIntList(List<Integer> ints) {
        return ints instanceof IntList ? (IntList)ints : new IntImmutableList(ints);
    }

    private static void executeAction(class_1263 inventory, IntList slots, class_3222 player, BiFunction<class_1263, Integer, Boolean> viewHandler) {
        boolean succeed = false;
        int lastSlot = -1;
        FailureReason lastFailure = null;
        for (int i = 0; i < slots.size(); ++i) {
            int slot = slots.getInt(i);
            Optional<Either<class_1263, FailureReason>> optionalView = PackedInventoryEditRequest.getView(inventory, slot, player);
            if (optionalView.isEmpty()) continue;
            Either<class_1263, FailureReason> view = optionalView.get();
            if (view.left().isPresent()) {
                if (viewHandler.apply((class_1263)view.left().get(), slot).booleanValue()) {
                    return;
                }
                succeed = true;
                continue;
            }
            if (!view.right().isPresent()) continue;
            lastSlot = slot;
            lastFailure = (FailureReason)view.right().get();
        }
        if (!succeed && lastFailure != null) {
            PackedInventoryEditRequest.handleFailure(lastFailure, inventory, lastSlot, player);
        }
    }

    public static void registerServerReceiver(BiFunction<class_2960, ServerPlayNetworking.PlayChannelHandler, Boolean> receiver) {
        receiver.apply(ID, PackedInventoryBulkEditRequest::execute);
    }

    private PackedInventoryBulkEditRequest() {
    }

    private static /* synthetic */ void lambda$execute$4(class_1263 inventory, IntList primarySlots, class_3222 player) {
        PackedInventoryBulkEditRequest.executeDropAction(inventory, primarySlots, player);
    }

    private static /* synthetic */ void lambda$execute$3(class_1263 inventory, IntList primarySlots, IntList secondarySlots, class_3222 player) {
        PackedInventoryBulkEditRequest.executeQuickTransferAction(inventory, primarySlots, secondarySlots, player);
    }

    private static /* synthetic */ void lambda$execute$2(class_1263 inventory, IntList primarySlots, class_3222 player) {
        PackedInventoryBulkEditRequest.executeDefaultAction(inventory, primarySlots, player);
    }

    private static /* synthetic */ class_1735 lambda$execute$1(int slotCount, List slots, int x) {
        return x >= 0 && x < slotCount ? (class_1735)slots.get(x) : null;
    }

    private static /* synthetic */ class_1735 lambda$execute$0(int slotCount, List slots, int x) {
        return x >= 0 && x < slotCount ? (class_1735)slots.get(x) : null;
    }

    public static enum ActionType {
        DEFAULT,
        QUICK_TRANSFER,
        DROP;


        public Optional<PackedInventoryEditRequest.ActionType> asEditActionType() {
            return Optional.of(switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> PackedInventoryEditRequest.ActionType.DEFAULT;
                case QUICK_TRANSFER -> PackedInventoryEditRequest.ActionType.QUICK_TRANSFER;
                case DROP -> PackedInventoryEditRequest.ActionType.DROP;
            });
        }
    }
}

