/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.util.collection.EmptyList;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipText {
    public static final List<Part> DEFAULT_ORDER = List.of(Part.values());
    private final List<class_2561> list;
    private final List<Segment> segments;
    private final Map<Segment, SegmentedTextList> subLists;

    private TooltipText(List<class_2561> list, List<Segment> segments) {
        this.list = list;
        this.segments = segments;
        this.subLists = new HashMap<Segment, SegmentedTextList>();
    }

    public static TooltipText empty() {
        Builder builder = new Builder(new ArrayList<class_2561>());
        for (Part part : DEFAULT_ORDER) {
            builder.beginSection(part);
            builder.endSection();
        }
        return builder.build();
    }

    @ApiStatus.Internal
    public static Builder builder(List<class_2561> list) {
        return new Builder(list);
    }

    public boolean containsPart(Part part) {
        return this.findSegmentIndex(part) != -1;
    }

    public void appendPart(Part part) {
        this.addPart(part, this.segments.size());
    }

    public void prependPart(Part part) {
        this.addPart(part, 0);
    }

    public boolean insertPartAfter(Part part, Part anchorPart) {
        return this.addPartByAnchor(part, anchorPart, 1);
    }

    public boolean insertPartBefore(Part part, Part anchorPart) {
        return this.addPartByAnchor(part, anchorPart, 0);
    }

    private boolean addPartByAnchor(Part part, Part anchorPart, int shift) {
        int i = this.findSegmentIndex(anchorPart);
        if (i == -1) {
            return false;
        }
        this.addPart(part, i + shift);
        return true;
    }

    private void addPart(Part part, int i) {
        int listIndex = i == 0 ? 0 : this.segments.get((int)(i - 1)).end;
        this.segments.add(i, new Segment(part, listIndex, listIndex));
    }

    public List<class_2561> subList(Part part) {
        int i = this.findSegmentIndex(part);
        if (i == -1) {
            return EmptyList.getInstance();
        }
        return this.subLists.computeIfAbsent(this.segments.get(i), segment -> new SegmentedTextList(this, (Segment)segment, i));
    }

    public boolean append(Part part, class_2561 text) {
        return this.subList(part).add(text);
    }

    public boolean appendAll(Part part, class_2561 ... text) {
        return this.appendAll(part, Arrays.asList(text));
    }

    public boolean appendAll(Part part, Collection<class_2561> text) {
        return this.subList(part).addAll(text);
    }

    public boolean prepend(Part part, class_2561 text) {
        List<class_2561> sublist = this.subList(part);
        if (sublist == EmptyList.getInstance()) {
            return false;
        }
        sublist.add(0, text);
        return true;
    }

    public boolean prependAll(Part part, class_2561 ... text) {
        return this.prependAll(part, Arrays.asList(text));
    }

    public boolean prependAll(Part part, Collection<class_2561> text) {
        List<class_2561> sublist = this.subList(part);
        if (sublist == EmptyList.getInstance()) {
            return false;
        }
        sublist.addAll(0, text);
        return true;
    }

    public boolean set(Part part, class_2561 text) {
        this.clear(part);
        return this.append(part, text);
    }

    public boolean setAll(Part part, class_2561 ... text) {
        return this.setAll(part, Arrays.asList(text));
    }

    public boolean setAll(Part part, Collection<class_2561> text) {
        this.clear(part);
        return this.appendAll(part, text);
    }

    public boolean remove(Part part, class_2561 text) {
        return this.subList(part).remove(text);
    }

    public boolean removeAll(Part part, class_2561 ... text) {
        return this.removeAll(part, Arrays.asList(text));
    }

    public boolean removeAll(Part part, Collection<class_2561> text) {
        return this.subList(part).removeAll(text);
    }

    public boolean contains(Part part, class_2561 text) {
        return this.subList(part).contains(text);
    }

    public void clear(Part part) {
        this.subList(part).clear();
    }

    private int findSegmentIndex(Part part) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (this.segments.get((int)i).part != part) continue;
            return i;
        }
        return -1;
    }

    public List<class_2561> toList() {
        return new ArrayList<class_2561>(this.list);
    }

    public List<class_2561> toList(Part ... order) {
        return this.toList(Arrays.asList(order));
    }

    public List<class_2561> toList(Collection<Part> order) {
        ArrayList<class_2561> orderedList = new ArrayList<class_2561>(order.size());
        for (Part part : order) {
            orderedList.addAll(this.subList(part));
        }
        return orderedList;
    }

    @ApiStatus.Internal
    public static final class Builder {
        private final List<class_2561> list;
        private final List<Segment> segments;
        private final BuilderList wrapper;
        private int currentIndex;
        private boolean isInvalid;
        @Nullable
        private Part currentPart;
        @Nullable
        private TooltipText builtTooltipText;

        private Builder(List<class_2561> list) {
            this.list = list;
            this.segments = new ArrayList<Segment>();
            this.currentIndex = list.size();
            this.wrapper = new BuilderList(this);
        }

        public boolean containsSection(Part part) {
            if (this.currentPart == part) {
                return true;
            }
            for (Segment segment : this.segments) {
                if (segment.part != part) continue;
                return true;
            }
            return false;
        }

        public Builder beginSection(Part part) {
            if (this.currentPart == part || this.isInvalid) {
                return this;
            }
            if (this.currentPart != null) {
                this.endSection();
            }
            this.currentPart = part;
            this.currentIndex = this.list.size();
            return this;
        }

        public Builder endSection() {
            if (this.isInvalid || this.currentPart == null) {
                return this;
            }
            if (this.list.size() < this.currentIndex) {
                this.isInvalid = true;
                this.segments.clear();
                return this;
            }
            this.segments.add(new Segment(this.currentPart, this.currentIndex, this.list.size()));
            this.currentPart = null;
            return this;
        }

        public TooltipText build() {
            if (this.builtTooltipText != null) {
                return this.builtTooltipText;
            }
            this.endSection();
            this.isInvalid = true;
            this.builtTooltipText = new TooltipText(this.list, this.segments);
            return this.builtTooltipText;
        }

        @Deprecated
        @ApiStatus.Internal
        public BuilderList asList() {
            return this.wrapper;
        }
    }

    public static enum Part {
        NAME,
        MAP_ID,
        ADDITIONAL(class_1799.class_5422.field_25773),
        ENCHANTMENTS(class_1799.class_5422.field_25768),
        DYE(class_1799.class_5422.field_25774),
        LORE,
        MODIFIERS(class_1799.class_5422.field_25769),
        UNBREAKABLE(class_1799.class_5422.field_25770),
        CAN_DESTROY(class_1799.class_5422.field_25771),
        CAN_PLACE(class_1799.class_5422.field_25772),
        DURABILITY,
        ITEM_ID,
        NBT_TAGS,
        UNKNOWN;

        @Nullable
        private final class_1799.class_5422 section;

        private Part() {
            this(null);
        }

        private Part(class_1799.class_5422 section) {
            this.section = section;
        }

        @Nullable
        public class_1799.class_5422 getSection() {
            return this.section;
        }
    }

    private static final class Segment {
        public final Part part;
        public int start;
        public int end;

        public Segment(Part part, int start, int end) {
            this.part = part;
            this.start = start;
            this.end = end;
        }
    }

    private static class SegmentedTextList
    implements List<class_2561> {
        protected final TooltipText text;
        protected final Segment segment;
        protected final int segmentIndex;

        public SegmentedTextList(TooltipText text, Segment segment, int segmentIndex) {
            this.text = text;
            this.segment = segment;
            this.segmentIndex = segmentIndex;
            this.updateSegment();
        }

        protected void updateSegment() {
            this.segment.start = Math.min(this.segment.start, this.text.list.size());
            this.segment.end = Math.min(this.segment.end, this.text.list.size());
        }

        protected void updateSegment(int lengthDelta) {
            this.segment.end = class_3532.method_15340((int)(this.segment.end + lengthDelta), (int)this.segment.start, (int)this.text.list.size());
        }

        private boolean updateSegments(int lengthDelta) {
            this.updateSegment(lengthDelta);
            for (int i = this.segmentIndex + 1; i < this.text.segments.size(); ++i) {
                Segment segment = this.text.segments.get(i);
                segment.start = class_3532.method_15340((int)(segment.start + lengthDelta), (int)0, (int)this.text.list.size());
                segment.end = class_3532.method_15340((int)(segment.end + lengthDelta), (int)segment.start, (int)this.text.list.size());
            }
            return lengthDelta != 0;
        }

        private int toExistingListIndex(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.segment.start + index;
        }

        private int toListIndex(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.segment.start + index;
        }

        @Override
        public int size() {
            this.updateSegment();
            return this.segment.end - this.segment.start;
        }

        @Override
        public boolean isEmpty() {
            this.updateSegment();
            return this.segment.end == this.segment.start;
        }

        @Override
        public boolean contains(Object o) {
            this.updateSegment();
            for (int i = this.segment.start; i < this.segment.end; ++i) {
                if (!Objects.equals(this.text.list.get(i), o)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public Iterator<class_2561> iterator() {
            return this.listIterator();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            int size = this.size();
            Object[] array = new Object[size];
            int i = this.segment.start;
            int j = 0;
            while (i < this.segment.end) {
                array[j] = this.text.list.get(i);
                ++i;
                ++j;
            }
            return array;
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            TypeDescriptor.OfField componentType = a.getClass().componentType();
            if (!((Class)componentType).isAssignableFrom(class_2561.class)) {
                throw new ArrayStoreException();
            }
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(componentType, size);
            }
            int i = this.segment.start;
            int j = 0;
            while (i < this.segment.end) {
                a[j] = this.text.list.get(i);
                ++i;
                ++j;
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public boolean add(class_2561 text) {
            this.text.list.add(this.segment.end, text);
            this.updateSegments(1);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            this.updateSegment();
            for (int i = this.segment.start; i < this.segment.end; ++i) {
                if (!Objects.equals(o, this.text.list.get(i))) continue;
                this.text.list.remove(i);
                this.updateSegments(-1);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            for (Object x : c) {
                if (this.contains(x)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends class_2561> c) {
            return this.addAll(this.size(), c);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends class_2561> c) {
            int startIndex;
            int currentIndex = startIndex = this.toListIndex(index);
            for (class_2561 class_25612 : c) {
                this.text.list.add(currentIndex++, class_25612);
            }
            return this.updateSegments(currentIndex - startIndex);
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            boolean removed = false;
            for (Object x : c) {
                removed |= this.remove(x);
            }
            return removed;
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            ArrayList remove = new ArrayList(c.size());
            for (Object x : c) {
                if (this.contains(x)) continue;
                remove.add(x);
            }
            return this.removeAll(remove);
        }

        @Override
        public void clear() {
            int size = this.size();
            if (size == 0) {
                return;
            }
            this.text.list.subList(this.segment.start, this.segment.end).clear();
            this.updateSegments(-size);
        }

        @Override
        public class_2561 get(int index) {
            return this.text.list.get(this.toExistingListIndex(index));
        }

        @Override
        public class_2561 set(int index, class_2561 element) {
            return this.text.list.set(this.toExistingListIndex(index), element);
        }

        @Override
        public void add(int index, class_2561 element) {
            this.text.list.add(this.toListIndex(index), element);
            this.updateSegments(1);
        }

        @Override
        public class_2561 remove(int index) {
            class_2561 removed = this.text.list.remove(this.toExistingListIndex(index));
            this.updateSegments(-1);
            return removed;
        }

        @Override
        public int indexOf(Object o) {
            this.updateSegment();
            int i = this.segment.start;
            int j = 0;
            while (i < this.segment.end) {
                if (Objects.equals(o, this.text.list.get(i))) {
                    return j;
                }
                ++i;
                ++j;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            this.updateSegment();
            int i = this.segment.end - 1;
            int j = this.size() - 1;
            while (i >= this.segment.start) {
                if (Objects.equals(o, this.text.list.get(i))) {
                    return j;
                }
                --i;
                --j;
            }
            return -1;
        }

        @Override
        @NotNull
        public ListIterator<class_2561> listIterator() {
            return this.listIterator(0);
        }

        @Override
        @NotNull
        public ListIterator<class_2561> listIterator(int index) {
            if (index == 0 && this.isEmpty()) {
                return EmptyList.getInstance().listIterator();
            }
            final int listStart = this.toExistingListIndex(index);
            final int listEnd = this.segment.end;
            final SegmentedTextList it = this;
            return new ListIterator<class_2561>(){
                private final SegmentedTextList textList;
                private int currentIndex;
                private final int start;
                private int end;
                {
                    this.textList = it;
                    this.currentIndex = listStart - 1;
                    this.start = listStart;
                    this.end = listEnd;
                }

                @Override
                public boolean hasNext() {
                    return this.currentIndex + 1 < this.end;
                }

                @Override
                public class_2561 next() {
                    return this.textList.text.list.get(++this.currentIndex);
                }

                @Override
                public boolean hasPrevious() {
                    return this.currentIndex > this.start;
                }

                @Override
                public class_2561 previous() {
                    return this.textList.text.list.get(--this.currentIndex);
                }

                @Override
                public int nextIndex() {
                    return Math.min(this.currentIndex + 1, this.end);
                }

                @Override
                public int previousIndex() {
                    if (this.currentIndex <= this.start) {
                        return -1;
                    }
                    return this.currentIndex - 1;
                }

                @Override
                public void remove() {
                    this.textList.text.list.remove(this.currentIndex--);
                    --this.end;
                    this.textList.updateSegments(-1);
                }

                @Override
                public void set(class_2561 text) {
                    this.textList.text.list.set(this.currentIndex, text);
                }

                @Override
                public void add(class_2561 text) {
                    this.textList.text.list.add(this.currentIndex++, text);
                    ++this.end;
                    this.textList.updateSegments(1);
                }
            };
        }

        @Override
        @NotNull
        public List<class_2561> subList(int fromIndex, int toIndex) {
            final SegmentedTextList parentList = this;
            int newStart = this.toExistingListIndex(fromIndex);
            int newEnd = this.toListIndex(toIndex);
            return new SegmentedTextList(this.text, new Segment(this.segment.part, newStart, newEnd), this.segmentIndex){

                @Override
                protected void updateSegment() {
                    super.updateSegment();
                    parentList.updateSegment();
                }

                @Override
                protected void updateSegment(int lengthDelta) {
                    super.updateSegment(lengthDelta);
                    parentList.updateSegment(lengthDelta);
                }
            };
        }
    }

    @ApiStatus.Internal
    public static final class BuilderList
    implements List<class_2561> {
        private final Builder builder;

        private BuilderList(Builder builder) {
            this.builder = builder;
        }

        public Builder asBuilder() {
            return this.builder;
        }

        @Override
        public int size() {
            return this.builder.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.builder.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.builder.list.contains(o);
        }

        @Override
        @NotNull
        public Iterator<class_2561> iterator() {
            return this.builder.list.iterator();
        }

        @Override
        public void forEach(Consumer<? super class_2561> action) {
            this.builder.list.forEach(action);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.builder.list.toArray();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            return this.builder.list.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            return this.builder.list.toArray(generator);
        }

        @Override
        public boolean add(class_2561 text) {
            return this.builder.list.add(text);
        }

        @Override
        public boolean remove(Object o) {
            return this.builder.list.remove(o);
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return this.builder.list.containsAll(c);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends class_2561> c) {
            return this.builder.list.addAll(c);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends class_2561> c) {
            return this.builder.list.addAll(index, c);
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            return this.builder.list.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super class_2561> filter) {
            return this.builder.list.removeIf(filter);
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            return this.builder.list.retainAll(c);
        }

        @Override
        public void replaceAll(UnaryOperator<class_2561> operator) {
            this.builder.list.replaceAll(operator);
        }

        @Override
        public void sort(Comparator<? super class_2561> c) {
            this.builder.list.sort(c);
        }

        @Override
        public void clear() {
            this.builder.list.clear();
        }

        @Override
        public class_2561 get(int index) {
            return this.builder.list.get(index);
        }

        @Override
        public class_2561 set(int index, class_2561 element) {
            return this.builder.list.set(index, element);
        }

        @Override
        public void add(int index, class_2561 element) {
            this.builder.list.add(index, element);
        }

        @Override
        public class_2561 remove(int index) {
            return this.builder.list.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.builder.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.builder.list.lastIndexOf(o);
        }

        @Override
        @NotNull
        public ListIterator<class_2561> listIterator() {
            return this.builder.list.listIterator();
        }

        @Override
        @NotNull
        public ListIterator<class_2561> listIterator(int index) {
            return this.builder.list.listIterator(index);
        }

        @Override
        @NotNull
        public List<class_2561> subList(int fromIndex, int toIndex) {
            return this.builder.list.subList(fromIndex, toIndex);
        }

        @Override
        public Spliterator<class_2561> spliterator() {
            return this.builder.list.spliterator();
        }

        @Override
        public Stream<class_2561> stream() {
            return this.builder.list.stream();
        }

        @Override
        public Stream<class_2561> parallelStream() {
            return this.builder.list.parallelStream();
        }
    }
}

