/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.api.v1.item.TooltipSyncData;
import dev.kir.packedinventory.api.v1.item.TooltipSyncDataProvider;
import dev.kir.packedinventory.api.v1.item.TooltipSyncDataProviderRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

final class TooltipSyncDataProviderRegistryImpl
implements TooltipSyncDataProviderRegistry {
    public static final TooltipSyncDataProviderRegistryImpl INSTANCE = new TooltipSyncDataProviderRegistryImpl();
    private final Map<class_1792, TooltipSyncDataProviderRegistry.Entry<?>> itemBasedProviders = new HashMap();
    private final Set<TooltipSyncDataProviderRegistry.Entry<?>> genericProvidersSet = new HashSet();
    private final Deque<TooltipSyncDataProviderRegistry.Entry<?>> genericProviders = new ArrayDeque();

    TooltipSyncDataProviderRegistryImpl() {
    }

    @Override
    public Optional<TooltipSyncData> getTooltipSyncData(class_1799 stack, class_1657 player) {
        TooltipSyncDataProviderRegistry.Entry<?> providerEntry = this.findProvider(stack, player);
        if (providerEntry == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(providerEntry.getProvider().getTooltipSyncData(stack, player));
    }

    @Nullable
    private TooltipSyncDataProviderRegistry.Entry<?> findProvider(class_1799 stack, class_1657 player) {
        TooltipSyncDataProviderRegistry.Entry<?> entry = this.itemBasedProviders.get(stack.method_7909());
        if (entry != null && entry.getPredicate().test(stack, player)) {
            return entry;
        }
        for (TooltipSyncDataProviderRegistry.Entry<?> genericEntry : this.genericProviders) {
            if (!genericEntry.getPredicate().test(stack, player)) continue;
            return genericEntry;
        }
        return null;
    }

    @Override
    public <T extends TooltipSyncData> TooltipSyncDataProviderRegistry.Entry<T> register(TooltipSyncDataProviderRegistry.Entry<T> entry) {
        if (entry.getPredicate() instanceof TooltipSyncDataProvider.ItemPredicate) {
            for (class_1792 item : ((TooltipSyncDataProvider.ItemPredicate)entry.getPredicate()).getItems()) {
                this.itemBasedProviders.put(item, entry);
            }
        } else if (this.genericProvidersSet.add(entry)) {
            this.genericProviders.push(entry);
        }
        return entry;
    }

    @Override
    public <T extends TooltipSyncData> TooltipSyncDataProviderRegistry.Entry<T> register(TooltipSyncDataProvider<T> provider, Collection<class_1792> items) {
        return this.register(provider, TooltipSyncDataProvider.ItemPredicate.of(items, TooltipSyncDataProvider.Predicate.TRUE));
    }

    @Override
    public <T extends TooltipSyncData> boolean unregister(TooltipSyncDataProvider<T> provider) {
        return this.itemBasedProviders.entrySet().removeIf(x -> ((TooltipSyncDataProviderRegistry.Entry)x.getValue()).getProvider() == provider) | this.genericProvidersSet.removeIf(x -> x.getProvider() == provider) && this.genericProviders.removeIf(x -> x.getProvider() == provider);
    }
}

