/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.api.v1.item.ItemStackComponentStorage;
import dev.kir.packedinventory.api.v1.item.SyncedTooltipProvider;
import dev.kir.packedinventory.api.v1.item.TooltipProviderContext;
import dev.kir.packedinventory.api.v1.item.TooltipSyncData;
import dev.kir.packedinventory.api.v1.item.TooltipText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public interface TooltipProvider {
    public static final TooltipProvider VANILLA = new TooltipProvider(){};

    default public Optional<class_5632> getTooltipData(class_1799 stack, TooltipProviderContext context) {
        return context.getTooltipData();
    }

    default public List<class_2561> getTooltipText(class_1799 stack, TooltipProviderContext context) {
        return context.getTooltipText().toList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TooltipPredicate tooltipPredicate;
        @Nullable
        private TooltipOptionalDataSupplier tooltipDataSupplier;
        @Nullable
        private TooltipTextSupplier tooltipTextSupplier;
        private final List<TooltipTextModifier> tooltipTextModifiers = new ArrayList<TooltipTextModifier>();

        private Builder() {
        }

        public Builder optionalTooltipData(TooltipOptionalDataSupplier tooltipDataSupplier) {
            this.tooltipDataSupplier = tooltipDataSupplier;
            return this;
        }

        public Builder tooltipData(TooltipDataSupplier tooltipDataSupplier) {
            this.tooltipDataSupplier = (s, c) -> {
                class_5632 tooltipData = tooltipDataSupplier.getTooltipData(s, c);
                return tooltipData == null ? c.getTooltipData() : Optional.of(tooltipData);
            };
            return this;
        }

        public Builder tooltipText(TooltipTextSupplier tooltipTextSupplier) {
            this.tooltipTextSupplier = tooltipTextSupplier;
            return this;
        }

        public Builder modifyTooltipText(TooltipTextModifier tooltipTextModifier) {
            this.tooltipTextModifiers.add(tooltipTextModifier);
            return this;
        }

        public Builder when(TooltipPredicate tooltipPredicate) {
            this.tooltipPredicate = tooltipPredicate;
            return this;
        }

        public <TTooltipSyncData extends TooltipSyncData> SyncedTooltipProvider.Builder<TTooltipSyncData> useSyncData(Supplier<TTooltipSyncData> syncDataSupplier) {
            return this.useSyncData(syncDataSupplier, ItemStackComponentStorage.weakMap());
        }

        public <TTooltipSyncData extends TooltipSyncData> SyncedTooltipProvider.Builder<TTooltipSyncData> useSyncData(Supplier<TTooltipSyncData> syncDataSupplier, ItemStackComponentStorage<TTooltipSyncData> componentStorage) {
            SyncedTooltipProvider.Builder<TTooltipSyncData> builder = SyncedTooltipProvider.builder(syncDataSupplier, componentStorage);
            if (this.tooltipDataSupplier != null) {
                builder.optionalTooltipData(this.tooltipDataSupplier);
            }
            if (this.tooltipTextSupplier != null) {
                builder.tooltipText(this.tooltipTextSupplier);
            }
            if (this.tooltipPredicate != null) {
                builder.when(this.tooltipPredicate);
            }
            for (TooltipTextModifier tooltipTextModifier : this.tooltipTextModifiers) {
                builder.modifyTooltipText(tooltipTextModifier);
            }
            return builder;
        }

        public TooltipProvider build() {
            if (this.tooltipDataSupplier == null && this.tooltipTextSupplier == null && this.tooltipTextModifiers.size() == 0) {
                return VANILLA;
            }
            final TooltipPredicate tooltipPredicate = this.tooltipPredicate == null ? (s, c) -> true : this.tooltipPredicate;
            final TooltipOptionalDataSupplier tooltipDataSupplier = this.tooltipDataSupplier == null ? (s, c) -> c.getTooltipData() : this.tooltipDataSupplier;
            final TooltipTextSupplier tooltipTextSupplier = this.tooltipTextSupplier == null ? (s, c) -> c.getTooltipText().toList() : this.tooltipTextSupplier;
            final ArrayList<TooltipTextModifier> tooltipTextModifiers = new ArrayList<TooltipTextModifier>(this.tooltipTextModifiers);
            return new TooltipProvider(){

                @Override
                public Optional<class_5632> getTooltipData(class_1799 stack, TooltipProviderContext context) {
                    return !tooltipPredicate.shouldShowTooltip(stack, context) ? context.getTooltipData() : tooltipDataSupplier.getTooltipData(stack, context);
                }

                @Override
                public List<class_2561> getTooltipText(class_1799 stack, TooltipProviderContext context) {
                    if (!tooltipPredicate.shouldShowTooltip(stack, context)) {
                        return context.getTooltipText().toList();
                    }
                    for (TooltipTextModifier tooltipTextModifier : tooltipTextModifiers) {
                        tooltipTextModifier.modifyTooltipText(context.getTooltipText(), stack, context);
                    }
                    return tooltipTextSupplier.getTooltipText(stack, context);
                }
            };
        }

        @FunctionalInterface
        public static interface TooltipOptionalDataSupplier {
            public Optional<class_5632> getTooltipData(class_1799 var1, TooltipProviderContext var2);
        }

        @FunctionalInterface
        public static interface TooltipDataSupplier {
            @Nullable
            public class_5632 getTooltipData(class_1799 var1, TooltipProviderContext var2);
        }

        @FunctionalInterface
        public static interface TooltipTextSupplier {
            public List<class_2561> getTooltipText(class_1799 var1, TooltipProviderContext var2);
        }

        @FunctionalInterface
        public static interface TooltipPredicate {
            public boolean shouldShowTooltip(class_1799 var1, TooltipProviderContext var2);
        }

        @FunctionalInterface
        public static interface TooltipTextModifier {
            public void modifyTooltipText(TooltipText var1, class_1799 var2, TooltipProviderContext var3);
        }
    }

    @FunctionalInterface
    public static interface ItemPredicate
    extends Predicate {
        public Set<class_1792> getItems();

        @Override
        default public boolean test(class_1799 stack, TooltipProviderContext context) {
            return this.getItems().contains(stack.method_7909());
        }

        @Override
        default public ItemPredicate and(Predicate other) {
            return (ItemPredicate)Predicate.super.and(other);
        }

        @Override
        default public ItemPredicate or(Predicate other) {
            return (ItemPredicate)Predicate.super.or(other);
        }

        public static ItemPredicate of(Collection<class_1792> items) {
            return ItemPredicate.of(items, null);
        }

        public static ItemPredicate of(Collection<class_1792> items, final @Nullable Predicate innerPredicate) {
            final Set<class_1792> itemSet = Set.copyOf(items);
            if (innerPredicate == null) {
                return () -> itemSet;
            }
            return new ItemPredicate(){

                @Override
                public Set<class_1792> getItems() {
                    return itemSet;
                }

                @Override
                public boolean test(class_1799 stack, TooltipProviderContext context) {
                    return innerPredicate.test(stack, context);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Predicate {
        public static final Predicate TRUE = (s, c) -> true;
        public static final Predicate FALSE = (s, c) -> false;

        public boolean test(class_1799 var1, TooltipProviderContext var2);

        default public Predicate and(final Predicate other) {
            Set<class_1792> items = null;
            if (this instanceof ItemPredicate) {
                items = ((ItemPredicate)this).getItems();
            }
            if (other instanceof ItemPredicate) {
                if (items == null) {
                    items = ((ItemPredicate)other).getItems();
                } else {
                    items = new HashSet<class_1792>(items);
                    items.retainAll(((ItemPredicate)other).getItems());
                    items = Set.copyOf(items);
                }
            }
            final Predicate it = this;
            if (items != null) {
                final Set<class_1792> finalItems = items;
                return new ItemPredicate(){

                    @Override
                    public Set<class_1792> getItems() {
                        return finalItems;
                    }

                    @Override
                    public boolean test(class_1799 stack, TooltipProviderContext context) {
                        return it.test(stack, context) && other.test(stack, context);
                    }
                };
            }
            return (s, c) -> it.test(s, c) && other.test(s, c);
        }

        default public Predicate or(final Predicate other) {
            Set<class_1792> items = null;
            if (this instanceof ItemPredicate) {
                items = ((ItemPredicate)this).getItems();
            }
            if (other instanceof ItemPredicate) {
                if (items == null) {
                    items = ((ItemPredicate)other).getItems();
                } else {
                    items = new HashSet<class_1792>(items);
                    items.addAll(((ItemPredicate)other).getItems());
                    items = Set.copyOf(items);
                }
            }
            final Predicate it = this;
            if (items != null) {
                final Set<class_1792> finalItems = items;
                return new ItemPredicate(){

                    @Override
                    public Set<class_1792> getItems() {
                        return finalItems;
                    }

                    @Override
                    public boolean test(class_1799 stack, TooltipProviderContext context) {
                        return it.test(stack, context) || other.test(stack, context);
                    }
                };
            }
            return (s, c) -> it.test(s, c) || other.test(s, c);
        }
    }
}

