/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.api.v1.item.ItemStackComponentStorage;
import dev.kir.packedinventory.api.v1.item.TooltipProvider;
import dev.kir.packedinventory.api.v1.item.TooltipProviderContext;
import dev.kir.packedinventory.api.v1.item.TooltipSyncData;
import dev.kir.packedinventory.api.v1.item.TooltipText;
import dev.kir.packedinventory.api.v1.networking.TooltipSyncRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public interface SyncedTooltipProvider<TTooltipSyncData extends TooltipSyncData>
extends TooltipProvider {
    public static final long DEFAULT_SYNC_INTERVAL = 5000L;

    @Override
    default public Optional<class_5632> getTooltipData(class_1799 stack, TooltipProviderContext context) {
        if (this.shouldSync(stack)) {
            this.sync(stack);
        }
        Optional<TTooltipSyncData> syncData = this.getTooltipSyncData(stack);
        return this.getTooltipData(stack, context, syncData.orElse(null));
    }

    default public Optional<class_5632> getTooltipData(class_1799 stack, TooltipProviderContext context, @Nullable TTooltipSyncData syncData) {
        return TooltipProvider.super.getTooltipData(stack, context);
    }

    @Override
    default public List<class_2561> getTooltipText(class_1799 stack, TooltipProviderContext context) {
        if (this.shouldSync(stack)) {
            this.sync(stack);
        }
        Optional<TTooltipSyncData> syncData = this.getTooltipSyncData(stack);
        return this.getTooltipText(stack, context, syncData.orElse(null));
    }

    default public List<class_2561> getTooltipText(class_1799 stack, TooltipProviderContext context, @Nullable TTooltipSyncData syncData) {
        return TooltipProvider.super.getTooltipText(stack, context);
    }

    public long getLastSyncTime(class_1799 var1);

    default public long getSyncInterval(class_1799 stack) {
        return 5000L;
    }

    default public boolean shouldSync(class_1799 stack) {
        return System.currentTimeMillis() - this.getLastSyncTime(stack) >= this.getSyncInterval(stack);
    }

    @Environment(value=EnvType.CLIENT)
    default public void sync(class_1799 stack) {
        TooltipSyncRequest.sendToServer(stack);
    }

    public Optional<TTooltipSyncData> getTooltipSyncData(class_1799 var1);

    public void readTooltipSyncDataNbt(class_1799 var1, TooltipProviderContext var2, class_2487 var3);

    public static <TTooltipSyncData extends TooltipSyncData> Builder<TTooltipSyncData> builder(Supplier<TTooltipSyncData> syncDataSupplier) {
        return SyncedTooltipProvider.builder(syncDataSupplier, ItemStackComponentStorage.weakMap());
    }

    public static <TTooltipSyncData extends TooltipSyncData> Builder<TTooltipSyncData> builder(Supplier<TTooltipSyncData> syncDataSupplier, ItemStackComponentStorage<TTooltipSyncData> componentStorage) {
        return new Builder<TTooltipSyncData>(syncDataSupplier, componentStorage);
    }

    public static final class Builder<TTooltipSyncData extends TooltipSyncData> {
        private final Supplier<TTooltipSyncData> syncDataSupplier;
        private final ItemStackComponentStorage<TTooltipSyncData> componentStorage;
        @Nullable
        private TooltipSyncIntervalProvider syncInterval;
        @Nullable
        private TooltipPredicate<TTooltipSyncData> tooltipPredicate;
        @Nullable
        private TooltipOptionalDataSupplier<TTooltipSyncData> tooltipDataSupplier;
        @Nullable
        private TooltipTextSupplier<TTooltipSyncData> tooltipTextSupplier;
        private final List<TooltipTextModifier<TTooltipSyncData>> tooltipTextModifiers = new ArrayList<TooltipTextModifier<TTooltipSyncData>>();

        private Builder(Supplier<TTooltipSyncData> syncDataSupplier, ItemStackComponentStorage<TTooltipSyncData> componentStorage) {
            this.syncDataSupplier = syncDataSupplier;
            this.componentStorage = componentStorage;
        }

        public Builder<TTooltipSyncData> optionalTooltipData(TooltipOptionalDataSupplier<TTooltipSyncData> tooltipDataSupplier) {
            this.tooltipDataSupplier = tooltipDataSupplier;
            return this;
        }

        public Builder<TTooltipSyncData> tooltipData(TooltipDataSupplier<TTooltipSyncData> tooltipDataSupplier) {
            this.tooltipDataSupplier = (s, c, d) -> {
                class_5632 tooltipData = d == null ? null : tooltipDataSupplier.getTooltipData(s, c, d);
                return tooltipData == null ? c.getTooltipData() : Optional.of(tooltipData);
            };
            return this;
        }

        public Builder<TTooltipSyncData> optionalTooltipData(TooltipProvider.Builder.TooltipOptionalDataSupplier tooltipDataSupplier) {
            this.tooltipDataSupplier = (s, c, d) -> tooltipDataSupplier.getTooltipData(s, c);
            return this;
        }

        public Builder<TTooltipSyncData> tooltipData(TooltipProvider.Builder.TooltipDataSupplier tooltipDataSupplier) {
            this.tooltipDataSupplier = (s, c, d) -> {
                class_5632 tooltipData = tooltipDataSupplier.getTooltipData(s, c);
                return tooltipData == null ? c.getTooltipData() : Optional.of(tooltipData);
            };
            return this;
        }

        public Builder<TTooltipSyncData> tooltipText(TooltipTextSupplier<TTooltipSyncData> tooltipTextSupplier) {
            this.tooltipTextSupplier = tooltipTextSupplier;
            return this;
        }

        public Builder<TTooltipSyncData> tooltipText(TooltipProvider.Builder.TooltipTextSupplier tooltipTextSupplier) {
            this.tooltipTextSupplier = (s, c, d) -> tooltipTextSupplier.getTooltipText(s, c);
            return this;
        }

        public Builder<TTooltipSyncData> modifyTooltipText(TooltipTextModifier<TTooltipSyncData> tooltipTextModifier) {
            this.tooltipTextModifiers.add(tooltipTextModifier);
            return this;
        }

        public Builder<TTooltipSyncData> modifyTooltipText(TooltipProvider.Builder.TooltipTextModifier tooltipTextModifier) {
            this.tooltipTextModifiers.add((t, s, c, d) -> tooltipTextModifier.modifyTooltipText(t, s, c));
            return this;
        }

        public Builder<TTooltipSyncData> when(TooltipPredicate<TTooltipSyncData> tooltipPredicate) {
            this.tooltipPredicate = tooltipPredicate;
            return this;
        }

        public Builder<TTooltipSyncData> when(TooltipProvider.Builder.TooltipPredicate tooltipPredicate) {
            this.tooltipPredicate = (s, c, d) -> tooltipPredicate.shouldShowTooltip(s, c);
            return this;
        }

        public Builder<TTooltipSyncData> syncInterval(long syncInterval) {
            this.syncInterval = s -> syncInterval;
            return this;
        }

        public Builder<TTooltipSyncData> syncInterval(TooltipSyncIntervalProvider syncInterval) {
            this.syncInterval = syncInterval;
            return this;
        }

        public SyncedTooltipProvider<TTooltipSyncData> build() {
            final Supplier<TTooltipSyncData> syncDataSupplier = this.syncDataSupplier;
            final ItemStackComponentStorage<TTooltipSyncData> componentStorage = this.componentStorage;
            final TooltipSyncIntervalProvider syncIntervalProvider = this.syncInterval == null ? s -> 5000L : this.syncInterval;
            final TooltipPredicate<TooltipSyncData> tooltipPredicate = this.tooltipPredicate == null ? (s, c, d) -> true : this.tooltipPredicate;
            final TooltipOptionalDataSupplier<TooltipSyncData> tooltipDataSupplier = this.tooltipDataSupplier == null ? (s, c, d) -> c.getTooltipData() : this.tooltipDataSupplier;
            final TooltipTextSupplier<TooltipSyncData> tooltipTextSupplier = this.tooltipTextSupplier == null ? (s, c, d) -> c.getTooltipText().toList() : this.tooltipTextSupplier;
            final ArrayList<TooltipTextModifier<TTooltipSyncData>> tooltipTextModifiers = new ArrayList<TooltipTextModifier<TTooltipSyncData>>(this.tooltipTextModifiers);
            return new SyncedTooltipProvider<TTooltipSyncData>(){

                @Override
                public Optional<class_5632> getTooltipData(class_1799 stack, TooltipProviderContext context, @Nullable TTooltipSyncData syncData) {
                    return !tooltipPredicate.shouldShowTooltip(stack, context, syncData) ? context.getTooltipData() : tooltipDataSupplier.getTooltipData(stack, context, syncData);
                }

                @Override
                public List<class_2561> getTooltipText(class_1799 stack, TooltipProviderContext context, @Nullable TTooltipSyncData syncData) {
                    if (!tooltipPredicate.shouldShowTooltip(stack, context, syncData)) {
                        return context.getTooltipText().toList();
                    }
                    for (TooltipTextModifier tooltipTextModifier : tooltipTextModifiers) {
                        tooltipTextModifier.modifyTooltipText(context.getTooltipText(), stack, context, syncData);
                    }
                    return tooltipTextSupplier.getTooltipText(stack, context, syncData);
                }

                @Override
                public long getSyncInterval(class_1799 stack) {
                    return syncIntervalProvider.getSyncInterval(stack);
                }

                @Override
                public long getLastSyncTime(class_1799 stack) {
                    return componentStorage.getLastComponentUpdateTime(stack);
                }

                @Override
                public Optional<TTooltipSyncData> getTooltipSyncData(class_1799 stack) {
                    return componentStorage.getComponent(stack);
                }

                @Override
                public void sync(class_1799 stack) {
                    stack = componentStorage.getReferenceStack(stack);
                    SyncedTooltipProvider.super.sync(stack);
                    componentStorage.attachComponent(stack, componentStorage.getComponent(stack).orElse(null));
                }

                @Override
                public void readTooltipSyncDataNbt(class_1799 stack, TooltipProviderContext context, class_2487 nbt) {
                    TooltipSyncData syncData = (TooltipSyncData)syncDataSupplier.get();
                    syncData.readNbt(nbt);
                    componentStorage.attachComponent(stack, syncData);
                }
            };
        }

        @FunctionalInterface
        public static interface TooltipOptionalDataSupplier<TTooltipSyncData extends TooltipSyncData> {
            public Optional<class_5632> getTooltipData(class_1799 var1, TooltipProviderContext var2, @Nullable TTooltipSyncData var3);
        }

        @FunctionalInterface
        public static interface TooltipDataSupplier<TTooltipSyncData extends TooltipSyncData> {
            @Nullable
            public class_5632 getTooltipData(class_1799 var1, TooltipProviderContext var2, TTooltipSyncData var3);
        }

        @FunctionalInterface
        public static interface TooltipTextSupplier<TTooltipSyncData extends TooltipSyncData> {
            public List<class_2561> getTooltipText(class_1799 var1, TooltipProviderContext var2, @Nullable TTooltipSyncData var3);
        }

        @FunctionalInterface
        public static interface TooltipTextModifier<TTooltipSyncData extends TooltipSyncData> {
            public void modifyTooltipText(TooltipText var1, class_1799 var2, TooltipProviderContext var3, @Nullable TTooltipSyncData var4);
        }

        @FunctionalInterface
        public static interface TooltipPredicate<TTooltipSyncData extends TooltipSyncData> {
            public boolean shouldShowTooltip(class_1799 var1, TooltipProviderContext var2, @Nullable TTooltipSyncData var3);
        }

        @FunctionalInterface
        public static interface TooltipSyncIntervalProvider {
            public long getSyncInterval(class_1799 var1);
        }
    }
}

