/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import org.jetbrains.annotations.Nullable;

public interface ItemStackComponentStorage<TComponent> {
    public class_1799 getReferenceStack(class_1799 var1);

    public long getLastComponentUpdateTime(class_1799 var1);

    public Optional<TComponent> getComponent(class_1799 var1);

    public void attachComponent(class_1799 var1, TComponent var2);

    default public void detachComponent(class_1799 stack) {
        this.attachComponent(stack, null);
    }

    public static <TComponent> ItemStackComponentStorage<TComponent> singleton() {
        return ItemStackComponentStorage.singleton((class_1799)null);
    }

    public static <TComponent> ItemStackComponentStorage<TComponent> singleton(class_1792 referenceItem) {
        return ItemStackComponentStorage.singleton(new class_1799((class_1935)referenceItem));
    }

    public static <TComponent> ItemStackComponentStorage<TComponent> singleton(final @Nullable class_1799 stack) {
        return new ItemStackComponentStorage<TComponent>(){
            @Nullable
            private final class_1799 referenceStack;
            @Nullable
            private TComponent component;
            private long lastComponentUpdateTime;
            {
                this.referenceStack = stack;
            }

            @Override
            public class_1799 getReferenceStack(class_1799 stack2) {
                return this.referenceStack == null ? stack2 : this.referenceStack;
            }

            @Override
            public long getLastComponentUpdateTime(class_1799 stack2) {
                return this.lastComponentUpdateTime;
            }

            @Override
            public Optional<TComponent> getComponent(class_1799 stack2) {
                return Optional.ofNullable(this.component);
            }

            @Override
            public void attachComponent(class_1799 stack2, TComponent component) {
                this.component = component;
                this.lastComponentUpdateTime = System.currentTimeMillis();
            }
        };
    }

    public static <TComponent> ItemStackComponentStorage<TComponent> weakMap() {
        return new ItemStackComponentStorage<TComponent>(){
            private final Map<class_1799, TComponent> components = new WeakHashMap();
            private final Map<class_1799, Long> updates = new WeakHashMap<class_1799, Long>();

            @Override
            public class_1799 getReferenceStack(class_1799 stack) {
                if (this.components.containsKey(stack)) {
                    return stack;
                }
                for (Map.Entry entry : this.components.entrySet()) {
                    class_1799 key = entry.getKey();
                    if (!class_1799.method_7973((class_1799)key, (class_1799)stack)) continue;
                    return key;
                }
                return stack;
            }

            @Override
            public long getLastComponentUpdateTime(class_1799 stack) {
                return this.updates.getOrDefault(this.getReferenceStack(stack), 0L);
            }

            @Override
            public Optional<TComponent> getComponent(class_1799 stack) {
                return Optional.ofNullable(this.components.get(this.getReferenceStack(stack)));
            }

            @Override
            public void attachComponent(class_1799 stack, TComponent component) {
                if (component == null) {
                    this.detachComponent(stack);
                    return;
                }
                stack = this.getReferenceStack(stack);
                this.components.put(stack, component);
                this.updates.put(stack, System.currentTimeMillis());
            }

            @Override
            public void detachComponent(class_1799 stack) {
                stack = this.getReferenceStack(stack);
                this.components.remove(stack);
                this.updates.put(stack, System.currentTimeMillis());
            }
        };
    }
}

