/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.item;

import dev.kir.packedinventory.inventory.ListInventory;
import dev.kir.packedinventory.util.inventory.InventoryUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public class GenericContainerTooltipData
implements class_5632 {
    private final class_1263 inventory;
    private final int rows;
    private final int columns;
    @Nullable
    private final class_1767 color;

    protected GenericContainerTooltipData(class_1263 inventory) {
        this(inventory, null);
    }

    protected GenericContainerTooltipData(class_1263 inventory, @Nullable class_1767 color) {
        this(inventory, -1, -1, color);
    }

    protected GenericContainerTooltipData(class_1263 inventory, int rows, int columns) {
        this(inventory, rows, columns, null);
    }

    protected GenericContainerTooltipData(class_1263 inventory, int rows, int columns, @Nullable class_1767 color) {
        this.inventory = inventory;
        this.columns = columns < 0 ? (rows < 0 ? GenericContainerTooltipData.computeColumns(inventory) : Math.max(class_3532.method_38788((int)inventory.method_5439(), (int)rows), 1)) : columns;
        this.rows = rows < 0 ? Math.max(class_3532.method_38788((int)inventory.method_5439(), (int)this.columns), 1) : rows;
        this.color = color;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    @Nullable
    public class_1767 getColor() {
        return this.color;
    }

    private static int computeColumns(class_1263 inventory) {
        int hotbarSize;
        int size = inventory.method_5439();
        if (size < (hotbarSize = class_1661.method_7368())) {
            return Math.max(size, 1);
        }
        if (size % hotbarSize == 0) {
            return hotbarSize;
        }
        int columns = Math.max((int)Math.sqrt(size), 1);
        int rows = Math.max(class_3532.method_38788((int)inventory.method_5439(), (int)columns), 1);
        return Math.max(columns, rows);
    }

    public static GenericContainerTooltipData of(class_1263 inventory) {
        return new GenericContainerTooltipData(inventory);
    }

    public static GenericContainerTooltipData of(class_1263 inventory, @Nullable class_1767 color) {
        return new GenericContainerTooltipData(inventory, color);
    }

    public static GenericContainerTooltipData of(class_1263 inventory, int rows, int columns) {
        return new GenericContainerTooltipData(inventory, rows, columns);
    }

    public static GenericContainerTooltipData of(class_1263 inventory, int rows, int columns, @Nullable class_1767 color) {
        return new GenericContainerTooltipData(inventory, rows, columns, color);
    }

    public static GenericContainerTooltipData of(class_2371<class_1799> inventory) {
        return GenericContainerTooltipData.of(ListInventory.wrap(inventory));
    }

    public static GenericContainerTooltipData of(class_2371<class_1799> inventory, @Nullable class_1767 color) {
        return GenericContainerTooltipData.of(ListInventory.wrap(inventory), color);
    }

    public static GenericContainerTooltipData of(class_2371<class_1799> inventory, int rows, int columns) {
        return GenericContainerTooltipData.of(ListInventory.wrap(inventory), rows, columns);
    }

    public static GenericContainerTooltipData of(class_2371<class_1799> inventory, int rows, int columns, @Nullable class_1767 color) {
        return GenericContainerTooltipData.of(ListInventory.wrap(inventory), rows, columns, color);
    }

    public static GenericContainerTooltipData ofZipped(class_1263 inventory) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory));
    }

    public static GenericContainerTooltipData ofZipped(class_1263 inventory, @Nullable class_1767 color) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory), color);
    }

    public static GenericContainerTooltipData ofZipped(class_1263 inventory, int rows, int columns) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory), rows, columns);
    }

    public static GenericContainerTooltipData ofZipped(class_1263 inventory, int rows, int columns, @Nullable class_1767 color) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory), rows, columns, color);
    }

    public static GenericContainerTooltipData ofZipped(class_2371<class_1799> inventory) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory));
    }

    public static GenericContainerTooltipData ofZipped(class_2371<class_1799> inventory, @Nullable class_1767 color) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory), color);
    }

    public static GenericContainerTooltipData ofZipped(class_2371<class_1799> inventory, int rows, int columns) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory), rows, columns);
    }

    public static GenericContainerTooltipData ofZipped(class_2371<class_1799> inventory, int rows, int columns, @Nullable class_1767 color) {
        return GenericContainerTooltipData.of(InventoryUtil.zip(inventory), rows, columns, color);
    }
}

