/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.packedinventory.api.v1.inventory;

import dev.kir.packedinventory.api.v1.FailureReason;
import dev.kir.packedinventory.api.v1.inventory.InventoryValidationFailureHandler;
import dev.kir.packedinventory.api.v1.inventory.InventoryValidationFailureHandlerRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

final class InventoryValidationFailureHandlerRegistryImpl
implements InventoryValidationFailureHandlerRegistry {
    public static final InventoryValidationFailureHandlerRegistryImpl INSTANCE = new InventoryValidationFailureHandlerRegistryImpl();
    private final Map<class_1792, InventoryValidationFailureHandlerRegistry.Entry> itemBasedHandlers = new HashMap<class_1792, InventoryValidationFailureHandlerRegistry.Entry>();
    private final Set<InventoryValidationFailureHandlerRegistry.Entry> genericHandlersSet = new HashSet<InventoryValidationFailureHandlerRegistry.Entry>();
    private final Deque<InventoryValidationFailureHandlerRegistry.Entry> genericHandlers = new ArrayDeque<InventoryValidationFailureHandlerRegistry.Entry>();
    @Nullable
    private InventoryValidationFailureHandlerRegistry.Entry defaultHandler = null;

    InventoryValidationFailureHandlerRegistryImpl() {
    }

    @Override
    public boolean handle(FailureReason failureReason, class_1263 inventory, int slot, class_1657 player) {
        InventoryValidationFailureHandlerRegistry.Entry handlerEntry = this.findHandler(failureReason, inventory, slot, player);
        if (handlerEntry == null) {
            return false;
        }
        handlerEntry.getHandler().handle(failureReason, inventory, slot, player);
        return true;
    }

    @Nullable
    private InventoryValidationFailureHandlerRegistry.Entry findHandler(FailureReason failureReason, class_1263 inventory, int slot, class_1657 player) {
        InventoryValidationFailureHandlerRegistry.Entry entry = this.itemBasedHandlers.get(inventory.method_5438(slot).method_7909());
        if (entry != null && entry.getPredicate().test(failureReason, inventory, slot, player)) {
            return entry;
        }
        for (InventoryValidationFailureHandlerRegistry.Entry genericEntry : this.genericHandlers) {
            if (!genericEntry.getPredicate().test(failureReason, inventory, slot, player)) continue;
            return genericEntry;
        }
        return this.defaultHandler;
    }

    @Override
    public InventoryValidationFailureHandlerRegistry.Entry register(InventoryValidationFailureHandlerRegistry.Entry entry) {
        if (entry.getPredicate() instanceof InventoryValidationFailureHandler.ItemPredicate) {
            for (class_1792 item : ((InventoryValidationFailureHandler.ItemPredicate)entry.getPredicate()).getItems()) {
                this.itemBasedHandlers.put(item, entry);
            }
        } else if (this.genericHandlersSet.add(entry)) {
            this.genericHandlers.push(entry);
        }
        return entry;
    }

    @Override
    public InventoryValidationFailureHandlerRegistry.Entry register(InventoryValidationFailureHandler handler, Collection<class_1792> items) {
        return this.register(handler, InventoryValidationFailureHandler.ItemPredicate.of(items, InventoryValidationFailureHandler.Predicate.TRUE));
    }

    @Override
    public InventoryValidationFailureHandlerRegistry.Entry registerDefault(final InventoryValidationFailureHandler handler) {
        this.defaultHandler = new InventoryValidationFailureHandlerRegistry.Entry(){

            @Override
            public InventoryValidationFailureHandler getHandler() {
                return handler;
            }

            @Override
            public InventoryValidationFailureHandler.Predicate getPredicate() {
                return InventoryValidationFailureHandler.Predicate.TRUE;
            }
        };
        return this.defaultHandler;
    }

    @Override
    public boolean unregister(InventoryValidationFailureHandler handler) {
        boolean removed = this.itemBasedHandlers.entrySet().removeIf(x -> ((InventoryValidationFailureHandlerRegistry.Entry)x.getValue()).getHandler() == handler);
        removed |= this.genericHandlersSet.removeIf(x -> x.getHandler() == handler) && this.genericHandlers.removeIf(x -> x.getHandler() == handler);
        if (this.defaultHandler != null && this.defaultHandler.getHandler() == handler) {
            this.defaultHandler = null;
            removed = true;
        }
        return removed;
    }
}

