/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.filter;

import com.supermartijn642.trashcans.filter.IFilterManager;
import com.supermartijn642.trashcans.filter.ItemFilter;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;

public class FluidFilterManager
implements IFilterManager {
    @Override
    public ItemFilter createFilter(class_1799 stack) {
        return new FluidFilter(stack);
    }

    @Override
    public ItemFilter readFilter(class_2487 compound) {
        return new FluidFilter(compound);
    }

    private static class FluidFilter
    extends ItemFilter {
        FluidVariant stack;

        public FluidFilter(class_1799 stack) {
            this.stack = FluidFilter.getFluid(stack);
        }

        public FluidFilter(class_2487 compound) {
            this.stack = FluidVariant.fromNbt((class_2487)compound);
        }

        @Override
        public boolean matches(Object stack) {
            FluidVariant fluid = stack instanceof FluidVariant ? (FluidVariant)stack : (stack instanceof class_1799 ? FluidFilter.getFluid((class_1799)stack) : null);
            return fluid != null && fluid.equals(this.stack);
        }

        @Override
        public class_1799 getRepresentingItem() {
            return new class_1799((class_1935)this.stack.getFluid().method_15774());
        }

        @Override
        public class_2487 write() {
            return this.stack.toNbt();
        }

        @Override
        public boolean isValid() {
            return this.stack != null && !this.stack.isBlank();
        }

        private static FluidVariant getFluid(class_1799 stack) {
            Storage fluidHandler = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
            if (fluidHandler != null) {
                try (Transaction transaction = Transaction.openOuter();){
                    for (StorageView slot : fluidHandler.iterable((TransactionContext)transaction)) {
                        if (slot.isResourceBlank()) continue;
                        FluidVariant fluidVariant = (FluidVariant)slot.getResource();
                        return fluidVariant;
                    }
                }
            }
            return FluidVariant.blank();
        }
    }
}

