/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.core.util.TriFunction;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.screen.DummySlot;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.BlankVariantView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import team.reborn.energy.api.EnergyStorage;

public class TrashCanBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    public static final int DEFAULT_ENERGY_LIMIT = 10000;
    public static final int MAX_ENERGY_LIMIT = 10000000;
    public static final int MIN_ENERGY_LIMIT = 1;
    public final Storage<ItemVariant> ITEM_HANDLER = new Storage<ItemVariant>(){
        private static final Supplier<Iterator<? extends StorageView<ItemVariant>>> ITERATOR = List.of(new BlankVariantView((TransferVariant)ItemVariant.blank(), Integer.MAX_VALUE))::iterator;

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            return this.isItemValid(resource) ? maxAmount : 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            return 0L;
        }

        public Iterator<? extends StorageView<ItemVariant>> iterator(TransactionContext transaction) {
            return ITERATOR.get();
        }

        private boolean isItemValid(ItemVariant item) {
            for (class_1799 filter : TrashCanBlockEntity.this.itemFilter) {
                if (filter.method_7960() || !item.matches(filter)) continue;
                return TrashCanBlockEntity.this.itemFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.itemFilterWhitelist;
        }
    };
    public final Storage<FluidVariant> FLUID_HANDLER = new Storage<FluidVariant>(){
        private static final Supplier<Iterator<? extends StorageView<FluidVariant>>> ITERATOR = List.of(new BlankVariantView((TransferVariant)FluidVariant.blank(), Integer.MAX_VALUE))::iterator;

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            return this.isFluidValid(resource) ? maxAmount : 0L;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            return 0L;
        }

        public Iterator<? extends StorageView<FluidVariant>> iterator(TransactionContext transaction) {
            return ITERATOR.get();
        }

        private boolean isFluidValid(FluidVariant fluid) {
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(fluid)) continue;
                return TrashCanBlockEntity.this.liquidFilterWhitelist;
            }
            return !TrashCanBlockEntity.this.liquidFilterWhitelist;
        }
    };
    public final TriFunction<Integer, Integer, Integer, class_1735> LIQUID_ITEM_HANDLER = (slot, x, y) -> new DummySlot((int)slot, (int)x, (int)y){

        public boolean method_7680(class_1799 stack) {
            return this.isItemValid(stack);
        }

        @Override
        public class_1799 method_7677() {
            return TrashCanBlockEntity.this.liquidItem;
        }

        @Override
        public void method_7673(class_1799 stack) {
            TrashCanBlockEntity.this.liquidItem = stack.method_7972();
            TrashCanBlockEntity.this.liquidItem.method_7939(1);
            TrashCanBlockEntity.this.dataChanged();
        }

        @Override
        public void method_7668() {
        }

        @Override
        public int method_7675() {
            return 1;
        }

        @Override
        public class_1799 method_7671(int count) {
            class_1799 result = TrashCanBlockEntity.this.liquidItem.method_7971(count);
            TrashCanBlockEntity.this.dataChanged();
            return result;
        }

        public boolean isItemValid(class_1799 stack) {
            boolean filtered = !TrashCanBlockEntity.this.liquidFilterWhitelist;
            for (ItemFilter filter : TrashCanBlockEntity.this.liquidFilter) {
                if (filter == null || !filter.matches(stack)) continue;
                filtered = TrashCanBlockEntity.this.liquidFilterWhitelist;
                break;
            }
            if (!filtered) {
                return false;
            }
            Storage storage = (Storage)FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withInitial((class_1799)stack));
            if (storage == null || !storage.supportsExtraction()) {
                return false;
            }
            try (Transaction transaction = Transaction.openOuter();){
                for (StorageView slot : storage.iterable((TransactionContext)transaction)) {
                    if (slot.isResourceBlank()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
    };
    public final EnergyStorage ENERGY_STORAGE = new EnergyStorage(){

        public boolean supportsExtraction() {
            return false;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            return TrashCanBlockEntity.this.useEnergyLimit ? Math.min(maxAmount, (long)TrashCanBlockEntity.this.energyLimit) : maxAmount;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long getAmount() {
            return 0L;
        }

        public long getCapacity() {
            return Long.MAX_VALUE;
        }
    };
    public final TriFunction<Integer, Integer, Integer, class_1735> ENERGY_ITEM_HANDLER = (slot, x, y) -> new DummySlot((int)slot, (int)x, (int)y){

        public boolean method_7680(class_1799 stack) {
            return this.isItemValid(stack);
        }

        @Override
        public class_1799 method_7677() {
            return TrashCanBlockEntity.this.energyItem;
        }

        @Override
        public void method_7673(class_1799 stack) {
            TrashCanBlockEntity.this.energyItem = stack.method_7972();
            TrashCanBlockEntity.this.energyItem.method_7939(1);
            TrashCanBlockEntity.this.dataChanged();
        }

        @Override
        public void method_7668() {
        }

        @Override
        public int method_7675() {
            return 1;
        }

        @Override
        public class_1799 method_7671(int count) {
            class_1799 result = TrashCanBlockEntity.this.energyItem.method_7971(count);
            TrashCanBlockEntity.this.dataChanged();
            return result;
        }

        public boolean isItemValid(class_1799 stack) {
            EnergyStorage storage = (EnergyStorage)EnergyStorage.ITEM.find(stack, null);
            return storage != null && storage.supportsExtraction() && storage.getAmount() > 0L;
        }
    };
    public final boolean items;
    public final ArrayList<class_1799> itemFilter = new ArrayList();
    public boolean itemFilterWhitelist = false;
    public final boolean liquids;
    public final ArrayList<ItemFilter> liquidFilter = new ArrayList();
    public boolean liquidFilterWhitelist = false;
    public class_1799 liquidItem = class_1799.field_8037;
    public final boolean energy;
    public int energyLimit = 10000;
    public boolean useEnergyLimit = false;
    public class_1799 energyItem = class_1799.field_8037;

    public TrashCanBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state, boolean items, boolean liquids, boolean energy) {
        super(blockEntityType, pos, state);
        this.items = items;
        this.liquids = liquids;
        this.energy = energy;
        for (int i = 0; i < 9; ++i) {
            this.itemFilter.add(class_1799.field_8037);
            this.liquidFilter.add(null);
        }
    }

    public void update() {
        boolean changed;
        Transaction transaction;
        ContainerItemContext context;
        EnergyStorage storage;
        if (this.liquids && !this.liquidItem.method_7960() && this.liquidItem.method_7909() != class_1802.field_8550 && (storage = (Storage)(context = ContainerItemContext.withInitial((class_1799)this.liquidItem)).find(FluidStorage.ITEM)) != null && storage.supportsExtraction()) {
            transaction = Transaction.openOuter();
            try {
                changed = false;
                for (StorageView slot : storage.iterable((TransactionContext)transaction)) {
                    if (slot.isResourceBlank() || slot.getAmount() <= 0L || slot.extract((Object)((FluidVariant)slot.getResource()), slot.getAmount(), (TransactionContext)transaction) <= 0L) continue;
                    changed = true;
                }
                if (changed && (context.getItemVariant().isBlank() || context.getAmount() <= (long)context.getItemVariant().getItem().method_7882())) {
                    transaction.commit();
                    this.liquidItem = context.getItemVariant().toStack((int)context.getAmount());
                    this.dataChanged();
                }
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
        if (this.energy && !this.energyItem.method_7960() && (storage = (EnergyStorage)(context = ContainerItemContext.withInitial((class_1799)this.energyItem)).find(EnergyStorage.ITEM)) != null && storage.supportsExtraction() && storage.getAmount() > 0L) {
            transaction = Transaction.openOuter();
            try {
                boolean bl = changed = storage.supportsExtraction() && storage.extract(storage.getAmount(), (TransactionContext)transaction) > 0L;
                if (changed && (context.getItemVariant().isBlank() || context.getAmount() <= (long)context.getItemVariant().getItem().method_7882())) {
                    transaction.commit();
                    this.energyItem = context.getItemVariant().toStack((int)context.getAmount());
                    this.dataChanged();
                }
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    public boolean isRegularItemValid(class_1799 stack) {
        for (class_1799 filter : this.itemFilter) {
            if (filter.method_7960() || !class_1799.method_7984((class_1799)stack, (class_1799)filter)) continue;
            return this.itemFilterWhitelist;
        }
        return !this.itemFilterWhitelist;
    }

    protected class_2487 writeData() {
        int i;
        class_2487 tag = new class_2487();
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                tag.method_10566("itemFilter" + i, (class_2520)this.itemFilter.get(i).method_7953(new class_2487()));
            }
            tag.method_10556("itemFilterWhitelist", this.itemFilterWhitelist);
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                if (this.liquidFilter.get(i) == null) continue;
                tag.method_10566("liquidFilter" + i, (class_2520)LiquidTrashCanFilters.write(this.liquidFilter.get(i)));
            }
            tag.method_10556("liquidFilterWhitelist", this.liquidFilterWhitelist);
            if (!this.liquidItem.method_7960()) {
                tag.method_10566("liquidItem", (class_2520)this.liquidItem.method_7953(new class_2487()));
            }
        }
        if (this.energy) {
            tag.method_10556("useEnergyLimit", this.useEnergyLimit);
            tag.method_10569("energyLimit", this.energyLimit);
            if (!this.energyItem.method_7960()) {
                tag.method_10566("energyItem", (class_2520)this.energyItem.method_7953(new class_2487()));
            }
        }
        return tag;
    }

    protected void readData(class_2487 tag) {
        int i;
        if (this.items) {
            for (i = 0; i < this.itemFilter.size(); ++i) {
                this.itemFilter.set(i, tag.method_10545("itemFilter" + i) ? class_1799.method_7915((class_2487)tag.method_10562("itemFilter" + i)) : class_1799.field_8037);
            }
            boolean bl = this.itemFilterWhitelist = tag.method_10545("itemFilterWhitelist") && tag.method_10577("itemFilterWhitelist");
        }
        if (this.liquids) {
            for (i = 0; i < this.liquidFilter.size(); ++i) {
                this.liquidFilter.set(i, tag.method_10545("liquidFilter" + i) ? LiquidTrashCanFilters.read(tag.method_10562("liquidFilter" + i)) : null);
            }
            this.liquidFilterWhitelist = tag.method_10545("liquidFilterWhitelist") && tag.method_10577("liquidFilterWhitelist");
            class_1799 class_17992 = this.liquidItem = tag.method_10545("liquidItem") ? class_1799.method_7915((class_2487)tag.method_10562("liquidItem")) : class_1799.field_8037;
        }
        if (this.energy) {
            this.useEnergyLimit = tag.method_10545("useEnergyLimit") && tag.method_10577("useEnergyLimit");
            this.energyLimit = tag.method_10545("energyLimit") ? tag.method_10550("energyLimit") : 10000;
            this.energyItem = tag.method_10545("energyItem") ? class_1799.method_7915((class_2487)tag.method_10562("energyItem")) : class_1799.field_8037;
        }
    }
}

