/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.recipe.ingredient;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.nhoryzon.mc.farmersdelight.FarmersDelightMod;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public record ChanceResult(class_1799 stack, float chance) {
    public static final ChanceResult EMPTY = new ChanceResult(class_1799.field_8037, 1.0f);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public class_1799 rollOutput(Random rand, int fortuneLevel) {
        int outputAmount = this.stack.method_7947();
        double fortuneBonus = FarmersDelightMod.CONFIG.getCuttingBoardFortuneBonus() * (double)fortuneLevel;
        for (int roll = 0; roll < this.stack.method_7947(); ++roll) {
            if (!((double)rand.nextFloat() > (double)this.chance + fortuneBonus)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return class_1799.field_8037;
        }
        class_1799 out = this.stack.method_7972();
        out.method_7939(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        class_2960 identifier = class_2378.field_11142.method_10221((Object)this.stack.method_7909());
        json.addProperty("item", identifier.toString());
        int count = this.stack.method_7947();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.method_7985()) {
            json.add("nbt", new JsonParser().parse(this.stack.method_7969().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ChanceResult deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("Must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = class_3518.method_15265((JsonObject)json, (String)"item");
        int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        float chance = class_3518.method_15277((JsonObject)json, (String)"chance", (float)1.0f);
        class_1799 itemstack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(itemId)), count);
        if (class_3518.method_15278((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.method_7980(class_2512.method_32260((String)(element.isJsonObject() ? GSON.toJson(element) : class_3518.method_15287((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ChanceResult(itemstack, chance);
    }

    public void write(class_2540 buf) {
        buf.method_10793(this.stack());
        buf.writeFloat(this.chance());
    }

    public static ChanceResult read(class_2540 buf) {
        return new ChanceResult(buf.method_10819(), buf.readFloat());
    }
}

