/*
 * Decompiled with CFR 0.152.
 */
package com.nhoryzon.mc.farmersdelight.entity.block.inventory;

import com.nhoryzon.mc.farmersdelight.entity.block.inventory.ItemHandler;
import com.nhoryzon.mc.farmersdelight.exception.SlotInvalidRangeException;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class ItemStackHandler
implements ItemHandler {
    protected class_2371<class_1799> inventory;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int inventorySize) {
        this.inventory = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
    }

    public static boolean canItemStacksStack(class_1799 left, class_1799 right) {
        if (left.method_7960() || !left.method_7929(right) || left.method_7985() != right.method_7985()) {
            return false;
        }
        return !left.method_7985() || left.method_7969().equals((Object)right.method_7969());
    }

    public static class_1799 copyStackWithNewSize(class_1799 itemStack, int newSize) {
        if (newSize == 0) {
            return class_1799.field_8037;
        }
        class_1799 copy = itemStack.method_7972();
        copy.method_7939(newSize);
        return copy;
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    @Override
    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        return this.inventory.isEmpty();
    }

    public class_1799 method_5438(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.extractItemStack(slot, amount, false);
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = this.method_5438(slot);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        return this.extractItemStack(slot, stack.method_7947(), false);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.validateSlotIndex(slot);
        this.inventory.set(slot, (Object)stack);
        this.onInventorySlotChanged(slot);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    @Override
    public class_1799 insertItemStack(int slot, class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960() || !this.method_5437(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        class_1799 invItemStack = (class_1799)this.inventory.get(slot);
        int limit = this.getStackLimit(slot, invItemStack);
        if (!invItemStack.method_7960()) {
            if (!ItemStackHandler.canItemStacksStack(stack, invItemStack)) {
                return stack;
            }
            limit -= invItemStack.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (invItemStack.method_7960()) {
                this.inventory.set(slot, (Object)(reachedLimit ? ItemStackHandler.copyStackWithNewSize(stack, limit) : stack));
            } else {
                invItemStack.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            this.onInventorySlotChanged(slot);
        }
        return reachedLimit ? ItemStackHandler.copyStackWithNewSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    public class_1799 extractItemStack(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        this.validateSlotIndex(slot);
        class_1799 invItemStack = (class_1799)this.inventory.get(slot);
        if (invItemStack.method_7960()) {
            return class_1799.field_8037;
        }
        int nbrToExtract = Math.min(amount, invItemStack.method_7914());
        if (invItemStack.method_7947() <= nbrToExtract) {
            if (!simulate) {
                this.inventory.set(slot, (Object)class_1799.field_8037);
                this.onInventorySlotChanged(slot);
                return invItemStack;
            }
            return invItemStack.method_7972();
        }
        if (!simulate) {
            this.inventory.set(slot, (Object)ItemStackHandler.copyStackWithNewSize(invItemStack, invItemStack.method_7947() - nbrToExtract));
            this.onInventorySlotChanged(slot);
        }
        return ItemStackHandler.copyStackWithNewSize(invItemStack, nbrToExtract);
    }

    @Override
    public int getMaxCountForSlot(int slot) {
        return 64;
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void onInventoryLoaded() {
    }

    protected void onInventorySlotChanged(int slot) {
    }

    public void setSize(int size) {
        this.inventory = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            throw new SlotInvalidRangeException(slot, this.inventory.size());
        }
    }

    protected int getStackLimit(int slot, class_1799 stack) {
        return Math.min(this.getMaxCountForSlot(slot), stack.method_7914());
    }

    public class_2487 writeNbt(class_2487 nbtCompound) {
        class_2499 itemListTag = new class_2499();
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            ((class_1799)this.inventory.get(i)).method_7953(itemTag);
            itemListTag.add((Object)itemTag);
        }
        nbtCompound.method_10566("Items", (class_2520)itemListTag);
        nbtCompound.method_10569("Size", this.inventory.size());
        return nbtCompound;
    }

    public void readNbt(class_2487 tag) {
        this.setSize(tag.method_10573("Size", 3) ? tag.method_10550("Size") : this.inventory.size());
        class_2499 itemListTag = tag.method_10554("Items", 10);
        for (int i = 0; i < itemListTag.size(); ++i) {
            class_2487 itemTag = itemListTag.method_10602(i);
            int slot = itemTag.method_10550("Slot");
            if (slot < 0 || slot > this.inventory.size()) continue;
            this.inventory.set(slot, (Object)class_1799.method_7915((class_2487)itemTag));
        }
        this.onInventoryLoaded();
    }
}

