/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import org.apache.commons.io.IOUtils;

public class Translations {
    private static Map<String, String> translationMap;

    public static String tr(String key) {
        return translationMap == null ? key : translationMap.getOrDefault(key, key);
    }

    public static String tr(String key, String str) {
        return translationMap == null ? str : translationMap.getOrDefault(key, str);
    }

    public static boolean hasTranslations() {
        return translationMap != null;
    }

    public static boolean hasTranslation(String key) {
        return translationMap != null && translationMap.containsKey(key);
    }

    public static Map<String, String> getTranslationFromResourcePath(String path) {
        String dataJSON;
        try {
            dataJSON = IOUtils.toString((InputStream)Objects.requireNonNull(Translations.class.getClassLoader().getResourceAsStream(String.format("assets/carpet/lang/%s.json", CarpetSettings.language))), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
        return (Map)gson.fromJson(dataJSON, new TypeToken<Map<String, String>>(){}.getType());
    }

    public static void updateLanguage(class_2168 source) {
        if (CarpetSettings.language.equalsIgnoreCase("none")) {
            translationMap = null;
            return;
        }
        HashMap<String, String> translations = new HashMap<String, String>();
        Map<String, String> trans = Translations.getTranslationFromResourcePath(String.format("assets/carpet/lang/%s.json", CarpetSettings.language));
        if (trans != null) {
            trans.forEach(translations::put);
        }
        for (CarpetExtension ext : CarpetServer.extensions) {
            Map<String, String> extMappings = ext.canHasTranslations(CarpetSettings.language);
            if (extMappings == null) continue;
            extMappings.forEach((key, value) -> {
                if (!translations.containsKey(key)) {
                    translations.put((String)key, (String)value);
                }
            });
        }
        translations.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("//"));
        if (translations.isEmpty()) {
            translationMap = null;
            return;
        }
        translationMap = translations;
    }

    public static boolean isValidLanguage(String newValue) {
        return true;
    }
}

