/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Expression;
import carpet.script.exception.InternalExpressionException;
import carpet.script.utils.SystemInfo;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.SpawnReporter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.class_1311;
import net.minecraft.class_1948;
import net.minecraft.class_3218;

public class Monitoring {
    public static void apply(Expression expression) {
        expression.addContextFunction("system_info", -1, (c, t, lv) -> {
            if (lv.size() == 0) {
                return SystemInfo.getAll();
            }
            if (lv.size() == 1) {
                String what = ((Value)lv.get(0)).getString();
                Value res = SystemInfo.get(what, (CarpetContext)c);
                if (res == null) {
                    throw new InternalExpressionException("Unknown option for 'system_info': " + what);
                }
                return res;
            }
            throw new InternalExpressionException("'system_info' requires one or no parameters");
        });
        expression.addContextFunction("get_mob_counts", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_3218 world = cc.s.method_9225();
            class_1948.class_5262 info = world.method_14178().method_27908();
            if (info == null) {
                return Value.NULL;
            }
            Object2IntMap mobcounts = info.method_27830();
            int chunks = info.method_27823();
            if (lv.size() == 0) {
                HashMap<Value, Value> retDict = new HashMap<Value, Value>();
                for (class_1311 category : mobcounts.keySet()) {
                    int currentCap = category.method_6134() * chunks / SpawnReporter.MAGIC_NUMBER;
                    retDict.put(new StringValue(category.method_15434().toLowerCase(Locale.ROOT)), ListValue.of(new NumericValue(mobcounts.getInt((Object)category)), new NumericValue(currentCap)));
                }
                return MapValue.wrap(retDict);
            }
            String catString = ((Value)lv.get(0)).getString();
            class_1311 cat = class_1311.method_28307((String)catString.toLowerCase(Locale.ROOT));
            if (cat == null) {
                throw new InternalExpressionException("Unreconized mob category: " + catString);
            }
            return ListValue.of(new NumericValue(mobcounts.getInt((Object)cat)), new NumericValue(cat.method_6134() * chunks / SpawnReporter.MAGIC_NUMBER));
        });
    }
}

