/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model;

import com.copycatsplus.copycats.config.CCConfigs;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.CopycatModelPart;
import com.copycatsplus.copycats.foundation.copycat.model.assembly.CopycatRenderContext;
import com.copycatsplus.copycats.foundation.copycat.model.fabric.CopycatModelCoreImpl;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public abstract class CopycatModelCore
implements CopycatModelPart {
    protected static final ModelEntry SUPER = new ModelEntry("super", null, null, EntryType.STATIC);
    public static final String MATERIAL_KEY = "material";
    protected final ModelEntry MATERIAL = new ModelEntry("material", ModelGetter.MATERIAL, this, EntryType.COPYCAT);
    public boolean enhanced = true;
    public boolean colorize = false;

    public void registerModels(List<ModelEntry> entries) {
        entries.add(this.MATERIAL);
    }

    protected final void registerForMultiState(List<ModelEntry> entries, IMultiStateCopycatBlock block, boolean isKinetic) {
        for (String property : block.storageProperties()) {
            this.registerMultiStatePart(entries, property, isKinetic);
        }
    }

    protected final void registerMultiStatePart(List<ModelEntry> entries, String property, boolean isKinetic) {
        entries.add(new ModelEntry(property, (state, mat) -> CopycatModelCore.getModelOf(mat), this, isKinetic ? EntryType.KINETIC_COPYCAT : EntryType.COPYCAT));
    }

    public void prepareForRender() {
        this.enhanced = (Boolean)CCConfigs.client().useEnhancedModels.get();
        this.colorize = (Boolean)CCConfigs.client().colorizeMultiStates.get();
    }

    @Override
    public abstract void emitCopycatQuads(String var1, class_2680 var2, CopycatRenderContext var3, class_2680 var4);

    public static class_1087 getModelOf(class_2680 state) {
        return class_310.method_1551().method_1541().method_3349(state);
    }

    public static MaterialMapper updatePropertiesIfMatch(Class<?> clazz) {
        return (state, mat) -> {
            if (mat == null) {
                return null;
            }
            if (clazz.isInstance(mat.method_26204())) {
                return BlockUtils.tryCopyProperties(state, mat);
            }
            return mat;
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static class_1087 createModel(class_1087 original, CopycatModelCore core) {
        void var1_1;
        return CopycatModelCoreImpl.createModel(original, (CopycatModelCore)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @NotNull
    @ExpectPlatform.Transformed
    public static class_1087 createKineticModel(class_1087 original, CopycatModelCore core) {
        void var1_1;
        return CopycatModelCoreImpl.createKineticModel(original, (CopycatModelCore)var1_1);
    }

    public static CopycatModelCore kinetic(final CopycatModelCore ... cores) {
        return new CopycatModelCore(){

            @Override
            public void registerModels(List<ModelEntry> entries) {
                for (CopycatModelCore core : cores) {
                    core.registerModels(entries);
                }
                entries.add(SUPER);
            }

            @Override
            public void emitCopycatQuads(String key, class_2680 state, CopycatRenderContext context, class_2680 material) {
            }
        };
    }

    @ParametersAreNonnullByDefault
    public record ModelEntry(String key, @Nullable ModelGetter model, @Nullable CopycatModelPart part, MaterialMapper materialMapper, EntryType type, @Nullable class_1921 renderType) {
        public ModelEntry(String key, @Nullable ModelGetter model, @Nullable CopycatModelPart part, EntryType type) {
            this(key, model, part, MaterialMapper.IDENTITY, type, null);
        }

        public ModelEntry(String key, @Nullable ModelGetter model, @Nullable CopycatModelPart part, MaterialMapper materialMapper, EntryType type) {
            this(key, model, part, materialMapper, type, null);
        }
    }

    @FunctionalInterface
    public static interface ModelGetter {
        public static final ModelGetter MATERIAL = (state, material) -> CopycatModelCore.getModelOf(material);

        public class_1087 getModel(class_2680 var1, class_2680 var2);
    }

    public static enum EntryType {
        STATIC(false, false),
        COPYCAT(true, false),
        KINETIC(false, true),
        KINETIC_COPYCAT(true, true);

        private final boolean useCopycatLogic;
        private final boolean onlyWhenVirtual;

        private EntryType(boolean useCopycatLogic, boolean onlyWhenVirtual) {
            this.useCopycatLogic = useCopycatLogic;
            this.onlyWhenVirtual = onlyWhenVirtual;
        }

        public boolean useCopycatLogic() {
            return this.useCopycatLogic;
        }

        public boolean onlyWhenVirtual() {
            return this.onlyWhenVirtual;
        }
    }

    @FunctionalInterface
    public static interface MaterialMapper {
        public static final MaterialMapper IDENTITY = (state, material) -> material;

        public class_2680 map(class_2680 var1, class_2680 var2);
    }

    public static abstract class WithData<T>
    extends CopycatModelCore {
        private final ThreadLocal<T> data = new ThreadLocal();

        public void setData(T data) {
            this.data.set(data);
        }

        public T getData() {
            return this.data.get();
        }
    }
}

