/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.foundation.copycat.CopycatMaterialStore;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.ItemUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.IMergeableBE;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_6328;
import org.jetbrains.annotations.ApiStatus;

@ParametersAreNonnullByDefault
@class_6328
public interface ICopycatBlockEntity
extends ISpecialBlockEntityItemRequirement,
ITransformableBlockEntity,
IPartialSafeNBT,
IMergeableBE {
    public void notifyUpdate();

    public class_1937 method_10997();

    public class_2338 method_11016();

    public class_2680 method_11010();

    public void method_31664(class_2680 var1);

    public void method_31662(class_1937 var1);

    public class_2680 getMaterial();

    public class_1799 getConsumedItem();

    public boolean isCTEnabled();

    @ApiStatus.OverrideOnly
    public void setMaterialInternal(class_2680 var1);

    @ApiStatus.OverrideOnly
    public void setConsumedItemInternal(class_1799 var1);

    @ApiStatus.OverrideOnly
    public void setCTEnabledInternal(boolean var1);

    default public void init() {
        this.setMaterialInternal(AllBlocks.COPYCAT_BASE.getDefaultState());
        this.setConsumedItemInternal(class_1799.field_8037);
        this.setCTEnabledInternal(true);
    }

    default public ICopycatBlock getBlock() {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof ICopycatBlock) {
            ICopycatBlock copycatBlock = (ICopycatBlock)block;
            return copycatBlock;
        }
        return new ICopycatBlock(){};
    }

    default public boolean hasCustomMaterial() {
        return !AllBlocks.COPYCAT_BASE.has(this.getMaterial());
    }

    default public void setMaterial(class_2680 blockState) {
        class_2680 wrapperState = this.method_11010();
        if (!this.getMaterial().method_27852(blockState.method_26204())) {
            for (class_2350 side : Iterate.directions) {
                ICopycatBlockEntity cbe;
                class_2680 otherMaterial;
                class_2586 class_25862;
                class_2338 neighbour = this.method_11016().method_10093(side);
                class_2680 neighbourState = this.method_10997().method_8320(neighbour);
                if (neighbourState != wrapperState || !((class_25862 = this.method_10997().method_8321(neighbour)) instanceof ICopycatBlockEntity) || !(otherMaterial = (cbe = (ICopycatBlockEntity)class_25862).getMaterial()).method_27852(blockState.method_26204())) continue;
                blockState = otherMaterial;
                break;
            }
        }
        this.setMaterialInternal(blockState);
        BlockEntityUtils.redraw((class_2586)this);
    }

    default public boolean cycleMaterial() {
        class_2680 material = this.getMaterial();
        if (material.method_28498((class_2769)class_2533.field_11625) && material.method_28500((class_2769)class_2533.field_11631).orElse(false).booleanValue()) {
            this.setMaterial((class_2680)material.method_28493((class_2769)class_2533.field_11625));
        } else if (material.method_28498((class_2769)class_2741.field_12525)) {
            this.setMaterial((class_2680)material.method_28493((class_2769)class_2741.field_12525));
        } else if (material.method_28498((class_2769)class_2741.field_12481)) {
            this.setMaterial((class_2680)material.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)material.method_11654((class_2769)class_2741.field_12481)).method_10170()));
        } else if (material.method_28498((class_2769)class_2741.field_12496)) {
            this.setMaterial((class_2680)material.method_28493((class_2769)class_2741.field_12496));
        } else if (material.method_28498((class_2769)class_2741.field_12529)) {
            this.setMaterial((class_2680)material.method_28493((class_2769)class_2741.field_12529));
        } else if (material.method_28498((class_2769)class_2741.field_12548)) {
            this.setMaterial((class_2680)material.method_28493((class_2769)class_2741.field_12548));
        } else if (material.method_28498((class_2769)RoseQuartzLampBlock.POWERING)) {
            this.setMaterial((class_2680)material.method_28493((class_2769)RoseQuartzLampBlock.POWERING));
        } else {
            return false;
        }
        return true;
    }

    default public void setConsumedItem(class_1799 stack) {
        this.setConsumedItemInternal(ItemUtils.copyStackWithSize(stack, 1));
        this.notifyUpdate();
    }

    default public void setCTEnabled(boolean value) {
        this.setCTEnabledInternal(value);
        this.notifyUpdate();
    }

    default public void invalidate() {
        CopycatMaterialStore.setMaterial((class_1922)this.method_10997(), this.method_11016(), class_2246.field_10124.method_9564());
    }

    default public ItemRequirement getRequiredItems(class_2680 state) {
        if (this.getConsumedItem().method_7960()) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.getConsumedItem());
    }

    default public void accept(class_2586 other) {
        if (other instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity be = (ICopycatBlockEntity)other;
            this.setMaterial(be.getMaterial());
            this.setConsumedItem(be.getConsumedItem());
            this.setCTEnabled(be.isCTEnabled());
            BlockEntityUtils.redraw((class_2586)this);
        }
    }

    default public void transform(StructureTransform transform) {
        this.setMaterialInternal(transform.apply(this.getMaterial()));
        this.notifyUpdate();
    }

    public static void read(ICopycatBlockEntity self, class_2487 tag, boolean clientPacket) {
        if (tag.method_10545("EnableCT")) {
            self.setCTEnabled(tag.method_10577("EnableCT"));
        } else {
            self.setCTEnabled(true);
        }
        self.setConsumedItem(class_1799.method_7915((class_2487)tag.method_10562("Item")));
        class_2680 prevMaterial = self.getMaterial();
        if (!tag.method_10545("Material")) {
            self.setConsumedItem(class_1799.field_8037);
            return;
        }
        self.setMaterialInternal(class_2512.method_10681((class_2487)tag.method_10562("Material")));
        if (self.getMaterial() != null && !clientPacket) {
            class_2680 blockState = self.method_11010();
            if (blockState == null) {
                return;
            }
            class_2248 class_22482 = blockState.method_26204();
            if (!(class_22482 instanceof ICopycatBlock)) {
                return;
            }
            ICopycatBlock cb = (ICopycatBlock)class_22482;
            class_2680 acceptedBlockState = cb.getAcceptedBlockState(self.method_10997(), self.method_11016(), self.getConsumedItem(), null);
            if (acceptedBlockState != null && self.getMaterial().method_27852(acceptedBlockState.method_26204())) {
                return;
            }
            self.setConsumedItem(class_1799.field_8037);
            self.setMaterialInternal(AllBlocks.COPYCAT_BASE.getDefaultState());
        }
        if (prevMaterial != self.getMaterial()) {
            BlockEntityUtils.redraw((class_2586)self);
        }
    }

    public static void writeSafe(ICopycatBlockEntity self, class_2487 tag) {
        class_1799 stackWithoutNBT = self.getConsumedItem().method_7972();
        stackWithoutNBT.method_7980(null);
        BlockEntityUtils.saveMetadata((class_2586)self, tag);
        ICopycatBlockEntity.write(tag, stackWithoutNBT, self.getMaterial(), self.isCTEnabled());
    }

    public static void write(ICopycatBlockEntity self, class_2487 tag, boolean clientPacket) {
        ICopycatBlockEntity.write(tag, self.getConsumedItem(), self.getMaterial(), self.isCTEnabled());
    }

    @ApiStatus.Internal
    public static void write(class_2487 tag, class_1799 stack, class_2680 material, boolean enableCT) {
        tag.method_10566("Item", ItemUtils.serializeNBT(stack));
        tag.method_10566("Material", (class_2520)class_2512.method_10686((class_2680)material));
        tag.method_10556("EnableCT", enableCT);
    }
}

