/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.hats.web;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.midnightdust.hats.web.PlayerHatData;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_310;

public class HatLoader {
    public static final System.Logger logger = System.getLogger("MidnightLib");
    private static final String HATS_URL = "https://raw.githubusercontent.com/TeamMidnightDust/MidnightHats/master/hats.json";
    public static final Type HAT_TYPE = new TypeToken<Map<UUID, PlayerHatData>>(){}.getType();
    public static Map<UUID, PlayerHatData> PLAYER_HATS;
    private static final Gson GSON;

    public static void init() {
        CompletableFuture.supplyAsync(() -> {
            block8: {
                Map map;
                InputStreamReader reader = new InputStreamReader(new URL(HATS_URL).openStream());
                try {
                    map = (Map)GSON.fromJson((Reader)reader, HAT_TYPE);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException error) {
                        logger.log(System.Logger.Level.ERROR, "Unable to load player hats because of connection problems: " + error.getMessage());
                        break block8;
                    }
                    catch (IOException error) {
                        logger.log(System.Logger.Level.ERROR, "Unable to load player hats because of an I/O Exception: " + error.getMessage());
                    }
                }
                ((Reader)reader).close();
                return map;
            }
            return null;
        }).thenAcceptAsync(playerData -> {
            if (playerData != null) {
                PLAYER_HATS = playerData;
                System.out.println("(MidnightLib) Player hats successfully loaded!");
            } else {
                PLAYER_HATS = Collections.emptyMap();
                logger.log(System.Logger.Level.WARNING, "A problem with the database occurred, the hats could not be initialized.");
            }
        }, (Executor)class_310.method_1551());
    }

    static {
        GSON = new GsonBuilder().create();
    }
}

