/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class FluidTask
extends Task {
    public static final class_2960 TANK_TEXTURE = new class_2960("ftbquests", "textures/tasks/tank.png");
    public class_3611 fluid = class_3612.field_15910;
    public class_2487 fluidNBT = null;
    public long amount = FluidStack.bucketAmount();
    private FluidStack cachedFluidStack = null;

    public FluidTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.FLUID;
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String formatMaxProgress() {
        return FluidTask.getVolumeString(this.amount);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return FluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("fluid", Registries.getId((Object)this.fluid, (class_5321)class_2378.field_25103).toString());
        nbt.method_10544("amount", this.amount);
        if (this.fluidNBT != null) {
            nbt.method_10566("nbt", (class_2520)this.fluidNBT);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.fluid = (class_3611)class_2378.field_11154.method_10223(new class_2960(nbt.method_10558("fluid")));
        if (this.fluid == null || this.fluid == class_3612.field_15906) {
            this.fluid = class_3612.field_15910;
        }
        this.amount = Math.max(1L, nbt.method_10537("amount"));
        this.fluidNBT = (class_2487)nbt.method_10580("nbt");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10812(Registries.getId((Object)this.fluid, (class_5321)class_2378.field_25103));
        buffer.method_10794(this.fluidNBT);
        buffer.method_10791(this.amount);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.fluid = (class_3611)class_2378.field_11154.method_10223(buffer.method_10810());
        if (this.fluid == null || this.fluid == class_3612.field_15906) {
            this.fluid = class_3612.field_15910;
        }
        this.fluidNBT = buffer.method_10798();
        this.amount = buffer.method_10792();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedFluidStack = null;
    }

    public FluidStack createFluidStack() {
        if (this.cachedFluidStack == null) {
            this.cachedFluidStack = FluidStack.create((class_3611)this.fluid, (long)FluidStack.bucketAmount(), (class_2487)this.fluidNBT);
        }
        return this.cachedFluidStack;
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount()) {
            if (a % FluidStack.bucketAmount() != 0L) {
                builder.append(StringUtils.formatDouble((double)((double)a / (double)FluidStack.bucketAmount())));
            } else {
                builder.append(a / FluidStack.bucketAmount());
            }
            builder.append(" B");
        } else {
            builder.append(a).append(" mB");
        }
        return builder.toString();
    }

    public class_5250 getAltTitle() {
        return new class_2585(FluidTask.getVolumeString(this.amount) + " of ").method_10852(this.createFluidStack().getName());
    }

    @Override
    public Icon getAltIcon() {
        FluidStack stack = this.createFluidStack();
        String id = Optional.ofNullable(FluidStackHooks.getStillTexture((FluidStack)stack)).map(class_1058::method_4598).map(class_2960::toString).orElse("missingno");
        return Icon.getIcon((String)id).withTint(Color4I.rgb((int)FluidStackHooks.getColor((FluidStack)stack)));
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("fluid", (ConfigValue)new FluidConfig(false), (Object)this.fluid, v -> {
            this.fluid = v;
        }, (Object)class_3612.field_15910);
        config.add("fluid_nbt", (ConfigValue)new NBTConfig(), (Object)this.fluidNBT, v -> {
            this.fluidNBT = v;
        }, null);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, FluidStack.bucketAmount(), 1L, Long.MAX_VALUE);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.createFluidStack();
    }
}

