/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class CommandReward
extends Reward {
    public String command = "/say Hi, @p!";
    public boolean playerCommand;
    public boolean silent;

    public CommandReward(Quest quest) {
        super(quest);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.COMMAND;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("command", this.command);
        if (this.playerCommand) {
            nbt.method_10556("player_command", true);
        }
        if (this.silent) {
            nbt.method_10556("silent", true);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.command = nbt.method_10558("command");
        this.playerCommand = nbt.method_10577("player_command");
        this.silent = nbt.method_10577("silent");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.command, Short.MAX_VALUE);
        buffer.writeBoolean(this.playerCommand);
        buffer.writeBoolean(this.silent);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.command = buffer.method_10800(Short.MAX_VALUE);
        this.playerCommand = buffer.readBoolean();
        this.silent = buffer.readBoolean();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("command", this.command, v -> {
            this.command = v;
        }, "/say Hi, @team!").setNameKey("ftbquests.reward.ftbquests.command");
        config.addBool("player", this.playerCommand, v -> {
            this.playerCommand = v;
        }, false);
        config.addBool("silent", this.silent, v -> {
            this.silent = v;
        }, false);
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        class_2168 stack;
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("p", player.method_7334().getName());
        class_2338 pos = player.method_24515();
        overrides.put("x", pos.method_10263());
        overrides.put("y", pos.method_10264());
        overrides.put("z", pos.method_10260());
        Chapter chapter = this.getQuestChapter();
        if (chapter != null) {
            overrides.put("chapter", chapter);
        }
        overrides.put("quest", this.quest);
        String s = this.command;
        for (Map.Entry entry : overrides.entrySet()) {
            if (entry.getValue() == null) continue;
            s = s.replace("@" + (String)entry.getKey(), entry.getValue().toString());
        }
        class_2168 class_21682 = stack = this.playerCommand ? player.method_5671() : player.field_13995.method_3739();
        if (this.silent) {
            stack = stack.method_9217();
        }
        player.field_13995.method_3734().method_9249(stack, s);
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return new class_2588("ftbquests.reward.ftbquests.command").method_27693(": ").method_10852((class_2561)new class_2585(this.command).method_27692(class_124.field_1061));
    }
}

