/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.ConfigIconItemStack;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public abstract class QuestObjectBase {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    public static Tristate sendNotifications = Tristate.DEFAULT;
    public long id = 0L;
    public boolean invalid = false;
    public String title = "";
    public class_1799 icon = class_1799.field_8037;
    private List<String> tags = new ArrayList<String>(0);
    private Icon cachedIcon = null;
    private class_2561 cachedTitle = null;
    private Set<String> cachedTags = null;

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static long getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0L : object.id;
    }

    public static String getCodeString(long id) {
        return String.format("%016X", id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return QuestObjectBase.getCodeString(QuestObjectBase.getID(object));
    }

    public static long parseCodeString(String id) {
        if (id.isEmpty() || id.equals("-")) {
            return 0L;
        }
        try {
            return Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static Optional<String> titleToID(String s) {
        s = s.replace(' ', '_').replaceAll("\\W", "").toLowerCase().trim();
        while (s.startsWith("_")) {
            s = s.substring(1);
        }
        while (s.endsWith("_")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? Optional.empty() : Optional.of(s);
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return Long.hashCode(this.id);
    }

    public abstract QuestObjectType getObjectType();

    public abstract QuestFile getQuestFile();

    public Set<String> getTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.cachedTags == null) {
            this.cachedTags = new LinkedHashSet<String>(this.tags);
        }
        return this.cachedTags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.getTags().contains(tag);
    }

    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
    }

    public final void forceProgressRaw(TeamData teamData, ProgressChange progressChange) {
        if (teamData.isLocked()) {
            return;
        }
        teamData.clearCachedProgress();
        sendNotifications = progressChange.notifications ? Tristate.TRUE : Tristate.FALSE;
        this.forceProgress(teamData, progressChange);
        sendNotifications = Tristate.DEFAULT;
        teamData.clearCachedProgress();
        teamData.save();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public long getParentID() {
        return 1L;
    }

    public void writeData(class_2487 nbt) {
        if (!this.title.isEmpty()) {
            nbt.method_10582("title", this.title);
        }
        NBTUtils.write(nbt, "icon", this.icon);
        if (!this.tags.isEmpty()) {
            class_2499 tagList = new class_2499();
            for (String s : this.tags) {
                tagList.add((Object)class_2519.method_23256((String)s));
            }
            nbt.method_10566("tags", (class_2520)tagList);
        }
    }

    public void readData(class_2487 nbt) {
        this.title = nbt.method_10558("title");
        this.icon = NBTUtils.read(nbt, "icon");
        class_2499 tagsList = nbt.method_10554("tags", 8);
        this.tags = new ArrayList<String>(tagsList.size());
        for (int i = 0; i < tagsList.size(); ++i) {
            this.tags.add(tagsList.method_10608(i));
        }
        if (nbt.method_10545("custom_id")) {
            this.tags.add(nbt.method_10558("custom_id"));
        }
    }

    public void writeNetData(class_2540 buffer) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.title.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.icon.method_7960() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        buffer.method_10804(flags);
        if (!this.title.isEmpty()) {
            buffer.method_10788(this.title, Short.MAX_VALUE);
        }
        if (!this.icon.method_7960()) {
            buffer.method_10793(this.icon);
        }
        if (!this.tags.isEmpty()) {
            NetUtils.writeStrings(buffer, this.tags);
        }
    }

    public void readNetData(class_2540 buffer) {
        int flags = buffer.method_10816();
        this.title = Bits.getFlag((int)flags, (int)1) ? buffer.method_10800(Short.MAX_VALUE) : "";
        this.icon = Bits.getFlag((int)flags, (int)2) ? buffer.method_10819() : class_1799.field_8037;
        this.tags = new ArrayList<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            NetUtils.readStrings(buffer, this.tags);
        }
    }

    protected boolean hasTitleConfig() {
        return true;
    }

    protected boolean hasIconConfig() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        if (this.hasTitleConfig()) {
            config.addString("title", this.title, v -> {
                this.title = v;
            }, "").setNameKey("ftbquests.title").setOrder(-127);
        }
        if (this.hasIconConfig()) {
            ((ConfigIconItemStack)config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.icon, v -> {
                this.icon = v;
            }, (Object)class_1799.field_8037)).setNameKey("ftbquests.icon").setOrder(-126);
        }
        config.addList("tags", this.tags, (ConfigValue)new StringConfig(TAG_PATTERN), (Object)"").setNameKey("ftbquests.tags").setOrder(-125);
    }

    @Environment(value=EnvType.CLIENT)
    public abstract class_2561 getAltTitle();

    @Environment(value=EnvType.CLIENT)
    public abstract Icon getAltIcon();

    @Environment(value=EnvType.CLIENT)
    public final class_2561 getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle.method_27661();
        }
        this.cachedTitle = !this.title.isEmpty() ? TextUtils.parseRawText(this.title) : this.getAltTitle();
        return this.cachedTitle.method_27661();
    }

    @Environment(value=EnvType.CLIENT)
    public final class_5250 getMutableTitle() {
        return new class_2585("").method_10852(this.getTitle());
    }

    @Environment(value=EnvType.CLIENT)
    public final Icon getIcon() {
        if (this.cachedIcon != null) {
            return this.cachedIcon;
        }
        if (!this.icon.method_7960()) {
            this.cachedIcon = CustomIconItem.getIcon(this.icon);
        }
        if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
            this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
        }
        if (this.cachedIcon.isEmpty()) {
            this.cachedIcon = this.getAltIcon();
        }
        return this.cachedIcon;
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void editedFromGUIOnServer() {
    }

    public void onCreated() {
    }

    @Nullable
    public String getPath() {
        return null;
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTags = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getGroup(this.getObjectType().id);
    }

    @Environment(value=EnvType.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        this.getConfig(this.createSubGroup(group));
        group.savedCallback = accepted -> {
            gui.run();
            if (accepted) {
                new EditObjectMessage(this).sendToServer();
            }
        };
        new EditConfigScreen(group).openGui();
    }

    public int refreshJEI() {
        return 0;
    }
}

