/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import dev.ftb.mods.ftbquests.util.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_4587;

public final class ChapterImage
implements Movable {
    public Chapter chapter;
    public double x;
    public double y;
    public double width;
    public double height;
    public double rotation;
    public Icon image;
    public List<String> hover;
    public String click;
    public boolean dev;
    public boolean corner;
    public Quest dependency;

    public ChapterImage(Chapter c) {
        this.chapter = c;
        this.y = 0.0;
        this.x = 0.0;
        this.width = 1.0;
        this.height = 1.0;
        this.rotation = 0.0;
        this.image = Icon.getIcon((String)"minecraft:textures/gui/presets/isles.png");
        this.hover = new ArrayList<String>();
        this.click = "";
        this.dev = false;
        this.corner = false;
        this.dependency = null;
    }

    public void writeData(class_2487 nbt) {
        nbt.method_10549("x", this.x);
        nbt.method_10549("y", this.y);
        nbt.method_10549("width", this.width);
        nbt.method_10549("height", this.height);
        nbt.method_10549("rotation", this.rotation);
        nbt.method_10582("image", this.image.toString());
        class_2499 hoverTag = new class_2499();
        for (String s : this.hover) {
            hoverTag.add((Object)class_2519.method_23256((String)s));
        }
        nbt.method_10566("hover", (class_2520)hoverTag);
        nbt.method_10582("click", this.click);
        nbt.method_10556("dev", this.dev);
        nbt.method_10556("corner", this.corner);
        if (this.dependency != null) {
            nbt.method_10582("dependency", this.dependency.getCodeString());
        }
    }

    public void readData(class_2487 nbt) {
        this.x = nbt.method_10574("x");
        this.y = nbt.method_10574("y");
        this.width = nbt.method_10574("width");
        this.height = nbt.method_10574("height");
        this.rotation = nbt.method_10574("rotation");
        this.image = Icon.getIcon((String)nbt.method_10558("image"));
        this.hover.clear();
        class_2499 hoverTag = nbt.method_10554("hover", 8);
        for (int i = 0; i < hoverTag.size(); ++i) {
            this.hover.add(hoverTag.method_10608(i));
        }
        this.click = nbt.method_10558("click");
        this.dev = nbt.method_10577("dev");
        this.corner = nbt.method_10577("corner");
        this.dependency = nbt.method_10545("dependency") ? this.chapter.file.getQuest(this.chapter.file.getID(nbt.method_10580("dependency"))) : null;
    }

    public void writeNetData(class_2540 buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.width);
        buffer.writeDouble(this.height);
        buffer.writeDouble(this.rotation);
        NetUtils.writeIcon(buffer, this.image);
        NetUtils.writeStrings(buffer, this.hover);
        buffer.method_10788(this.click, Short.MAX_VALUE);
        buffer.writeBoolean(this.dev);
        buffer.writeBoolean(this.corner);
        buffer.writeLong(this.dependency == null ? 0L : this.dependency.id);
    }

    public void readNetData(class_2540 buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.width = buffer.readDouble();
        this.height = buffer.readDouble();
        this.rotation = buffer.readDouble();
        this.image = NetUtils.readIcon(buffer);
        NetUtils.readStrings(buffer, this.hover);
        this.click = buffer.method_10800(Short.MAX_VALUE);
        this.dev = buffer.readBoolean();
        this.corner = buffer.readBoolean();
        this.dependency = this.chapter.file.getQuest(buffer.readLong());
    }

    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addDouble("x", this.x, v -> {
            this.x = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("y", this.y, v -> {
            this.y = v;
        }, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        config.addDouble("width", this.width, v -> {
            this.width = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("height", this.height, v -> {
            this.height = v;
        }, 1.0, 0.0, Double.POSITIVE_INFINITY);
        config.addDouble("rotation", this.rotation, v -> {
            this.rotation = v;
        }, 0.0, -180.0, 180.0);
        config.add("image", (ConfigValue)new ImageConfig(), (Object)this.image.toString(), v -> {
            this.image = Icon.getIcon((String)v);
        }, (Object)"minecraft:textures/gui/presets/isles.png");
        config.addList("hover", this.hover, (ConfigValue)new StringConfig(), (Object)"");
        config.addString("click", this.click, v -> {
            this.click = v;
        }, "");
        config.addBool("dev", this.dev, v -> {
            this.dev = v;
        }, false);
        config.addBool("corner", this.corner, v -> {
            this.corner = v;
        }, false);
        Predicate<QuestObjectBase> depTypes = object -> object == null || object instanceof Quest;
        ((ConfigQuestObject)config.add("dependency", new ConfigQuestObject(depTypes), (Object)this.dependency, v -> {
            this.dependency = v;
        }, null)).setNameKey("ftbquests.dependency");
    }

    @Override
    public long getMovableID() {
        return 0L;
    }

    @Override
    public Chapter getChapter() {
        return this.chapter;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public String getShape() {
        return "square";
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void move(Chapter to, double _x, double _y) {
        this.x = _x;
        this.y = _y;
        if (to != this.chapter) {
            this.chapter.images.remove(this);
            new EditObjectMessage(this.chapter).sendToServer();
            this.chapter = to;
            this.chapter.images.add(this);
        }
        new EditObjectMessage(this.chapter).sendToServer();
    }

    @Override
    public void onMoved(double x, double y, long chapterId) {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawMoved(class_4587 matrixStack) {
        matrixStack.method_22903();
        if (this.corner) {
            matrixStack.method_22907(class_1160.field_20707.method_23214((float)this.rotation));
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, 0, 0, 1, 1);
        } else {
            matrixStack.method_22904(0.5, 0.5, 0.0);
            matrixStack.method_22907(class_1160.field_20707.method_23214((float)this.rotation));
            matrixStack.method_22905(0.5f, 0.5f, 1.0f);
            this.image.withColor(Color4I.WHITE.withAlpha(50)).draw(matrixStack, -1, -1, 2, 2);
        }
        matrixStack.method_22909();
        QuestShape.get((String)this.getShape()).outline.withColor(Color4I.WHITE.withAlpha(30)).draw(matrixStack, 0, 0, 1, 1);
    }
}

