/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.gui.quests.TooltipContextMenuItem;
import dev.ftb.mods.ftbquests.net.CreateObjectMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class AddTaskButton
extends Button {
    public final Quest quest;

    public AddTaskButton(Panel panel, Quest q) {
        super(panel, (class_2561)new class_2588("gui.add"), (Icon)ThemeProperties.ADD_ICON.get());
        this.quest = q;
        this.setSize(18, 18);
    }

    public void onClicked(MouseButton button) {
        this.playClickSound();
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        for (TaskType type : TaskTypes.TYPES.values()) {
            contextMenu.add(new ContextMenuItem(type.getDisplayName(), type.getIcon(), () -> {
                this.playClickSound();
                type.getGuiProvider().openCreationGui((Runnable)((Object)this), this.quest, task -> {
                    class_2487 extra = new class_2487();
                    extra.method_10582("type", type.getTypeForNBT());
                    new CreateObjectMessage((QuestObjectBase)task, extra).sendToServer();
                });
            }));
        }
        String clip = AddTaskButton.getClipboardString();
        if (!clip.isEmpty()) {
            try {
                long taskId = Long.valueOf(clip, 16);
                QuestObject questObject = FTBQuests.PROXY.getQuestFile(true).get(taskId);
                if (questObject instanceof Task) {
                    Task task = (Task)questObject;
                    contextMenu.add(ContextMenuItem.SEPARATOR);
                    contextMenu.add(new PasteTaskMenuItem(task, () -> this.copyAndCreateTask(task)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.getGui().openContextMenu(contextMenu);
    }

    private void copyAndCreateTask(Task task) {
        Task task2 = TaskType.createTask(this.quest, task.getType().id.toString());
        if (task2 != null) {
            class_2487 tag = new class_2487();
            task.writeData(tag);
            task2.readData(tag);
            class_2487 extra = new class_2487();
            extra.method_10582("type", task2.getType().getTypeForNBT());
            new CreateObjectMessage(task2, extra).sendToServer();
        }
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(matrixStack, theme, x, y, w, h);
        }
    }

    public static class PasteTaskMenuItem
    extends TooltipContextMenuItem {
        public PasteTaskMenuItem(Task task, @Nullable Runnable callback) {
            super((class_2561)new class_2588("ftbquests.gui.paste_task"), Icons.ADD, callback, new class_2561[]{new class_2585("\"").method_10852(task.getTitle()).method_27693("\""), new class_2585(QuestObjectBase.getCodeString(task.id)).method_27692(class_124.field_1063)});
        }
    }
}

