/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.command;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_2172;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class QuestObjectArgument
implements ArgumentType<QuestObjectBase> {
    private static final List<String> examples = ImmutableList.of((Object)"1CF239D256879E6F", (Object)"#importantquests");
    public static final SimpleCommandExceptionType NO_FILE = new SimpleCommandExceptionType((Message)new class_2588("commands.ftbquests.command.error.no_file"));
    public static final DynamicCommandExceptionType NO_OBJECT = new DynamicCommandExceptionType(object -> new class_2588("commands.ftbquests.command.error.no_object", new Object[]{object}));
    public static final DynamicCommandExceptionType INVALID_ID = new DynamicCommandExceptionType(id -> new class_2588("commands.ftbquests.command.error.invalid_id", new Object[]{id}));
    private final Predicate<QuestObjectBase> filter;

    public QuestObjectArgument() {
        this(qo -> true);
    }

    public QuestObjectArgument(Predicate<QuestObjectBase> filter) {
        this.filter = filter;
    }

    public QuestObjectBase parse(StringReader reader) throws CommandSyntaxException {
        String id = reader.readString();
        QuestFile file = QuestObjectArgument.findQuestFile();
        if (file != null) {
            if (id.startsWith("#")) {
                for (QuestObjectBase object : file.getAllObjects()) {
                    if (!object.hasTag(id.substring(1)) || !this.filter.test(object)) continue;
                    return object;
                }
                throw NO_OBJECT.createWithContext((ImmutableStringReader)reader, (Object)id);
            }
            try {
                long num = file.getID(id);
                QuestObjectBase object = file.getBase(num);
                if (object == null || !this.filter.test(object)) {
                    throw NO_OBJECT.createWithContext((ImmutableStringReader)reader, (Object)id);
                }
                return object;
            }
            catch (NumberFormatException e) {
                throw INVALID_ID.createWithContext((ImmutableStringReader)reader, (Object)id);
            }
        }
        throw NO_FILE.create();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        QuestFile file = QuestObjectArgument.findQuestFile();
        if (file != null) {
            return class_2172.method_9264(file.getAllObjects().stream().filter(this.filter).map(QuestObjectBase::getCodeString), (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return examples;
    }

    public static QuestObjectArgument questObject() {
        return new QuestObjectArgument();
    }

    public static QuestObjectArgument questObject(Predicate<QuestObjectBase> filter) {
        return new QuestObjectArgument(filter);
    }

    @Nullable
    private static QuestFile findQuestFile() {
        if (!QuestObjectBase.isNull(ServerQuestFile.INSTANCE)) {
            return ServerQuestFile.INSTANCE;
        }
        if (!QuestObjectBase.isNull(ClientQuestFile.INSTANCE)) {
            return ClientQuestFile.INSTANCE;
        }
        return null;
    }
}

