/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.util.MapJS;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class FluidTagJS
extends FluidStackJS {
    private final class_2960 tag;
    private final String fluid;
    private long amount;
    private class_2487 nbt;
    private FluidStack cached;

    public FluidTagJS(class_2960 location) {
        this.tag = location;
        this.fluid = this.tag.toString();
        this.amount = FluidStack.bucketAmount();
        this.nbt = null;
        this.cached = null;
    }

    public String getId() {
        return this.fluid;
    }

    public FluidStack getFluidStack() {
        if (this.cached == null) {
            this.cached = FluidStack.create(this::getFluid, (long)this.amount, (class_2487)this.nbt);
        }
        return this.cached;
    }

    public class_3611 getFluid() {
        if (KubeJSRegistries.fluids().contains(this.tag)) {
            return (class_3611)KubeJSRegistries.fluids().get(this.tag);
        }
        throw new UnsupportedOperationException("Using getFluid on FluidTags is not supported. This should only be used with recipes.");
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
        this.cached = null;
    }

    @Nullable
    public class_2487 getNbt() {
        return this.nbt;
    }

    public void setNbt(@Nullable class_2487 nbt) {
        this.nbt = nbt;
        this.cached = null;
    }

    public FluidStackJS copy() {
        FluidTagJS fluidTagJS = new FluidTagJS(this.tag);
        fluidTagJS.amount = this.amount;
        fluidTagJS.nbt = this.nbt == null ? null : this.nbt.method_10553();
        return fluidTagJS;
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(o.toString());
        }
        FluidStackJS stack = FluidStackJS.of((Object)o);
        if (stack.isEmpty()) {
            return false;
        }
        return stack.hasTag(this.tag) && this.getAmount() == stack.getAmount() && Objects.equals(this.getNbt(), stack.getNbt());
    }

    public Collection<class_2960> getTags() {
        return Collections.singleton(this.tag);
    }

    public boolean hasTag(class_2960 tag) {
        return this.tag.equals((Object)tag);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getNbt());
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("fluidTag", this.getId());
        if (this.getAmount() != FluidStack.bucketAmount()) {
            o.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getNbt() != null) {
            o.add("nbt", (JsonElement)MapJS.json((Object)this.getNbt()));
        }
        if (this.hasChance()) {
            o.addProperty("chance", (Number)this.getChance());
        }
        return o;
    }
}

