/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import pie.ilikepiefoo.events.EntityEnterChunkEventJS;
import pie.ilikepiefoo.events.EntityTameEventJS;
import pie.ilikepiefoo.events.FarmlandTrampleEventJS;
import pie.ilikepiefoo.events.PlayerChangeDimensionEventJS;
import pie.ilikepiefoo.events.PlayerCloneEventJS;
import pie.ilikepiefoo.events.PlayerRespawnEventJS;

public class EventHandler {
    public static void init() {
        PlayerEvent.CHANGE_DIMENSION.register(EventHandler::onPlayerChangeDimension);
        PlayerEvent.PLAYER_CLONE.register(EventHandler::onPlayerClone);
        PlayerEvent.PLAYER_RESPAWN.register(EventHandler::onPlayerRespawn);
        InteractionEvent.FARMLAND_TRAMPLE.register(EventHandler::onFarmlandTrampled);
        EntityEvent.ENTER_SECTION.register(EventHandler::onEntityEnterChunk);
        EntityEvent.ANIMAL_TAME.register(EventHandler::onEntityTame);
    }

    public static void onPlayerChangeDimension(class_3222 player, class_5321<class_1937> oldLevel, class_5321<class_1937> newLevel) {
        PlayerChangeDimensionEventJS.of(player, oldLevel, newLevel).post(ScriptType.SERVER, "player.change_dimension");
    }

    private static void onPlayerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean conqueredEnd) {
        PlayerCloneEventJS.of(oldPlayer, newPlayer, conqueredEnd).post(ScriptType.SERVER, "player.clone");
    }

    private static void onPlayerRespawn(class_3222 serverPlayer, boolean conqueredEnd) {
        PlayerRespawnEventJS.of(serverPlayer, conqueredEnd).post(ScriptType.SERVER, "player.respawn");
    }

    private static EventResult onFarmlandTrampled(class_1937 world, class_2338 pos, class_2680 state, float distance, class_1297 entity) {
        FarmlandTrampleEventJS event = FarmlandTrampleEventJS.of(world, pos, state, distance, entity);
        event.post("block.trample");
        if (event.isCancelled()) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void onEntityEnterChunk(class_1297 entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        EntityEnterChunkEventJS.of(entity, chunkX, chunkY, chunkZ, prevX, prevY, prevZ).post("entity.enter_chunk");
    }

    private static EventResult onEntityTame(class_1429 animal, class_1657 player) {
        EntityTameEventJS event = EntityTameEventJS.of(animal, player);
        event.post("entity.tame");
        if (event.isCancelled()) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

