/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.gui.TransparentButton;
import com.chaosthedude.explorerscompass.gui.TransparentTextField;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.SearchPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.chaosthedude.explorerscompass.sorting.ISorting;
import com.chaosthedude.explorerscompass.sorting.NameSorting;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class ExplorersCompassScreen
extends class_437 {
    private class_1937 world;
    private class_1657 player;
    private List<class_2960> allowedStructureIDs;
    private List<class_2960> structureIDsMatchingSearch;
    private class_1799 stack;
    private ExplorersCompassItem explorersCompass;
    private class_4185 searchButton;
    private class_4185 searchForGroupButton;
    private class_4185 sortByButton;
    private class_4185 teleportButton;
    private class_4185 cancelButton;
    private TransparentTextField searchTextField;
    private StructureSearchList selectionList;
    private ISorting sortingCategory;

    public ExplorersCompassScreen(class_1937 world, class_1657 player, class_1799 stack, ExplorersCompassItem explorersCompass, List<class_2960> allowedStructureIDs) {
        super((class_2561)new class_2588("string.explorerscompass.selectStructure"));
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.explorersCompass = explorersCompass;
        this.allowedStructureIDs = new ArrayList<class_2960>(allowedStructureIDs);
        this.structureIDsMatchingSearch = new ArrayList<class_2960>(allowedStructureIDs);
        this.sortingCategory = new NameSorting();
    }

    public boolean method_25401(double scroll1, double scroll2, double scroll3) {
        return this.selectionList.method_25401(scroll1, scroll2, scroll3);
    }

    protected void method_25426() {
        this.field_22787.field_1774.method_1462(true);
        this.method_37067();
        this.setupButtons();
        this.setupTextFields();
        if (this.selectionList == null) {
            this.selectionList = new StructureSearchList(this, this.field_22787, this.field_22789 + 110, this.field_22790, 40, this.field_22790, 45);
        }
        this.method_37063((class_364)this.selectionList);
    }

    public void method_25393() {
        this.searchTextField.method_1865();
        boolean bl = this.teleportButton.field_22763 = this.explorersCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedStructureIDs.size() != ExplorersCompass.allowedConfiguredStructureIDs.size()) {
            this.method_37066((class_364)this.selectionList);
            this.allowedStructureIDs = ExplorersCompass.allowedConfiguredStructureIDs;
            this.structureIDsMatchingSearch = new ArrayList<class_2960>(this.allowedStructureIDs);
            this.selectionList = new StructureSearchList(this, this.field_22787, this.field_22789 + 110, this.field_22790, 40, this.field_22790, 45);
            this.method_37063((class_364)this.selectionList);
        }
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        this.selectionList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        ExplorersCompassScreen.method_27534((class_4587)matrixStack, (class_327)this.field_22793, (class_2561)this.field_22785, (int)65, (int)15, (int)0xFFFFFF);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25404(int par1, int par2, int par3) {
        boolean ret = super.method_25404(par1, par2, par3);
        if (this.searchTextField.method_25370()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        boolean ret = super.method_25400(typedChar, keyCode);
        if (this.searchTextField.method_25370()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void method_25419() {
        super.method_25419();
        this.field_22787.field_1774.method_1462(false);
    }

    public void selectStructure(StructureSearchEntry entry) {
        boolean enable;
        this.searchButton.field_22763 = enable = entry != null;
        this.searchForGroupButton.field_22763 = enable;
    }

    public void searchForStructure(class_2960 structureID) {
        ClientPlayNetworking.send((class_2960)SearchPacket.ID, (class_2540)new SearchPacket(structureID, List.of(structureID), this.player.method_24515()));
        this.field_22787.method_1507(null);
    }

    public void searchForStructureGroup(class_2960 structureID) {
        ClientPlayNetworking.send((class_2960)SearchPacket.ID, (class_2540)new SearchPacket(structureID, ExplorersCompass.structureIDsToConfiguredStructureIDs.get((Object)structureID), this.player.method_24515()));
        this.field_22787.method_1507(null);
    }

    public void teleport() {
        ClientPlayNetworking.send((class_2960)TeleportPacket.ID, (class_2540)new TeleportPacket());
        this.field_22787.method_1507(null);
    }

    public void processSearchTerm() {
        this.structureIDsMatchingSearch = new ArrayList<class_2960>();
        for (class_2960 structure : this.allowedStructureIDs) {
            if (!StructureUtils.getStructureName(structure).toLowerCase().contains(this.searchTextField.method_1882().toLowerCase())) continue;
            this.structureIDsMatchingSearch.add(structure);
        }
        this.selectionList.refreshList();
    }

    public List<class_2960> sortStructures() {
        List<class_2960> structures = this.structureIDsMatchingSearch;
        Collections.sort(structures, new NameSorting());
        Collections.sort(structures, this.sortingCategory);
        return structures;
    }

    private void setupButtons() {
        this.searchButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, 40, 110, 20, (class_2561)new class_2588("string.explorerscompass.search"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.method_25334()).searchForStructure();
            }
        }));
        this.searchForGroupButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, 65, 110, 20, (class_2561)new class_2588("string.explorerscompass.searchForGroup"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.method_25334()).searchForStructureGroup();
            }
        }));
        this.sortByButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, 90, 110, 20, (class_2561)new class_2588("string.explorerscompass.sortBy").method_27693(": " + this.sortingCategory.getLocalizedName()), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.method_25355((class_2561)new class_2588("string.explorerscompass.sortBy").method_27693(": " + this.sortingCategory.getLocalizedName()));
            this.selectionList.refreshList();
        }));
        this.cancelButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.cancel"), onPress -> this.field_22787.method_1507(null)));
        this.teleportButton = (class_4185)this.method_37063((class_364)new TransparentButton(this.field_22789 - 120, 10, 110, 20, (class_2561)new class_2588("string.explorerscompass.teleport"), onPress -> this.teleport()));
        this.searchButton.field_22763 = false;
        this.searchForGroupButton.field_22763 = false;
        this.teleportButton.field_22764 = ExplorersCompass.canTeleport;
    }

    private void setupTextFields() {
        this.searchTextField = new TransparentTextField(this.field_22793, this.field_22789 / 2 - 82, 10, 140, 20, (class_2561)new class_2588("string.explorerscompass.search"));
        this.method_37063((class_364)this.searchTextField);
    }
}

